import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/**
 * This servlet implements the reading part of the MessageBoards for the PC
 * All PC members can read messages posted for a particular paper group (if 
 * they have been assigned that paper to review) thru this servlet
 *
 * @author Aameek Singh
 * @version 1.00, Fri Sep 29 17:34:55 IST 2000
 */

/* Extension Possible: Let the reviewer post to ANY OF HIS paper group or ALL
 *                     rather than only this paper or ALL */


public class MessageBoard extends HttpServlet {

	 /**
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /**
	  * Fetches all the new messages for the reviewer which were meant for
	  * this paper 
	  * @param req HttpServletRequest
	  * @param req HttpServletResponse
	  */
	 public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Checking that the user is Admin or Reviewer only.*/
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Reviewer") || whoisit.equalsIgnoreCase("Admin")))) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  int paperId=Integer.parseInt(req.getParameter("paperId"));
		  String ID=(String)session.getValue("ID");   /* Id of the user */


		  Connection con=null;
		  try {
			   /* Open a DB Connection */
			   con=DB.getConnection(); 

			   ShowStuff.printHeader("Message Board: "+paperId,out);
			   out.println("<body>");

			   out.println("<table align=left border=1>");

			   /* Get all the new messages and print them in a table */
			   Statement st=con.createStatement();
			   String query="SELECT CONTENT,POSTEDBY,POSTINGDATE,MESSAGE.MESGID FROM MESSAGE, NEWMESSAGE WHERE (MESSAGE.PAPERID="+paperId+") AND (MESSAGE.MESGID=NEWMESSAGE.MESGID) AND (NEWMESSAGE.ID='"+ID+"')";

			   ResultSet rs=st.executeQuery(query);
			   ResultSetMetaData rt=rs.getMetaData();
			   Stack newMsgId=new Stack();
			   out.println("<tr><th>Posted By</th><th>Date of Posting</th><th>Message</th></tr>");
			   while (rs.next()) {
					newMsgId.push(rs.getString(4));
					out.println("<tr><td> "+rs.getString(2)+" </td><td> "+rs.getString(3)+" </td><td> "+rs.getString(1)+" </td></tr>");
			   }
			   if (newMsgId.empty()) {
					out.println("<tr><td>No New Messages</td></tr>");
			   } else {    /* The read messages are then deleted from NEWMESSAGES table */
					String delStatement="DELETE FROM NEWMESSAGE WHERE (ID='"+ID+"') ";
					int i=0;
					String tmp="";
					while (!newMsgId.empty()) {
						 i++;
						 if (i==1) {
							  tmp+=" (MESGID="+Integer.parseInt((String)newMsgId.pop())+") ";
						 } else {
							  tmp+=" OR (MESGID="+Integer.parseInt((String)newMsgId.pop())+") ";
						 }
					}
					if (i==1) {
						 delStatement+=" AND "+tmp;
					} else {
						 delStatement+=" AND ("+tmp+" )";
					}
					st.executeUpdate(delStatement);

			   }

			   con.close();  /* Close the connection */

			   /* Print a form for posting a message to this paper or ALL grps.*/
			   out.println("</table><br><br><br><br><br><hr size=1><br>");
			   out.println("<font color=blue>Post A Message</font>");
			   ShowStuff.formTag("get","http://"+Config._HOST+":"+Config._PORT+"/servlet/PostMessage",out);
			   out.println("<select name=\"paperId\">");
			   out.println("<option value=\"0\">All</option>");
			   out.println("<option value=\""+paperId+"\">This Paper</option>");
			   out.println("</select>");
			   ShowStuff.submitButton("Post",out);
			   out.println("</form>");
			   ShowStuff.printFooter(out);

		  } catch (SQLException e) { ShowStuff.throwError("Database Access Error",out); if (con != null) { con=null;} }
	 }
}
