import java.io.*;
import java.util.*;
import javax.servlet.*;
import java.lang.*;
import javax.servlet.http.*;
import java.sql.*;
import util.*;

/** This class will be used at Configuration time to generate the HTML form that 
 * will be used for the registration and upload procedure of papers. The format is 
 * primitive and will be refined later.
 *
 * @author     Anjali Gupta
 * @version    1.00, Wed Oct  4 00:13:35 IST 2000
 */


class PaperPage 
{
	 
	 static String[] PersonAttributes, AuthorAttributes, PaperAttributes, AuthoredByAttributes;
     static int NoOfAuthors;
	 
	 /** The main procedure first opens a connection with the database, and checks out
	  * the tables into which information has to be stored. The attributes names of
	  * these tables have been stored in arrays of the same name as the table followed
	  * by the word "Attributes".
	  */
	 
	 public static void main(String[] args)
		  throws IOException, Exception
		  {
			   try
			   {
					// Opens connection with the database.
					//Class.forName(Config._DRIVERTYPE);
					//Connection con = DriverManager.getConnection(Config._CONNECTIONSTRING, Config._USERID,Config._PASSWD);
					
					Connection con = DB.getConnection();
					ResultSet rs;
					ResultSetMetaData rsmd;
					
					Statement st = con.createStatement();
				    
					/* This file will be stored in the html repository.*/
					FileWriter out = new FileWriter(Config._HTML_REPOSITORY+"PaperReg.html");
				    PrintWriter pw = new PrintWriter(out);
					
					/* Start extracting number and type information of the columns
					 * from the tables*/

					rs = st.executeQuery("SELECT * FROM PERSON");
					rsmd = rs.getMetaData();
					int NoOfAttributes =rsmd.getColumnCount();  
					PersonAttributes = new String[NoOfAttributes];
					for (int i=0; i<NoOfAttributes; i++)
						 PersonAttributes[i] = rsmd.getColumnName(i+1);

					rs = st.executeQuery("SELECT * FROM AUTHOR");
					rsmd = rs.getMetaData();
					NoOfAttributes =rsmd.getColumnCount(); 
					AuthorAttributes = new String [NoOfAttributes];
					for (int i=0; i<NoOfAttributes; i++)
						 AuthorAttributes[i] = rsmd.getColumnName(i+1);

					rs = st.executeQuery("SELECT * FROM PAPER");
					rsmd = rs.getMetaData();
					NoOfAttributes =rsmd.getColumnCount();  
					PaperAttributes = new String [NoOfAttributes];
					for (int i=0; i<NoOfAttributes; i++)
						 PaperAttributes[i] = rsmd.getColumnName(i+1);

					rs = st.executeQuery("SELECT * FROM AUTHOREDBY");
					rsmd = rs.getMetaData();
					NoOfAttributes =rsmd.getColumnCount();  
					AuthoredByAttributes = new String [NoOfAttributes];
					for (int i=0; i<NoOfAttributes; i++)
						 AuthoredByAttributes[i] = rsmd.getColumnName(i+1);


			   NoOfAuthors = Config._NO_OF_AUTHORS;
			   
			   // Start printing out the form.
			   ShowStuff.printHeader("Paper Registration",pw);
			   pw.println("</td></tr><tr><td colspan=3><font size=0 class=TDFONT><p>Please fill in the details below and submit the form.");
			   pw.println("<p>The fields indicated with an asterisk (<b>*</b>) are required.<br><p><hr></td></tr>");

			   pw.println("<form name=\"GetReg\" method=\"post\" action=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/PaperRegistration\">");

			   // The attributes PaperID and FileLoc are decided by the software
			   // and we must not ask for that information from the author.

			   for(int i=0; i< PaperAttributes.length; i++)
			   {
					if (!((((PaperAttributes[i].equalsIgnoreCase("PAPERID"))
							  || (PaperAttributes[i].equalsIgnoreCase("Password")))
							  || (PaperAttributes[i].equalsIgnoreCase("extn")))
							  || (PaperAttributes[i].equalsIgnoreCase("FileLoc"))))
					{
						 ShowStuff.textBox(PaperAttributes[i].toLowerCase(),30,60,pw);
					}
			   }
			   
			   
			   pw.println("<tr><td><p><font size=2 class=TDFONT><b>CONTACT AUTHOR</b></font><p></td></tr>");
			   
			   for(int i=0; i< PersonAttributes.length; i++)
					ShowStuff.textBox("contact-"+PersonAttributes[i].toLowerCase(),30,60,pw);
			   

               for (int i=0; i<AuthoredByAttributes.length; i++)
						 {
							  if (!(((AuthoredByAttributes[i].equalsIgnoreCase("email"))
												  || (AuthoredByAttributes[i].equalsIgnoreCase("PaperID")))
											 || (AuthoredByAttributes[i].equalsIgnoreCase("isContact"))))
							  {
								   ShowStuff.textBox("contact-"+AuthoredByAttributes[i].toLowerCase(),30,60,pw);
							  }
						 }

			   for (int i=0; i<AuthorAttributes.length; i++)
			   {
					if (!((AuthorAttributes[i].equalsIgnoreCase("email")) || (AuthorAttributes[i].equalsIgnoreCase("name"))))
						 ShowStuff.textBox("contact-"+AuthorAttributes[i].toLowerCase(),30,60,pw);
			   }
			  
			   for (int j=0; j< Config._NO_OF_AUTHORS; j++)
			   {
					for (int i=0; i<AuthorAttributes.length; i++)
					{
						 ShowStuff.textBox("author-"+AuthorAttributes[i].toLowerCase()+j,30,60,pw);
					}

					for (int i=0; i<AuthoredByAttributes.length; i++)
						 {
							  if (!(((AuthoredByAttributes[i].equalsIgnoreCase("email"))
												  || (AuthoredByAttributes[i].equalsIgnoreCase("PaperID")))
											 || (AuthoredByAttributes[i].equalsIgnoreCase("isContact"))))
							  {
								   ShowStuff.textBox("author-"+AuthoredByAttributes[i].toLowerCase()+j,30,60,pw);
							  }
						 }

			   }
								   
			   pw.println("<tr><td><input type=\"submit\" name=\"go\" value=\"RegisterNow\"> </td></tr></center></form>");

			   ShowStuff.printFooter(pw);
			   out.close();
			   con.close();
             } catch (SQLException sqle)
			   { 
					System.out.println(sqle); 
					//ShowStuff.throwError("ERROR","The following exception occured in the processing of your query <br></br>"+sqle,pw);
			        //if (con != null) con.close();
			   }

		  }
}
