import java.io.*;
import java.util.*;
import javax.servlet.*;
import java.lang.*;
import javax.servlet.http.*;
import java.sql.*;
import util.*;


/** This servlet requests all relevant author and paper information and stores it into 
 *  database tables. It then generates an HTML page which allows upload of the paper. A 
 *  login and password are provided at this point. 
 *  NOTE: The userId for contact-author will be the paperId given to him for
 *        that paper.  
 *
 *  @author    Anjali Gupta 
 *  @version   1.00, Tue Oct  3 23:09:22 IST 2000  
 */


public class PaperRegistration extends HttpServlet
{
	 String[] PersonAttributes, AuthorAttributes, PaperAttributes, AuthoredByAttributes,KeywordsAttributes;

	 /** Initialize the Servlet, get table and column information and store it in 
	  * arrays for use in "service"
	  *
	  * @param ServletConfig config
	  */

	 public void init (ServletConfig config) 
		  throws ServletException
		  {
			   super.init(config);

			   Connection con = null;
			   try
			   {    
					/* Opens connection with database from the values stored in class Config*/

					con = DB.getConnection();
					ResultSet rs;
					ResultSetMetaData rsmd;
					Statement st = con.createStatement();

					/* Get the names of all columns in person table */

					rs = st.executeQuery("SELECT * FROM PERSON");
					rsmd = rs.getMetaData();
					int NoOfAttributes = rsmd.getColumnCount();
					PersonAttributes = new String[NoOfAttributes];
					for (int i=0; i<NoOfAttributes; i++)
						 PersonAttributes[i] = rsmd.getColumnName(i+1);

					rs = st.executeQuery("SELECT * FROM AUTHOR");
					rsmd = rs.getMetaData();
					NoOfAttributes =rsmd.getColumnCount(); 
					AuthorAttributes = new String [NoOfAttributes];
					for (int i=0; i<NoOfAttributes; i++)
						 AuthorAttributes[i] = rsmd.getColumnName(i+1);

					rs = st.executeQuery("SELECT * FROM PAPER");
					rsmd = rs.getMetaData();
					NoOfAttributes =rsmd.getColumnCount();  
					PaperAttributes = new String [NoOfAttributes];
					for (int i=0; i<NoOfAttributes; i++)
						 PaperAttributes[i] = rsmd.getColumnName(i+1);

					rs = st.executeQuery("SELECT * FROM AUTHOREDBY");
					rsmd = rs.getMetaData();
					NoOfAttributes =rsmd.getColumnCount();  
					AuthoredByAttributes = new String [NoOfAttributes];
					for (int i=0; i<NoOfAttributes; i++)
						 AuthoredByAttributes[i] = rsmd.getColumnName(i+1);

					rs = st.executeQuery("SELECT * FROM KEYWORDS");
					rsmd = rs.getMetaData();
					NoOfAttributes =rsmd.getColumnCount();  
					KeywordsAttributes = new String [NoOfAttributes];
					for (int i=0; i<NoOfAttributes; i++)
						 KeywordsAttributes[i] = rsmd.getColumnName(i+1);
                    
					File PaperDir=new File(Config._FILE_REPOSITORY);
					if (!PaperDir.exists()) {
						 PaperDir.mkdirs();
					}

					con.close();
			   } catch (SQLException sqle)
			   {
					System.out.println(sqle); 

					// if the db conn is still open, it needs to be closed!
					if (con != null) con = null;
			   }
		  }

	 /** This function accepts the information sent in from the form in  PaperReg.html
	  *
	  * @param HttpServletRequest request
	  * @param HttpServletResponse response
	  */

	 public void service (HttpServletRequest request, HttpServletResponse response)
		  throws ServletException, IOException

		  {
			   Connection con = null;
			   PrintWriter pw = response.getWriter();

			   try
			   {
					con = DB.getConnection();
					PreparedStatement prepst=null; 
					String update="";
					Statement st = con.createStatement();
					ResultSet rs;
					ResultSetMetaData rsmd;

					/* Finds the number of papers stored. The next paperID will be the
					 * increment of this count*/
					rs = st.executeQuery("SELECT COUNT(*) FROM PAPER");
					int PaperCount = 0;

					while (rs.next())
					{
						 PaperCount = Integer.parseInt(rs.getString(1)); 
					}

					PaperCount ++;
					System.out.println(PaperCount); 

					/* Start extracting values from the document and storing into 
					 * appropriate tables */
					update="INSERT INTO PAPER values(";
					for (int i=0; i<PaperAttributes.length;i++) {
						 update += (i==0) ? "" : ",";
						 update +="?";
					}
					update += ")";
					prepst=con.prepareStatement(update);
					for (int i=0; i<PaperAttributes.length; i++) 
					{
						 //All other attributes come from the document - PaperID is assigned.
						 if (PaperAttributes[i].equalsIgnoreCase("PaperID"))
							  prepst.setInt(i+1,PaperCount);
						 else 
						 {
							  if (PaperAttributes[i].equalsIgnoreCase("Password"))
								   prepst.setString(i+1,""+PaperCount);
							  else 
							  {
								   //default extension is .txt : will be updated in the Upload servlet
								   if (PaperAttributes[i].equalsIgnoreCase("Extn"))
										prepst.setString(i+1,"txt");
								   else prepst.setString(i+1,request.getParameter(PaperAttributes[i].toLowerCase()));
							  }
						 }
					}

					prepst.executeUpdate();

					/* Check if there is already an entry by the name of the contact author
					 * if yes, another entry is not made in the person table. The rest
					 * of the insertions continue unhindered */

					String ContactEmail = request.getParameter("contact-email");
					rs = st.executeQuery("SELECT * FROM PERSON WHERE EMAIL='"+ContactEmail+"'");
					int Count = 0;

					while (rs.next())
					{   
						 Count++;  
					}

					//If there are no such entries, insert ...
					if (Count == 0)
					{
						 update="INSERT INTO PERSON values(";
						 for (int i=0; i<PersonAttributes.length;i++) {
							  update += (i==0) ? "" : ",";
							  update +="?";
						 }
						 update += ")";
						 prepst=con.prepareStatement(update);
						 for (int i=0; i<PersonAttributes.length; i++) 
						 {
							  prepst.setString(i+1,request.getParameter("contact-"+PersonAttributes[i].toLowerCase()));
						 }
						 prepst.executeUpdate();
					}

					update="INSERT INTO AUTHOR values(";
					for (int i=0; i<AuthorAttributes.length; i++) {
						 update += (i==0) ? "" : ",";
						 update += "?";
					}
					update += ")";
					prepst=con.prepareStatement(update);

					//author values for contact
					rs = st.executeQuery("SELECT * FROM AUTHOR WHERE EMAIL='"+request.getParameter("contact-email")+"'");
					Count = 0;
					while (rs.next())
					{   Count++;  }


					if (Count == 0)
					{
						 for (int i=0; i<AuthorAttributes.length; i++) 
						 { 
							  prepst.setString(i+1,request.getParameter("contact-"+AuthorAttributes[i].toLowerCase()));
						 }
						 prepst.executeUpdate();
					}

					//author values for other authors
					for (int j=0; j<(Config._NO_OF_AUTHORS - 2); j++)
					{
						 if (!((request.getParameter("author-email"+j)).equals("")))
						 {
							  rs = st.executeQuery("SELECT * FROM AUTHOR WHERE EMAIL='"+request.getParameter("author-email"+j)+"'");
							  Count = 0;
							  while (rs.next())
							  { Count ++;}
							  if (Count == 0)
							  {
								   update="INSERT INTO AUTHOR values(";
								   for (int i=0; i<AuthorAttributes.length; i++) {
										update += (i==0) ? "" : ",";
										update += "?";
								   }
								   update += ")";
								   prepst=con.prepareStatement(update);
								   for (int i=0; i<AuthorAttributes.length; i++) 
								   {
										prepst.setString(i+1,request.getParameter("author-"+AuthorAttributes[i].toLowerCase()+j));

								   }
								   prepst.executeUpdate();
							  }
						 }
					}
					update="INSERT INTO AUTHOREDBY values(";
					for (int i=0; i<AuthoredByAttributes.length; i++) {
						 update += (i==0) ? "" : ",";
						 update += "?";
					}
					update += ")";
					prepst=con.prepareStatement(update);

					for (int i=0; i<AuthoredByAttributes.length; i++) 
					{
						 if (AuthoredByAttributes[i].equalsIgnoreCase("PaperID"))
							  prepst.setInt(i+1, PaperCount);
						 else
						 {
							  if (AuthoredByAttributes[i].equalsIgnoreCase("isContact"))
								   prepst.setInt(i+1, 1);
							  else prepst.setString(i+1,request.getParameter("contact-"+AuthoredByAttributes[i].toLowerCase()));
						 }
					}
					prepst.executeUpdate();
					for (int j=0; j<(Config._NO_OF_AUTHORS - 2); j++)
					{
						 if ((request.getParameter("author-email"+j)).equalsIgnoreCase("")) continue;
						 for (int i=0; i<AuthoredByAttributes.length; i++) 
						 {
							  if (AuthoredByAttributes[i].equalsIgnoreCase("PaperID"))
								   prepst.setInt(i+1, PaperCount);
							  else
							  {
								   if (AuthoredByAttributes[i].equalsIgnoreCase("isContact"))
										prepst.setInt(i+1, 0);
								   else prepst.setString(i+1,request.getParameter("author-"+AuthoredByAttributes[i].toLowerCase()+j));
							  }
						 }
						 prepst.executeUpdate();
					}

					for (int m=0; m<=4; m++)
					{
						 update="INSERT INTO KEYWORDS values(";
						 for (int i=0; i<KeywordsAttributes.length;i++) {
							  update += (i==0) ? "" : ",";
							  update +="?";
						 }
						 update += ")";
						 prepst=con.prepareStatement(update);
						 for (int i=0; i<KeywordsAttributes.length; i++) 
						 {
							  if (KeywordsAttributes[i].equalsIgnoreCase("PaperID"))
							  {
								   prepst.setInt(i+1,PaperCount);
							  }
							  else
							  {
								   prepst.setString(i+1,request.getParameter("keyword"+m));
							  }
						 }
						 prepst.executeUpdate();
					}
					/* Now generate the HTML page for file upload */
					response.setContentType("text/html");

					ShowStuff.printHeader("Registration Done",pw);

					pw.println("<font size=2 class=TDFONT><b> It is now time to upload your paper <b></font>");
					pw.println("<form name=\"SelectQuery\" method=\"post\" enctype=\"multipart/form-data\" action=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/Upload\">");
					pw.println("<br> </br>");
					pw.println("<center> <input type=\"file\" name=\"filename\" size=30> </center> <br> </br>");
					pw.println("<center><input type=\"submit\" value=\"upload\"></center> </form>");

					ShowStuff.printFooter(pw);

					con.close();
			   } catch (SQLException sqle)
			   {  
					response.setContentType("text/html");
					ShowStuff.printHeader("Error",pw);
					ShowStuff.throwError("ERROR","The following exception occured in the processing of your query <br></br>"+sqle,pw);
					ShowStuff.printFooter(pw);
					if (con != null) con=null;
			   }

		  }
}








