import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/**
 * This servlet implements the posting part of the MessageBoards for the PC
 * In the doGet method it prints the form to get the Message to be posted and 
 * then submits the form to this very servlet only
 * In the doPost method it stores the message in the DB.
 *
 * 
 * @author Aameek Singh
 * @version 1.00, Fri Sep 29 18:03:17 IST 2000
 */

public class PostMessage extends HttpServlet {
     
	 /** 
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /** 
	  * Print the form to get content of the message to be posted 
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("reviewer") || whoisit.equalsIgnoreCase("Admin")))) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }
          
		  /* Get the paperId to which this message is referred to. "0" represents that it
		   * is for ALL paper groups */
		  int paperId;

		  if (whoisit.equalsIgnoreCase("Admin")) {
			   paperId=(Integer.parseInt(req.getParameter("towhom"))==0)?0:Integer.parseInt(req.getParameter("paperId"));
		  } else {
			   paperId=Integer.parseInt(req.getParameter("paperId")); /* Messages for this paper-group */
		  }
		  String ID=(String)session.getValue("ID"); /* Get the posters ID */
          
		  /* Print form */
		  ShowStuff.printHeader("Post Message",out);
		  out.println("<body>");

		  ShowStuff.formTag("post","http://"+Config._HOST+":"+Config._PORT+"/servlet/PostMessage",out);
		  
		  out.println("<input type=\"hidden\" name=\"paperId\" value=\""+paperId+"\">");
		  out.println("<textarea name=\"content\" rows=10 cols=80></textarea>");
		  out.println("<br><br><input type=\"Submit\" value=\"Post\">");
		  out.println("</form>");
		  ShowStuff.printFooter(out);
	 }

	 /** 
	  * Store the message in the DB and make additions into the NEWMESSAGES table as well 
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("reviewer") || whoisit.equalsIgnoreCase("Admin")))) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  int paperId=Integer.parseInt(req.getParameter("paperId"));
		  String ID=(String)session.getValue("ID");

		  Connection con=null;
		  try {
               con=DB.getConnection();
			   Statement st=con.createStatement();

			   /* Get the MesgId to be given to this method ie 1 + last stored mesg's Id */
			   ResultSet rs=st.executeQuery("SELECT COUNT(*) FROM MESSAGE");
			   int cnt=0;
			   if (rs.next()) {
					cnt=Integer.parseInt(rs.getString(1));
			   }
			   cnt++;   /* New Message ID */

			   String messageInsStatement="INSERT INTO MESSAGE VALUES("+cnt+",?,"+paperId+",'"+ID+"',SYSDATE)";

			   /* Use prepared statement */
			   PreparedStatement pst=con.prepareStatement(messageInsStatement);
			   pst.setString(1,req.getParameter("content"));
			   pst.executeUpdate();

			   /* Make entry in NEWMESSAGES table as well */
			   String newMessageInsStatement="INSERT INTO NEWMESSAGE VALUES("+cnt+",?)";
			   String query;
			   if (paperId==0) {
					query="SELECT EMAIL FROM REVIEWER UNION SELECT EMAIL FROM ADMIN";
			   } else {
					query="SELECT EMAIL FROM FINALASSIGNMENTS WHERE PAPERID="+paperId;
			   }
			   rs=st.executeQuery(query);

			   while (rs.next()) {
					pst=con.prepareStatement(newMessageInsStatement);
					pst.setString(1,rs.getString(1));
					pst.executeUpdate();
			   }

               
			   con.close();    /* Close the connection */
			   /* Print OK page */
			   ShowStuff.printHeader("Message Posted",out);
			   out.println("<body>");
			   out.println("<font color=blue> Message has been posted </font><br><br><hr size=1>");
			   out.println("Click <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/"+Gen.getTargetServlet(whoisit)+"\">here</a> to go to your main page.<br><hr size=1>");
		       ShowStuff.printFooter(out);
		  } catch (SQLException e) { ShowStuff.throwError("Database Access Error",out); if (con != null) {con=null; } }
	 }
}
