import java.io.*;
import java.sql.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/**
 * This servlet takes the parameters from the ParticipantQuery.html file 
 * after submission by the user and executes a query to find all the 
 * participants who have same values on parameters as those entered by the
 * user.It displays only those parameters of the participant which have been
 * requested by the user in the form of checkboxes when he submits the 
 * ParticipantQuery.html file.
 * @author Kranthi Kumar
 * @version 1.00
 */

public class QueryParticipant extends HttpServlet {
  	public void init(ServletConfig config) throws ServletException {
	  	super.init(config);
	}

	public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
	{
	  	HttpSession session = req.getSession(false);
		res.setContentType("text/html");
		PrintWriter out = res.getWriter();
			String whoisit=(String)session.getValue("whoami");

			if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin"))) ) {
				throw new UnavailableException(this,"Invalid Access Attempt");
			}

		Connection con = null;
		String sqlquery=req.getParameter("sqlquery");
		
		if (sqlquery!=null && !sqlquery.equals(""))
		{
			
			serveSqlQuery(out, sqlquery);
			out.close();
		}
		else {
		try
		{

		       con = DB.getConnection();
		       Statement st = con.createStatement();
		       Hashtable paramType= new Hashtable(); 
		       String[] allParam = new String[100];
		       int paramCount = 0;  //the count of distinct parameters found till now.
		       
		       String universalRel = "SELECT * FROM PERSON,PARTICIPANT,BOOKINGS, PARTICIPATION, EVENTPARTICIPATION, PAYMENT, CREDITCARDPAYMENT, CHEQUEPAYMENT, DEMANDDRAFTPAYMENT WHERE PARTICIPANT.EMAIL=PERSON.EMAIL and PARTICIPANT.EMAIL=BOOKINGS.EMAIL and EVENTPARTICIPATION.EMAIL=PARTICIPANT.EMAIL and PARTICIPATION.EMAIL=PARTICIPANT.EMAIL and PAYMENT.EMAIL=PARTICIPANT.EMAIL";
		       
		       //This table universalRel contains the common attributes
		       //of the tables Person, Participant etc more than once.
		       //So, we have to get only the distinct attributes.
		       
		       ResultSet rs=st.executeQuery(universalRel);
		       ResultSetMetaData rsmd=rs.getMetaData();
		       int numParams = rsmd.getColumnCount();
		       String currParam=null;
		       
		       for(int i=1; i<=numParams; i++)
		       {
			      currParam=(String)rsmd.getColumnName(i);
			      if (paramType.get(currParam) == null)//not yet stored in the hashtable, so it is included in the distinct list.
			      {
				    allParam[paramCount] = currParam;
				    paramCount++;
			      }
		       	      paramType.put(currParam,new Integer(1));
		       }
		       
		       String attrList="", condition="",relationList="";
		       String[] relationArr = new String[50];
		       //The query to get the result would be "select attrList from relationList where condition"
		       //relationList is a comma separated list of relations in the query and relationArr is an array of those.
		       int noAttr=0, noRelations=0;
		       for(int i=0; i<paramCount; i++)
		       {
			      String param1, param2, relation;
			      param1 = req.getParameter(allParam[i].toLowerCase()+1);
			      param2 = removeBlank(req.getParameter(allParam[i].toLowerCase()+2));
			      relation = firstOccursIn(allParam[i]);
			      
			      if(param1 != null && param1.equalsIgnoreCase("1"))
			      {
				   if(attrList.equals("")) {
					attrList = relation+"."+allParam[i];
					noAttr++;
				   }
				    else 
				    {
				     	  attrList += ","+relation+"."+allParam[i];
					  noAttr++;
				    }
				    if (!alreadyExists(relation, relationArr, noRelations))
				    {
				      	   relationArr[noRelations] = relation;
					   noRelations++;
				    }
			      }
				    
			      if(!param2.equals(""))
			      {
				    if(condition.equals("")) 
				      	condition = relation+"."+allParam[i]+"='"+param2+"'";
				    else condition += " and "+ relation+"."+allParam[i] +"='"+param2+"'";
				    
				    if (!alreadyExists(relation, relationArr, noRelations))
				    {
				      	   relationArr[noRelations] = relation;
					   noRelations++;
				    }
			      }

		       }
		       String emailCondition = getEmailCondition(relationArr, noRelations);
		       
		       if(!emailCondition.equals(""))
			     if(!condition.equals(""))  
			    	    condition = emailCondition + " and " + condition;
		       	     else condition = emailCondition;
		       
		       relationList = getRelationList(relationArr, noRelations);
		       String query;
		       if(condition.equals(""))
			    query = "select distinct "+attrList+" from "+ relationList;
		       else 
			    query = "select distinct "+attrList+" from "+ relationList + " where "+ condition;
		       rs = st.executeQuery(query);
		       rsmd = rs.getMetaData();
		       ShowStuff.printHeader("Results of the Query!!",out);
		       out.println("<body>");
		       out.println("<table align=left>");
		       
		       int noTuples = 0;
		       
		       while(rs.next())
		       {
			     if(noTuples == 0)
			     {
			 	   int colCount = rsmd.getColumnCount();
		       		   out.println("<tr>");
		       		   for(int i=1; i<=colCount; i++)
			     		out.println("<th>"+rsmd.getColumnName(i)+"</th>");
		       		   out.println("</tr>");
			     }
			     out.println("<tr>");
			     for(int i=1; i<=noAttr; i++)
				   out.println("<td>"+rs.getString(i)+"</td>");
			     out.println("</tr>");
			     noTuples++;
		       }
		       if(noTuples == 0)
			      out.println("<font color=blue> There are no matches </font>");
		       out.println("</table>");
		       out.println("<br><br><br><br>");
		       ShowStuff.printFooter(out);
		       con.close();
		}
		
		catch(SQLException e) {System.out.println(e);}
	}
	}


   private static void serveSqlQuery(PrintWriter out, String sqlquery)
	{
      ShowStuff.printHeader("Query Results", out);
		Connection con=null;
		try
		{
			con=DB.getConnection();
			Statement stmt=con.createStatement();
			ResultSet rs=stmt.executeQuery(sqlquery);
			ResultSetMetaData rsmd=rs.getMetaData();
			int numCols=rsmd.getColumnCount();
			out.println("<br><br>");
			out.println("<br><br>");
			out.println("<table width=500 border=1 align=left>");
			out.println("<tr>");
			for (int i=1; i<=numCols; i++)
				out.println("<th>"+rsmd.getColumnName(i)+"</th>");
		   out.println("</tr>");
			while(rs.next())
			{
			   out.println("<tr>");
		   	for (int i=1; i<=numCols; i++)
					out.println("<td>"+rs.getString(i)+"</th>");
		      out.println("</tr>");
			}
			out.println("</table>");
		} 
		catch (SQLException sqle) {
            ShowStuff.throwError("Database Access Error or Incorrect Query!!", out);
				if(con!=null) {con=null; }
		}

			out.println("<br><br><br><br>");
			out.println("<br><br><br><br>");
		   out.println("Click <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/AdminServlet\">here</a> to go back to your mainpage.");
			ShowStuff.printFooter(out);
	}			
		
	
	public static String firstOccursIn(String attr)
	{
	  	String[] allRelations = {"PARTICIPANT","BOOKINGS","PARTICIPATION","EVENTPARTICIPATION","PAYMENT","CREDITCARDPAYMENT","CHEQUEPAYMENT","DEMANDDRAFTPAYMENT","PERSON"};
		int noRelations = allRelations.length;
		Connection con=null;
		String result="";
		int set=0;
		try
		{
		      con = DB.getConnection();
		      Statement st = con.createStatement();
		      ResultSet rs;
		      ResultSetMetaData rsmd;
		      for(int i=0; i<noRelations; i++)
		      {
			    rs = st.executeQuery("SELECT * FROM "+allRelations[i]); 
			    rsmd = rs.getMetaData();
			    int colCount = rsmd.getColumnCount();
			    for (int j=1; j<=colCount; j++)
			    {
			          String currAttr = (String)rsmd.getColumnName(j);
				  if (currAttr.equalsIgnoreCase(attr))
				  {
				    	result = allRelations[i];
					set = 1;
					break;
				  }
			    }
			    if (set == 1)
			      	  break;
		      }
		}
		catch(SQLException e) {System.out.println(e);}
		return(result);
	}

	public static boolean alreadyExists(String s, String[] arr, int count)
	{
	  	for(int i=0;i<count; i++)
		{
		  	if (arr[i].equalsIgnoreCase(s))
			  	return(true);
		}
		return(false);
	}

	public static String getEmailCondition(String[] relationArr, int count)
	{
	  	String result = "";
		for(int i=0; i<count-1; i++)
		     if(i==0) 
		  	   result += relationArr[i]+".EMAIL="+relationArr[i+1]+".EMAIL";
		     else
		       	   result += " and "+relationArr[i]+".EMAIL="+relationArr[i+1]+".EMAIL";
		return(result);
	}

	public static String getRelationList(String[] relationArr, int count)
	{
	  	String result = "";
		for(int i=0; i<count; i++)
		      if(i==0)
			    result = relationArr[i];
		      else 
			    result += ","+relationArr[i];
		return(result);
	}

	public static String removeBlank(String str) //removes the leading and trailing blank in the string str.
	{
	  	char[] resultArr1 = new char[200];
		int j = 0;
		if (str == null)
		     return("");
		for(int i=0; i < str.length(); i++)
		{
		      if(str.charAt(i) != ' ') {
			     resultArr1[j] = str.charAt(i); 
			     j++;
		      }
		}
		char[] resultArr2 = new char[j];
		if(j==0)
		      return("");
		for(int i=0; i<j; i++)
		      resultArr2[i] = resultArr1[i];	
		return(new String(resultArr2));
	}
}
