import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/** 
 * This servlet takes the reviewer to his main page. 
 * Details of all papers he is to review are on the main page. Any 
 * messages for all PC members are on the main page. Link to read
 * and post paper-specific messages is on main page. Link to Submit
 * a review and Download a paper are also there.
 *
 * @author Mithun Arora
 * @version 1.00 Oct 6 20:45:41 IST 2000
 *
 */

public class Reviewer2Servlet extends HttpServlet {

	 /* Initialise the servlet */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /** Generates the mainpage after reading details for the reviewer from
	  * the database, and provides links to all necassary servlets.
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */

	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(true);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity. Only reviewers allowed */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Reviewer"))) ) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  Connection con=null;
		  String ID=(String)session.getValue("ID");

		  try {
			   con=DB.getConnection();
			   ShowStuff.printHeader("Welcome!",out);
			   out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/ChangePassword\">Change Password</a></td></tr");
			   out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/LogoutServlet\">Logout</a></td></tr>");
			   out.println("<tr><td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/MailServlet\">Send Mail</a></td></tr>");
			   out.println("</table>");
			   out.println("<p><hr><br><font class=TITLEFONT size=3 color=blue>New Messages</font><br>");
			   out.println("<table width=600 border=0 cellspacing=1 cellpadding=1>");


			   Statement stmt=con.createStatement();
			   ResultSet rs=null;
			   String query=null;
			   ResultSetMetaData rsmd=null;

			   //Printing all the new messages...

			   query="SELECT CONTENT, POSTEDBY, POSTINGDATE, MESSAGE.MESGID FROM MESSAGE, NEWMESSAGE WHERE (MESSAGE.PAPERID=0) AND (MESSAGE.MESGID=NEWMESSAGE.MESGID) AND NEWMESSAGE.ID='"+ID+"'";
			   rs=stmt.executeQuery(query);
			   rsmd=rs.getMetaData();
			   /* All new messages which are read by this reviewer are to be deleted
				* from NewMessages table. Hence while reading the messages, their
				* IDs are pushed into a stack and finally deleted. 
				*/ 
			   Stack newMsgId=new Stack();
			   out.println("<tr><font class=TDFONT size=2><td width=85>Posted By</td><td width=85>Date of Posting</td><td width=450>Message</td></font></tr>");

			   int resultNo = 1;
			   while (rs.next()) 
			   { 
					/* to display messages in proper table format before printing the 
					 * 1st message. */
					if (resultNo == 1) 
					{
						 //	out.println("<font size=3> New Messages </font><br><br>");
						 //	out.println("<table>");
						 //	out.println("<tr><th>Posted By</th><th>Date of Posting</th><th>Message</th></tr>");
					}
					newMsgId.push(rs.getString(4));
					//out.println("<tr><td> "+rs.getString(2)+" </td><td> "+rs.getString(3)+" </td><td> "+rs.getString(1)+" </td></tr>");
					out.println("<tr><font class=TDFONT size=1><td width=50> "+rs.getString(2)+" </td><td width=50> "+rs.getString(3)+" </td><td width=500> "+rs.getString(1)+" </td></font></tr>");
					resultNo++;
			   }
			   out.println("</table><p>");

			   if (newMsgId.empty()) 
			   {
					//out.println("<tr><td>No New Messages</td></tr>");
					//out.println("</table>");
					out.println("<table width=600 border=0 cellspacing=1 cellpadding=1><tr><td><font size=2 class=TITLEFONT>No New Messages</font></td></tr></table><p><br>");


			   } 
			   else 
			   {    /* The read messages are then deleted from NEWMESSAGES table */
					String delStatement="DELETE FROM NEWMESSAGE WHERE (ID='"+ID+"') ";
					int i=0;
					String tmp="";
					while (!newMsgId.empty())
					{
						 i++;
						 if (i==1) 
						 {
							  tmp+=" (MESGID="+Integer.parseInt((String)newMsgId.pop())+") ";
						 } 
						 else
						 {
							  tmp+=" OR (MESGID="+Integer.parseInt((String)newMsgId.pop())+") ";
						 }
					}
					if (i==1) 
					{
						 delStatement+=" AND "+tmp;
					}
					else
					{
						 delStatement+=" AND ("+tmp+" )";
					}
					stmt.executeUpdate(delStatement);
					out.println("</table>");
					//out.println("<br><br>");
			   }

			   /* For posting messages to all PC members. 
				  out.println("<input type=\"Submit\" value=\"Post\">");
				  out.println("</form>");*/
			   out.println("<hr><br><table width=600 border=0 cellspacing=0 cellpadding=0>");
			   out.println("<tr><td><font class=TITLEFONT size=3 color=blue>Post A Message</font></td></tr><tr><td>");
			   ShowStuff.formTag("get", "http://"+Config._HOST+":"+Config._PORT+"/servlet/PostMessage",out);
			   out.println("<input type=\"hidden\" name=\"paperId\" value=\"0\">");
			   ShowStuff.submitButton("Post",out);
			   out.println("</form>");
			   out.println("</td></tr></table>");
			   out.println("<br>");
			   out.println("<hr size=1><br><p>");



			   /* Getting details about papers this reviewer is supposed to review
				* and showing them. */
			   query="SELECT PAPER.PaperId,Title,PAPER.EXTN FROM FINALASSIGNMENTS, PAPER WHERE (EMAIL='"+ID+"') AND (PAPER.PaperId=FINALASSIGNMENTS.PaperId)";

			   rs=stmt.executeQuery(query);
			   /* Finally printing of details is done by reading from the hashtables.
				* this is to optimise on another query about whether individual
				* papers have been reviewed. So while reading from ResultSet,
				* details are stored in the HashTables. */
			   Hashtable paperRev=new Hashtable(); /* To store whether this paper is reviewed or not.*/
			   Hashtable paperTitle= new Hashtable(); /* To store title of paper.*/ 
			   Hashtable paperExtn=new Hashtable(); /* To store extension of the paper. */

			   while(rs.next())
			   {
					paperExtn.put(rs.getString("PaperId"), rs.getString("Extn"));
					paperTitle.put(rs.getString("PaperId"), rs.getString("Title"));
					paperRev.put(rs.getString("PaperId"), "<font color=red>Not Reviewed</font>");
			   }

			   // checking for papers that have been reviewed, so that
			   // an appropriate message can be given.
			   query="SELECT PAPERID FROM REVIEW WHERE EMAIL='"+ID+"'";
			   rs=stmt.executeQuery(query);
			   while(rs.next())
			   {
					paperRev.put(rs.getString("PaperId"), "<font color=green>Reviewed</font>");
			   }
			   /* Printing the details... */
			   Enumeration paperElmts=paperRev.keys();
			   out.println("<table border=1 align=left>");
			   out.println("<tr><th>PaperId</th><th>Title</th><th>Abstract</th><th>Download Paper</th><th>Review Status</th><th>Submit/Update Review</th><th>Read Messages</th><th>Post Messages</th></tr>");

			   while(paperElmts.hasMoreElements())
			   {
					String currpaper=(String)paperElmts.nextElement();
					out.println("<tr><td>"+currpaper+"</td>");
					out.println("<td>"+(String)paperTitle.get(currpaper)+"</td>");

					out.println("<td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/GetAbstract?paperId="+currpaper+"\">Abstract</a> </td>"); 

					out.println("<td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/Download?filename="+Config._FILE_REPOSITORY+currpaper+"."+((String)paperExtn.get(currpaper))+"\">Download Paper</a> </td>"); 

					out.println("<td>"+(String)paperRev.get(currpaper)+"</td>");

					out.println("<td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/SubmitReview?paperId="+currpaper+"\">Submit Review</a> </td>"); 

					out.println("<td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/MessageBoard?paperId="+currpaper+"\">Read Messages for this paper</a> </td>"); 

					out.println("<td><a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/PostMessage?paperId="+currpaper+"\">Post Messages for this paper</a> </td>"); 
			   }
			   out.println("</tr></table><br><br>");
			   out.println("<br> <br>");  
			   ShowStuff.printFooter(out);
			   con.close();
		  } catch (SQLException e) { ShowStuff.throwError("Database Access Error",out); if (con != null) {con =null; } }
	 }
}
