import java.io.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/**
 * This servlet is the interface for the PC Chair (Admin) to change 
 * the paper-submission or participant-registration deadlines
 *  @author Aameek Singh
 *  @version 1.00, Sun Nov 12 16:54:31 IST 2000
 */

public class ShiftDeadline extends HttpServlet {
     
	 /** 
	  * Initialise the servlet 
	  * @param config ServletConfig
	  */
	 public void init(ServletConfig config) throws ServletException {
		  super.init(config);
	 }

	 /**
	  * Present the form asking for new deadlines
	  * @param res HttpServletResponse
	  * @param req HttpServletRequest
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(false);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity. Only admin allowed */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin"))) ) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ID=(String)session.getValue("ID");

		  ShowStuff.printHeader("Shift Deadline",out);

		  out.println("<body>");
		  ShowStuff.formTag("post","http://"+Config._HOST+":"+Config._PORT+"/servlet/ShiftDeadline",out);

		  out.println("<select name=\"which\">");
		  out.println("<option value=\"0\"> Paper Submission Deadline </option>"); 
		  out.println("<option value=\"1\"> Participant Registration Deadline </option>"); 
		  out.println("</select><br><br>");
		  out.println("New Date (dd-mmm-yyyy): ");
		  out.println("<input type=\"text\" name=\"date\" size=\"30\">");
		  out.println("<input type=\"Submit\" value=\"Shift\">");
		  out.println("</form>");
		  ShowStuff.printFooter(out);
	 }
     
	 /**
	  * Make changes in DB
	  * @param res HttpServletResponse
	  * @param req HttpServletRequest
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		  HttpSession session=req.getSession(false);
		  res.setContentType("text/html");
		  PrintWriter out=res.getWriter();

		  /* Check session validity. Only admin allowed */
		  String whoisit=(String)session.getValue("whoami");

		  if ( (whoisit==null) || (!(whoisit.equalsIgnoreCase("Admin"))) ) {
			   throw new UnavailableException(this,"Invalid Access Attempt");
		  }

		  String ID=(String)session.getValue("ID");
		
		  int which=Integer.parseInt(req.getParameter("which"));
		  String newDeadline=req.getParameter("date");
		  
		  Connection con=null;
		  try {
			   con=DB.getConnection();
			   Statement st=con.createStatement();
			   st.executeUpdate("UPDATE DEADLINE SET DLINE='"+newDeadline+"' WHERE VAL="+which);
                 
			   ShowStuff.printHeader("Deadlines Shifted",out);
			   out.println("The Deadlines have been changed.<br>");
			   out.println("Click <a href=\"http://"+Config._HOST+":"+Config._PORT+"/servlet/AdminServlet\"> here </a> to go to your main page ");
			   ShowStuff.printFooter(out);
						 
			   
		  } catch (SQLException e) { ShowStuff.throwError("Error",out); if (con != null) con=null; }
	 }
}
