import java.io.*;
import java.sql.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import util.*;

/**
 * This servlet takes an integer i from the user and executes the query 
 * numbered i in the array standardQuery and displays the results.
 * @author Kranthi Kumar
 * @version 1.00
 */
public class StandardQuery extends HttpServlet {
  	public void init(ServletConfig config) throws ServletException {
	  	super.init(config);
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
	{
	  	HttpSession session = req.getSession(false);
		res.setContentType("text/html");
		PrintWriter out = res.getWriter();
		Connection con = null;
		String queries[] = {
		  		    "SELECT EMAIL FROM PARTICIPANT",
		  		    "SELECT PERSON.EMAIL, NAME FROM PARTICIPANT,PERSON WHERE PARTICIPANT.EMAIL=PERSON.EMAIL",
				    "SELECT PERSON.EMAIL,NAME,FIRSTLINE,CITY,STATE,PHONE,FAX FROM PARTICIPANT, PERSON WHERE PERSON.EMAIL = PARTICIPANT.EMAIL",
				    "SELECT EMAIL, NAMEONTAG, AFFILIATIONONTAG, INSTITUTIONONTAG FROM PARTICIPANT",
				    "SELECT EMAIL, HOTEL FROM BOOKINGS",
				    "SELECT * FROM BOOKINGS",
				    "SELECT PERSON.EMAIL, PERSON.NAME, PROGRAM.NAME, PROGRAM.PROGRAMID FROM PERSON, PROGRAM, PARTICIPATION WHERE PERSON.EMAIL = PARTICIPATION.EMAIL AND PROGRAM.PROGRAMID = PARTICIPATION.PROGRAMID",
				    "SELECT PERSON.EMAIL, PERSON.NAME, EVENT.NAME, EVENT.EVENTID FROM PERSON, EVENT, EVENTPARTICIPATION WHERE PERSON.EMAIL = EVENTPARTICIPATION.EMAIL AND EVENT.EVENTID = EVENTPARTICIPATION.EVENTID",
				    "SELECT PERSON.EMAIL, MADEPAYMENT FROM PERSON, PAYMENT WHERE PAYMENT.EMAIL = PERSON.EMAIL",
				    "SELECT PERSON.EMAIL, AMOUNT, CURRENCY, PAYMENTMODE FROM PERSON,PAYMENT WHERE PERSON.EMAIL = PAYMENT.EMAIL",
				    "SELECT * FROM CHEQUEPAYMENT",
				    "SELECT * FROM DEMANDDRAFTPAYMENT",
				    "SELECT * FROM CREDITCARDPAYMENT"
		};
		
		int queryNo = Integer.parseInt((String)(req.getParameter("query")));
		try
		{
		  	con = DB.getConnection();
			Statement st = con.createStatement();
			ResultSet rs = st.executeQuery(queries[queryNo]);
			ResultSetMetaData rsmd = rs.getMetaData();
			ShowStuff.printHeader("Results of the Query!", out);
			out.println("<body>");
			out.println("<table align=center>");
			
			int noTuples = 0;
			int colCount = rsmd.getColumnCount();
			while(rs.next())
		        {
			      if(noTuples == 0)
			      {
				    out.println("<tr>");
		       		    if(queryNo == 6)
				         out.println("<th>EMAIL</th> <th> NAME </th> <th> PROGRAM NAME</th> <th> PROGRAM ID</th>");
				    else if(queryNo == 7)
				         out.println("<th>EMAIL</th> <th> NAME </th> <th> EVENT NAME</th> <th> EVENT ID</th>");
				    else
				    {
				    	 for(int i=1; i<=colCount; i++)
			     	  	 out.println("<th>"+rsmd.getColumnName(i)+"</th>");
		       		         out.println("</tr>");
				    }
			      }
			      out.println("<tr>");
			      for(int i=1; i<=colCount; i++)
				   out.println("<td>"+rs.getString(i)+"</td>");
			      out.println("</tr>");
			      noTuples++;
			}
		        if(noTuples == 0)
			      out.println("<font color=blue> There are no matches </font>");
		        out.println("</table>");
		        out.println("<br><br>");
		        ShowStuff.printFooter(out);
			con.close();
		}
		catch(SQLException sqle){System.out.println(sqle);}
	}
}
