import java.io.*;
import java.sql.*;
import java.util.StringTokenizer;
import javax.servlet.*;
import javax.servlet.http.*;
import util.*;


/** This servlet is used by the AuthorServlet to upload/re-upload papers.
 *
 * @author Anjali Gupta
 * @version 1.00 Tue Nov 14 00:13:50 IST 2000
 */ 

public class Upload extends HttpServlet
{
	 
     /** Initialise the servlet
	  *  Open a database connection and get the attributes of the PERSON,PARTICIPANT tables 
	  *  @param config ServletConfig
	  */
	 
	 public void init(ServletConfig config) throws ServletException 
	 {
		  super.init(config);
	 }
	
	 /** Uploads the paper - id it if the first time it is being uploaded then extracts
	  * the filename from the database, else it accepts it from the calling servlet..
	  *
	  * @param HttpServletRequest httpservletrequest
	  * @param HttpServletResponse httpservletresponse
	  */

	 public void service(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse)
		  throws ServletException, IOException
		  {
			   Connection connection = null;
			   PrintWriter printwriter = httpservletresponse.getWriter();
			   
			   try
			   {
					HttpSession httpsession = httpservletrequest.getSession(false);
					connection = DB.getConnection();
					String s = "";
					
					if(httpsession != null)
						 s = (String)httpsession.getValue("ID");
					
					Statement statement = connection.createStatement();
					int i = 0;
					String s1 = "0";
					
					// here it is being checked whether the session is null or not. If it is 
					// null then take paper id from sb else it is the session ID itself.
					
					if(s.equals(""))
					{
						 for(ResultSet resultset = statement.executeQuery("SELECT COUNT(*) FROM PAPER"); resultset.next();)
						 {
							  s1 = resultset.getString(1);
							  i = Integer.parseInt(s1);
						 }

					} else
					{
						 s1 = s;
						 i = Integer.parseInt(s1);
					}


					httpservletresponse.setContentType("text/html");
					
					ServletInputStream servletinputstream = httpservletrequest.getInputStream();
					
					httpservletrequest.getContentLength();
					
					byte abyte0[] = new byte[20000];
					
					boolean flag = false;
					
					int j = servletinputstream.readLine(abyte0, 0, abyte0.length);
					
					String s2 = new String(abyte0, 0, j);
					
					// -- represents the standard beginning of the boundary. After this
					// the header begins.
					
					if(s2.startsWith("--"))
						 j = servletinputstream.readLine(abyte0, 0, abyte0.length);
					s2 = new String(abyte0, 0, j);
					
					StringTokenizer stringtokenizer = new StringTokenizer(s2, ";");
					
					String s5 = "";
					
					// the next line has content disposition, also includes filename.
					// extracts the extension from the filename and stores it in s5.
					
					if(s2.startsWith("Content-Disposition"))
					{
						 while(stringtokenizer.hasMoreTokens()) 
						 {
							  String s4 = stringtokenizer.nextToken();
							  if(s4.startsWith(" filename"))
							  {
								   int k = s4.indexOf(46);
								   int l = s4.lastIndexOf(34);
								   if ((k+1<l) && (k >= 0))
								   {
										s5 = s4.substring(k+1, l);
								   }
							  }
						 }
					}
					if (s5.equals(""))
					{
						 s5="txt";
					}

					j = servletinputstream.readLine(abyte0, 0, abyte0.length);
					
					s2 = new String(abyte0, 0, j);
					
					if(s2.startsWith("Content-Type"))
					{
						 j = servletinputstream.readLine(abyte0, 0, abyte0.length);
					}
					
					FileOutputStream fileoutputstream = new FileOutputStream(Config._FILE_REPOSITORY + s1 + "." + s5);
					statement.executeUpdate("UPDATE PAPER SET EXTN='"+s5+"' WHERE PAPERID="+i);
				    	
					//here the code for the actual upload begins... there are a few extra checks 
					//to deal with the quirks of transmission.
					// upload ends when it next sees a "--" that boundary is followed 
					// by the footer.
					
					while((j = servletinputstream.readLine(abyte0, 0, abyte0.length)) != -1) 
					{
						 String s3 = new String(abyte0, 0, j);
						 if(s3.startsWith("--"))
							  break;
						 if(flag)
						 {
							  fileoutputstream.write(13);
							  fileoutputstream.write(10);
							  flag = false;
						 }
						 if(j >= 2 && abyte0[j - 2] == 13 && abyte0[j - 1] == 10)
						 {
							  fileoutputstream.write(abyte0, 0, j - 2);
							  flag = true;
						 } else
						 {
							  fileoutputstream.write(abyte0, 0, j);
						 }
					}
					
					servletinputstream.close();
					fileoutputstream.close();
					
					ShowStuff.printHeader("Upload Results", printwriter);
					
					if(httpsession == null)
						 printwriter.println("<font size=3 class=TDFONT> Your paper has been registered and an account has been created for you.</font><p>");
					else
						 printwriter.println("<font size=2 class=TDFONT> There! Your paper has been Re-uploaded</font><p>");
					
					printwriter.println("<br></br>");
					
					if(httpsession == null)
					{
						 printwriter.println("<font size=3 class=TDFONT>Your loginID is the same as your PaperID:</font>");
						 printwriter.println("<br></br>");
						 printwriter.println("<font size=3 class=TDFONT><b>LOGINID</b></font> : "+i+"<p>");
						 printwriter.println("<font size=3 class=TDFONT><b>PASSWORD</b></font>: " + i+"<p>");
						 printwriter.println("<font size=3 class=TDFONT color=blue>This password can (and should) be changed upon login!!</font>");
					} else
					{
						 printwriter.println("<font size=3 class=TDFONT>Return to Your Page?</font>");
						 printwriter.println("<a href=\"http://"+Config._HOST+":" + Config._PORT + "/servlet/AuthorServlet\"><font size=2 class=TDFONT>There you go!!</font></a>");
					}
					
					ShowStuff.printFooter(printwriter);
					connection.close();
					return;
			   }
			   catch(SQLException sqlexception)
			   {
					System.out.println(sqlexception);
					ShowStuff.printHeader("Error",printwriter);
					ShowStuff.throwError("ERROR","The following exception occured in the processing of your query <br></br>"+sqlexception,printwriter);
					ShowStuff.printFooter(printwriter);
					if (connection != null) connection=null;
			   }
			   return;
		  }
}
