package util;

import java.io.*;
import java.net.*;
import java.util.*;

/** This class files allow the applet to communicate to the servlet
 *  It can simulate POST/GET methods on a servlet
 *
 *  @author Aameek Singh
 *  @version 1.00, Sun Nov 12 17:11:42 IST 2000
 */

public class HttpMessage {
	 URL servlet = null;
	 String args = null;
   
	 /** Constructor 
	  *  @param servlet URL
	  */
	 public HttpMessage(URL servlet) {
		  this.servlet=servlet;
	 }

	 /**
	  * GET request with zero arguments 
	  */
	 public InputStream sendGetMessage() throws IOException {
		  return sendGetMessage(null);
	 }

	 /** GET request with arguments
	  *  @param args Properties  Contains the parameters to be submitted
	  *  with the GET request
	  */
	 public InputStream sendGetMessage(Properties args) throws IOException {
		  String argString="";
		  if (args != null) {
			   argString="?"+toEncodedString(args);
		  }
		  URL url=new URL(servlet.toExternalForm()+argString);
		  URLConnection con=url.openConnection();
		  con.setUseCaches(false);
		  InputStream res=con.getInputStream();
		  return res;
	 }
	 
	 /** POST request with zero arguments 
	  */
	 public InputStream sendPostMessage() throws IOException {
		  return sendPostMessage(null);
	 }
	 
	 /** POST request with posting a serializable object 
	  * @param obj Serializable The object to be posted
	  */
	 public InputStream sendPostMessage(Serializable obj) throws IOException {
		  URLConnection con=servlet.openConnection();
		  con.setDoInput(true);
		  con.setDoOutput(true);
		  con.setUseCaches(false);
		  con.setRequestProperty("Content-Type","java-internal/"+obj.getClass().getName());
		  ObjectOutputStream out=new ObjectOutputStream(con.getOutputStream());
		  out.writeObject(obj);
		  out.flush();
		  out.close();
		  return con.getInputStream();
	 }

	 /** POST request with a string to be posted 
	  *  @param args Properties Contains the parameters to be posted
	  */
	 public InputStream sendPostMessage(Properties args) throws IOException {
		  String argString="";
		  if (args != null) {
			   argString=toEncodedString(args);
		  }
		  
		  URLConnection con=servlet.openConnection();

		  con.setDoInput(true);
		  con.setDoOutput(true);

		  con.setUseCaches(false);
		  
		  con.setRequestProperty("Content-Type","application/x-www-form-urlencoded");

		  DataOutputStream out=new DataOutputStream(con.getOutputStream());
		  out.writeBytes(argString);
		  out.flush();
		  out.close();
		  return con.getInputStream();
	 }

	 /** Converts a Properties obj to the corresponding String
	  * @param args Properties
	  */
	 private String toEncodedString(Properties args) {
		  StringBuffer buf=new StringBuffer();
		  Enumeration names=args.propertyNames();
		  while (names.hasMoreElements()) {
			   String name=(String)names.nextElement();
			   String value=args.getProperty(name);
			   buf.append(URLEncoder.encode(name)+"="+URLEncoder.encode(value));
			   if (names.hasMoreElements()) buf.append("&");
		  }
		  return buf.toString();
	 }
}
