package util;

import java.io.*;
import java.util.*;
import java.net.*;

/** 
 * This class is a Mail-Sending program. 
 *
 * @author Aameek Singh
 * @version 1.00, Wed Oct  4 18:04:44 IST 2000
 */

public class Mail {

	 /** Send Mail. 
	  * @param toID      Email Id to which the email is to be sent.
	  * @param MailFrom  Email Id from which it is supposed to be sent.
	  * @param Subject   Subject of the email
	  * @param Content   Content of the mail
	  */
	 public static void sendMail(String toId,String MailFrom,String Subject,String Content) throws Exception {
		  Stack MailTo=new Stack();
		  MailTo.push(toId);
		  sendMail(MailTo,MailFrom,Subject,Content);
	 }
	 
	 /** Send Mail. 
	  * @param MailTo    Stack of the email Id's to which the email is to be sent.
	  * @param MailFrom  Email Id from which it is supposed to be sent.
	  * @param Subject   Subject of the email
	  * @param Content   Content of the mail
	  */
	 public static void sendMail(Stack MailTo, String MailFrom, String Subject, String Content) throws Exception { 
		  Socket soc=null;
		  PrintWriter out=null;
		  BufferedReader in=null;
		  try {
			   soc=new Socket(Config._SMTP_HOST, Config._SMTP_PORT);
			   out=new PrintWriter(soc.getOutputStream(),true);
			   in=new BufferedReader(new InputStreamReader(soc.getInputStream()));

			   out.println("mail from: "+MailFrom+" ");

			   while (!MailTo.empty()) {
					out.println("rcpt to: "+(String)MailTo.pop()+" ");
			   }
			   out.println("data ");
			   out.println("Subject: "+Subject);
			   out.println(Content);
			   out.println(".");

			   String tmp=in.readLine();
			   tmp=in.readLine();
			   tmp=in.readLine();
			   tmp=in.readLine();
			   out.close();
			   soc.close();
			   in.close(); 
		  } catch (Exception e) {e.printStackTrace(); }
	 }
}
