create table Event(
					event_id varchar(15) not null,
					event_name varchar(50) not null,
					location varchar(50) not null,
					start_date date not null,
					end_date date not null,
					capacity integer null,
					moderation_flag integer not null,
					IC_flag integer not null,
					primary key(event_id),
					check (IC_flag between 0 and 2),
					check (moderation_flag between 0 and 2)
					);

create table SubEvent(
					  event_id varchar(15),
					  subevent_id varchar(15),
					  subevent_name varchar(50) not null,
					  venue varchar(50) not null,
					  capacity integer not null,
					  moderation_flag integer not null,
					  team_size integer not null,
					  primary key(event_id,subevent_id),
					  foreign key(event_id) references Event
					  on delete cascade,
					  check (moderation_flag between 0 and 2)
					 );

create table Passwords(
						login_id varchar(20) not null,
						password varchar(8) not null,
						primary key(login_id)
					  );


create table Participants( 
						 PID integer,
						 name varchar(50),
						 primary key(PID),
						 unique(PID,name)
						 );

					 
create table Event_Manager (
							login_id varchar(20) not null,
							event_id varchar(15) not null,
							name varchar(50) not null,
							email_id varchar(50) not null,
							primary key(login_id,event_id),
							foreign key(event_id) references Event on delete cascade,
							foreign key(login_id) references Passwords on delete cascade
							);

create table SubEvent_Manager (
							login_id varchar(20) not null,
							event_id varchar(15) not null,
							subevent_id varchar(15) not null,
							name varchar(50) not null,
							email_id varchar(50) not null,
							primary key(login_id,event_id,subevent_id),
							foreign key(login_id) references Passwords on delete cascade,
							foreign key(event_id,subevent_id) references SubEvent on delete cascade
							);

create table Individual(
						PID integer not null,
						email_id varchar(50) not null,	
						login_id varchar(20) not null,
						name varchar(50) not null,
						primary key(PID),
						foreign key(PID,name)references Participants(PID,name) on delete cascade,
						foreign key(login_id) references Passwords on delete cascade
						);

create table Contingent(
						login_id varchar(20) not null,
						name varchar(50) not null,
						email_id varchar(50) not null,	
						CL_name varchar(50) not null,
						primary key(login_id),
						foreign key(login_id) references Passwords on delete cascade
						);


create table Team(
					PID integer not null,
					login_id varchar(20) not null,
					team_name varchar(50),
					name varchar(50) not null,
					email_id varchar(50) not null,	
					primary key(PID),
					foreign key(PID,team_name)references Participants(PID,name)
						on delete cascade,
					foreign key(login_id) references Contingent
						on delete cascade
					);
						
create table Team_Member(
						email_id varchar(50) not null,
						name varchar(50) not null,
						primary key(email_id) 
						);


create table Judge(
					email_id varchar(50),
					name varchar(50) not null,
					phone varchar(20) not null,
					address1 varchar(100),
					address2 varchar(100),
					fax varchar(20),
					primary key(email_id)
					);


create table Team_Member_Of(
					PID integer not null,
					email_id varchar(50) not null,	
					primary key(email_id,PID),
					foreign key(email_id) references Team_member on delete cascade,
					foreign key(PID) references Team on delete cascade
					);

create table Registered_For(
							event_id varchar(15),
							login_id varchar(20),
						 	approved integer not null,
							primary key(event_id,login_id),
							foreign key(event_id) references Event
						on delete cascade,
							foreign key(login_id) references Passwords
						on delete cascade,
						 	check (approved between 0 and 1)
							);

create table Participates_In(
							event_id varchar(15),
							subevent_id varchar(15) not null,
							PID integer,
						 	approved integer not null,
							primary key(event_id,subevent_id,PID),
							foreign key(event_id,subevent_id) references SubEvent
						on delete cascade,
							foreign key(PID) references Participants
						on delete cascade,
						 	check (approved between 0 and 1)
							);

create table Results(
					event_id varchar(15),
					subevent_id varchar(15) not null,
					description varchar(50) not null,
					result varchar(50) not null,
					primary key(event_id,subevent_id,description,result),
					foreign key(event_id,subevent_id) references SubEvent
				on delete cascade
				);	
							
					
create table Judges(
					event_id varchar(15),
					subevent_id varchar(15) not null,
					email_id varchar(50),
					primary key(event_id,subevent_id,email_id),
					foreign key(event_id,subevent_id) references SubEvent
						on delete cascade,
					foreign key(email_id) references Judge
						on delete cascade
					);

create table Occurs_On(
					event_id varchar(15),
					subevent_id varchar(15) not null,
					day date not null,
					start_time date not null,
					end_time date not null,
					primary key(event_id,subevent_id,day),
					foreign key(event_id,subevent_id) references SubEvent
						on delete cascade
					);
							
create table EM_Spec_SubEvent_Attrib(
							event_id varchar(15),
							attrib varchar(30) not null,
							mandatory_flag integer not null,
							primary key(event_id,attrib),
							foreign key(event_id) references Event
						on delete cascade,
							check (mandatory_flag between 0 and 1)
							);

create table EM_Spec_SubEvent_Attrib_Val(
							event_id varchar(15),
							subevent_id varchar(15) not null,
							attrib varchar(30) not null,
							value varchar(50),
							primary key(event_id,subevent_id,attrib),
							foreign key(event_id,subevent_id) references SubEvent
						on delete cascade,
							foreign key(event_id,attrib) references EM_SPEC_SUBEVENT_ATTRIB
						on delete cascade
							);

create table EM_Spec_Participant_Attrib(
							event_id varchar(15),
							attrib varchar(30) not null,
							mandatory_flag integer not null,
							primary key(event_id,attrib),
							foreign key(event_id) references Event
						on delete cascade,
							check (mandatory_flag between 0 and 1)
							);

create table SEM_Spec_Participant_Attrib(
							event_id varchar(15),
							subevent_id varchar(15),
							attrib varchar(30) not null,
							sem_filled integer not null,
							mandatory_flag integer not null,
							primary key(event_id,subevent_id,attrib),
							foreign key(event_id,subevent_id) references SubEvent
						on delete cascade,
							check (mandatory_flag between 0 and 1)
							);
						

create table EM_Spec_Participant_Attrib_Val(
							event_id varchar(15),
						    login_id varchar(20) not null,
							attrib varchar(30) not null,
							value varchar(50),
							primary key(event_id,login_id,attrib),
							foreign key(event_id,attrib) references EM_Spec_Participant_Attrib
						on delete cascade,
							foreign key(event_id,login_id) references Registered_For
						on delete cascade
							);

create table SEM_Spec_Participant_Attrib_Vl(
							event_id varchar(15),
							subevent_id varchar(15),
							PID integer,
							attrib varchar(30) not null,
							value varchar(50),
							primary key(event_id,subevent_id,attrib,PID),
							foreign key(event_id,subevent_id) references SubEvent
							on delete cascade,
							foreign key(PID) references Participants
							on delete cascade
							);
