package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class allows the system administrator to create a new event, specify its
 * ID, and specify its capacity as well.
 *
 * @author Tejas Iyer
 * @version Fri Oct 13 02:15:11 IST 2000
 */

public class AdminCreateEventServlet extends HttpServlet {
	 /**
	  * The init method of the servlet
	  */
	 public void init() {
	 }

	 /**
	  * processes a get request and spews out a form for the sysad to fill
	  *
	  * @param req The HttpServletRequest which asked for the form
	  * @param res The HttpServletResponse to which the form shall be written
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
		  HttpSession hs;
		  PrintWriter pw;
		  String userid;

		  pw = res.getWriter();
		  hs = req.getSession(false);
		  res.setContentType("text/html");

		  if (hs == null) {
			   HtmlGen.writeHeader("Invalid Session", pw);
			   pw.println("<h1>Invalid Session!</h1>");
			   HtmlGen.writeFooter("", "", "", "", pw);
		  } else {
			   userid = (String)(hs.getValue("userid"));
			   if ((userid == null) || (!(userid.equals("sysad")))) {
					HtmlGen.writeHeader("Sorry, you are not the sysad!", pw);
					pw.println("You need to be the sysad to do this!");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					HtmlGen.writeHeader("Add An Event", pw);
					pw.println("<h1>Enter all the event details</h1><hr>");
					pw.println("<form action=\"" + 
							  sat.Config.hostname + ":" + sat.Config.port + 
							  "/servlet/acer\" method=POST>");
					pw.println("<table align=center cols=2 width=40% border=0 cellpadding=3 cellspacing=3>");
					pw.println("<tr><td>Event-Id</td><td><input type=text name=eventid size=20></td></tr>");
					pw.println("<tr><td>Event Name</td><td><input type=text name=eventname size=20></td></tr>");
					pw.println("<tr><td>Capacity</td><td><input type=text name=capacity size=20></td></tr>");
					pw.println("<tr><td>Event Manager's LoginId</td><td><input type=text name=emlogin size=20></td></tr>");
					pw.println("<tr><td>Event Manager's Password</td><td><input type=password name=empwd size=20></td></tr>");
					pw.println("<tr><td>Event Manager's Name</td><td><input type=text name=emname size=20></td></tr>");
					pw.println("<tr><td>Event Manager's Email Id</td><td><input type=text name=emmail size=20></td></tr>");
					pw.println("<tr><td><input type=submit value=Submit></td>");
					pw.println("<td><input type=reset value=Reset></td></tr>");
					pw.println("</table></form><hr>");
					HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/rtoc", "Return to Control Page", sat.Config.hostname+":"+sat.Config.port+"/servlet/logout", "Logout", pw);
			   }
		  }
	 }

	 /**
	  * processes the form posted by the sysad, and inserts the new event
	  *
	  * @param req The HttpServletRequest which gave the form contents
	  * @param res The HttpServletResponse on which the success/failure is informed
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
		  HttpSession hs;
		  PrintWriter pw;
		  String userid;
		  String eventid;
		  String eventname;
		  String emlogin;
		  String empwd;
		  String emmail;
		  String emname;
		  int capacity;
		  boolean success,check;

		  check=true;
		  capacity = 1000;
		  pw = res.getWriter();
		  hs = req.getSession(false);
		  res.setContentType("text/html");

		  if (hs == null) {
			   HtmlGen.writeHeader("Invalid Session", pw);
			   pw.println("Invalid Session!");
			   HtmlGen.writeFooter("", "", "", "", pw);
		  } else {
			   userid = (String)(hs.getValue("userid"));
			   if ((userid == null) || (!(userid.equals("sysad")))) {
					HtmlGen.writeHeader("Sorry, you are not the sysad!", pw);
					pw.println("You need to be the sysad to do this!");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					
					eventid = req.getParameter("eventid");
					eventname = req.getParameter("eventname");
					emlogin = req.getParameter("emlogin");
					empwd = req.getParameter("empwd");
					emmail = req.getParameter("emmail");
					emname = req.getParameter("emname");

					try{
						 capacity = (new Integer(req.getParameter("capacity"))).intValue();
					}catch(NumberFormatException nfe){
						 check=false;
					} // check if the capacity is a proper number else catch the exception and process.

					success = sat.SharedObjects.qe.insertEventEntry(eventid, eventname, emname, emlogin, empwd, emmail, capacity);

					if (success && check) {
						  Mailer m = new Mailer(sat.Config.sysadEmail, emmail,
									"Event Registered", 
									"The Event " + eventname + " (eventid-"+eventid+") has been registered successfully.\n" + 
									"Please login with the following details:\n"
						  +"Login Id: "+emlogin+"\n"
						  +"Password: "+empwd+"\n"
						  +"Thanking you,\n"
						  +"System Administrator\n"
						  +"VAST Inc.");
						  m.run();
						  
						 HtmlGen.writeHeader("Event created sucessfully!", pw);
						 pw.println("<h1>Event " + eventname +"("+eventid+")" + " created successfully.</h1>");
						 pw.println("<hr>");
						 HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/rtoc", "Back to Control Page", sat.Config.hostname+":"+sat.Config.port+"/servlet/logout", "Logout", pw);
					} else {
						 HtmlGen.writeHeader("Event not created.", pw);
						 pw.println("<h1>Event " + eventname +"("+eventid+")" + " not created.</h1><hr>");
						 HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/rtoc", "Back to Control Page", sat.Config.hostname+":"+sat.Config.port+"/servlet/logout", "Logout", pw);
					}

			   }
		  }
	 }
}
