package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class just changes the capacity of an event if the sysad wishes to do so.
 * It is invoked from the ViewEventDetails Servlet page.
 *
 * @author B. Aditya
 * @version 1.99 Sat Oct 14 03:02:10 IST 2000
 */

public class AdminEventCapacityChangeServlet extends HttpServlet {
	/**
	 * The init method of the servlet
	 */
	public void init() {
	}

	/**
	 * processes a get request and spews out a form for the sysad to fill
	 *
	 * @param req The HttpServletRequest which asked for the form
	 * @param res The HttpServletResponse to which the form shall be written
	 */
	public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
		HttpSession hs;
		PrintWriter pw;
		String userid;
		String eventid;
		int capacity;
		boolean check, success;
		
		check=true;
		success=false;
		pw = res.getWriter();
		hs = req.getSession(false);
		res.setContentType("text/html");

		if (hs == null) {
			HtmlGen.writeHeader("Invalid Session", pw);
			pw.println("<h1>Invalid Session!</h1>");
			HtmlGen.writeFooter("", "", "", "", pw);
		} else {
			userid = (String)(hs.getValue("userid"));
			if ((userid == null) || (!(userid.equals("sysad")))) {
				HtmlGen.writeHeader("Sorry, you are not the sysad!", pw);
				pw.println("You need to be the sysad to do this!");
				HtmlGen.writeFooter("", "", "", "", pw);
			} else {
				 eventid = (String)(hs.getValue("eventid"));
				 try{
					  capacity = (new Integer(req.getParameter("capacity"))).intValue();
					  //success = sat.SharedObjects.qe.setCapacity(eventid, capacity);
					  success=true;
				 } catch(NumberFormatException nfe) {
					  check=false;
				 }
				 if (check && success) {
					  HtmlGen.writeHeader("Capacity changed",pw);
					  pw.println("<h1> Capacity successfully changed </h1>");
					  pw.println("<p> The capacity for the event " + eventid + " has been updated");
					  HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/ave","Go to Event List",sat.Config.hostname+":"+sat.Config.port+"/servlet/rtoc","Back to Control Page",pw);
				 }
				 else{
					  HtmlGen.writeHeader("Could not change values",pw);
					  pw.println("<h1> Could not change capacity for "+eventid+"</h1>");
					  HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/ave","Back to Event list",sat.Config.hostname+":"+sat.Config.port+"/servlet/rtoc","Back to Control Page",pw);
				 }	  
			}
		}
		pw.close();
	}
}
