package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class takes a passwd entered by administrator, verifies against stored 
 * and then, either generates error or first page for administrator.
 *
 * @author B. Aditya
 * @version 1.01 27/09/2000
 * @since who cares...
 */

public class AdminLoginServlet extends HttpServlet
{

	 /**
	  * Invoked if the login was wrong. Prints error and returns you to login.
	  *
	  * @param pw The PrintWriter
	  */
	 public void adminLoginError(PrintWriter pw)
	 {
		HtmlGen.writeHeader("Login Error",pw);
		pw.println("<h1> Login error </h1>");
		pw.println("<br> <br> <br>");
		pw.println("Your entry was incorrect. Please try again.");
		HtmlGen.writeFooter(sat.Config.webserver +sat.Config.tilda + "/adminlogin.htm","Login again","","",pw);
	 }

	 /**
	  * Invoked if administrator login is correct. Generates Control page
	  * Can add events, view events, delete events, logout or change password
	  *
	  * @param pw PrintWriter
	  */
	 public void adminLoginPage(PrintWriter pw)
	 {
		  String hp = sat.Config.hostname+":"+sat.Config.port;
		  HtmlGen.writeHeader("Administrator Controls" , pw);
		  pw.println("<h1> Administrator Controls </h1>");
		  pw.println("<table align=center width=40% cols=1 border=0 frame=null cell-spacing=20% cell-padding=20%>");
		  pw.println("<tr> <td> <a href=\""+hp+"/servlet/acer\"> Add Event</a> </td> </tr>");
		  pw.println("<tr> <td> <a href=\""+hp+"/servlet/ave\"> View/Remove Events</a> </td> </tr>");
		  pw.println("</table>");
		  HtmlGen.writeFooter(""+hp+"/servlet/logout","Logout", ""+hp+"/servlet/cps","Change Password",pw);
	 }

	 public void doGet(HttpServletRequest request, HttpServletResponse response)
		  throws ServletException, IOException
		  {
			   PrintWriter pw = response.getWriter();
			   response.setContentType("text/html");
			   
			   String userid, passwd;
			   HttpSession session = request.getSession(false);
			   if (session==null)
			   {
					HtmlGen.writeHeader("Access Denied",pw);
					pw.println("<h1> You cannot access this page without logging in</h1>");
					pw.println("<hr><center> <p> Go away ");
					HtmlGen.writeFooter("","","","",pw);
					pw.close();
					return;
			   }
			   else
			   {
					userid = (session.getValue("userid")).toString();
					passwd = (session.getValue("passwd")).toString();
					if (sat.SharedObjects.au.checkPassword(userid, passwd,""))
					{
						 session.putValue("SessionOn",new Integer(0));
						 session.putValue("eventid","sysad");
						 session.putValue("userid","sysad");
						 session.putValue("usertype",new Integer(9));
//						 pw.println("Session On = "+session.getValue("SessionOn"));
						 adminLoginPage(pw);
					}
					else
					{
						 session.invalidate();
						 adminLoginError(pw);
					}
			   }
		  }

	 public void doPost(HttpServletRequest request, HttpServletResponse response)
		  throws ServletException, IOException
		  {
			  String userid = request.getParameter("userid");
			  String passwd = request.getParameter("passwd");
			  PrintWriter pw = response.getWriter();
			  HttpSession session=request.getSession(true);
			  response.setContentType("text/html");
			  if (sat.SharedObjects.au.checkPassword(userid, passwd,""))
			  {
				   session.putValue("SessionOn",new Integer(0));
				   session.putValue("eventid","sysad");
				   session.putValue("userid","sysad");
				   session.putValue("usertype",new Integer(9));
//				   pw.println("Session On = "+session.getValue("SessionOn"));
				   adminLoginPage(pw);
			  }
			  else
			  {
				   session.invalidate();
				   adminLoginError(pw);
			  }
			  pw.close();
		  }
}
				   
			  

