package sat;

/**
 * This class does the job of verifying userids and passwords.
 *
 * @author		Satyen Kale
 * @version		1.00, 26/9/2K
 */
public class Authenticator {
	/**
	 * Checks the userid and password.
	 *
	 * @param	userid	a user login id
	 * @param	password the password for the user
	 * @return	true if the password matches, false otherwise
	 */
	public boolean checkPassword(String userid, String password, String event_id) {
		String pass = SharedObjects.qe.getPassword(userid);

		if (userid.equals("sysad")) return password.equals(pass);
		boolean iRF = true;
		int type = SharedObjects.qe.getUserType(userid);
		if (type > 3) return false;
		if (type == 2 || type == 3)
			iRF = SharedObjects.val.isRegisteredFor(userid, event_id);
		else {
			String eid = SharedObjects.qe.getEventID(userid, type);
			iRF = (eid != null) && (eid.equals(event_id));
		}
		
		if (pass == null) return false;
		return (password.equals(pass) && iRF);
	}

	/**
	 * changes a password for a given user.
	 *
	 * @param	userid	the user login id
	 * @param	oldpass	the old password
	 * @param	newpass	the new password
	 * @return	true on success, false on failure
	 */
	public boolean changePassword(String userid, String event_id, String oldpass, String newpass) {
		if (! checkPassword(userid, oldpass, event_id)) return false;
		return SharedObjects.qe.changePassword(userid, newpass);
	}

	public static void main(String[] args) {
		System.out.println(SharedObjects.au.changePassword("sysad", null, "tuntuna", "bunbuna"));
	}
}
