package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class allows an Event Manager to create a new Sub Event
 * The EM enters a Subevent Name, a SE id, capacity, SEM name, SEM id
 *
 * @author B.Aditya
 * @version 1.00 Sun Oct 15 03:23:31 IST 2000
 */
public class EMAddSubEventServlet extends HttpServlet {
	/**
	 * processes a get request and spews out a form for the EM to fill
	 *
	 * @param req The HttpServletRequest which asked for the form
	 * @param res The HttpServletResponse to which the form shall be written
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		HttpSession hs;
		PrintWriter pw;
		String userid;
		String eventid;
		int usertype;
		String hp=sat.Config.hostname+":"+sat.Config.port;
		
		pw = res.getWriter();
		hs = req.getSession(false);
		res.setContentType("text/html");

		if (hs == null) {
			HtmlGen.writeHeader("Invalid Session", pw);
			pw.println("<h1>Invalid Session!</h1>");
			HtmlGen.writeFooter("", "", "", "", pw);
		} else {
			userid = (String)(hs.getValue("userid"));
			usertype = ((Integer)(hs.getValue("usertype"))).intValue();
			
			if (usertype!=0){
				HtmlGen.writeHeader("Sorry, access denied.", pw);
				pw.println("<h>Access Denied. You are not allowed here </h1>");
				HtmlGen.writeFooter("", "", "", "", pw);
			} else {
				HtmlGen.writeHeader("Add a Sub-Event", pw);
				pw.println("<h1>Enter the required details.</h1><hr>");
				pw.println("<form action=\"" + 
							  sat.Config.hostname + ":" + sat.Config.port + 
							  "/servlet/emase\" method=POST>");
				pw.println("<table align=center width=50% cols=2 frame=null border=0>");
				pw.println("<tr><td>Sub Event-Id</td><td><input type=text name=subeventid size=20></td></tr>");
				pw.println("<tr><td>Sub Event Name</td><td><input type=text name=subeventname size=20></td></tr>");
				pw.println("<tr><td>Capacity (Capacity must not exceed total event capacity)</td><td><input type=text name=capacity size=20></td></tr>");
				pw.println("<tr><td>Sub Event Manager's login id</td><td><input type=text name=semid size=20></td></tr>");
				pw.println("<tr><td>Sub Event Manager's password</td><td><input type=password name=sempwd size=20></td></tr>");
				pw.println("<tr><td>Sub Event Manager's name</td><td><input type=text name=semname size=20></td></tr>");
				pw.println("<tr><td>Sub Event Manager's email id</td><td><input type=text name=semmail size=20></td></tr>");
				pw.println("<tr><td><input type=submit value=Submit></td>");
				pw.println("<td><input type=reset value=Reset></td></tr>");
				pw.println("</table></form><hr>");
				HtmlGen.writeFooter(hp+"/servlet/rtoc", "Return to Control Page", hp+"/servlet/emvse", "Back to SubEvent List", pw);
			}
		}
	}

	/**
	 * processes the form posted by the sysad, and inserts the new event
	 *
	 * @param req The HttpServletRequest which gave the form contents
	 * @param res The HttpServletResponse on which the success/failure is informed
	 */
	public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException {
		HttpSession hs;
		PrintWriter pw;
		String userid;
		String eventid;
		String subeventid;
		String subeventname;
		String semid;
		String sempwd;
		String semname;
		String semmail;
		int capacity;
		int usertype;
		boolean success,check;
		String hp=sat.Config.hostname+":"+sat.Config.port;
		
		check=true;
		capacity = 100;
		
		pw = res.getWriter();
		hs = req.getSession(false);
		res.setContentType("text/html");

		if (hs == null) {
			HtmlGen.writeHeader("Invalid Session", pw);
			pw.println("Invalid Session!");
			HtmlGen.writeFooter("", "", "", "", pw);
		} else {
			userid = (String)(hs.getValue("userid"));
			usertype = ((Integer)(hs.getValue("usertype"))).intValue();
			eventid = (String)(hs.getValue("eventid"));
			
			if (usertype != 0) {
				HtmlGen.writeHeader("Sorry, you are not the Event Manager", pw);
				pw.println("You need to be the event manager to do this!");
				HtmlGen.writeFooter("", "", "", "", pw);
			} else {
				subeventid = req.getParameter("subeventid");
				subeventname = req.getParameter("subeventname");
				semid = req.getParameter("semid");
				sempwd = req.getParameter("sempwd");
				semname = req.getParameter("semname");
				semmail = req.getParameter("semmail");
			
				try{
					 capacity = (new Integer(req.getParameter("capacity"))).intValue();
				}catch(NumberFormatException nfe){
					 check=false;
				} // check if the capacity is a proper number else catch the exception and process.

				success = sat.SharedObjects.qe.insertSubEventEntry(eventid,subeventid, subeventname, semname, semid, sempwd, semmail, capacity);
				// shouldnt this also take an subevent name, SEM name, SEM id
				
				if (success && check) {
						  Mailer m = new Mailer(sat.SharedObjects.qe.getEMEmail(eventid),
									semmail,"Sub Event Created", 
									"The Sub Event "+subeventname+" for the event "+eventid +" has been created"
						  +" successfully.\nPlease login with the following details to manage the show !!\n"
						  +"Login Id: "+semid+"\n"
						  +"Password: "+sempwd+"\n"
						  +"Thanking you, \n"
						  +"Event Manager \n"
						  +"VAST Inc.");
						  m.run();
					
					 HtmlGen.writeHeader("Sub event created sucessfully!", pw);
					pw.println("<h1>Sub Event " + subeventname +"("+subeventid+")"+" created successfully.</h1>");
					pw.println("The subevent " + subeventname +"("+subeventid+")"+" was created with a capacity of " 
							  + capacity + ".<hr>");
					HtmlGen.writeFooter(hp+"/servlet/rtoc", "Back to Control Page", hp+"/servlet/emvse", "Back to Sub Event List", pw);
				} else {
					HtmlGen.writeHeader("Sub Event not created.", pw);
					pw.println("Sub Event " + subeventname + " not created.");
					HtmlGen.writeFooter(hp+"/servlet/rtoc", "Back to Control Page", hp+"/servlet/emvse", "Back to Sub Event List", pw);
				}
			}
		}
	}
}
