package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This allows an event manager to login as a subevent manager and makes changes to the
 * stored values in the session. When logout occurs, the values are restored.
 *
 * @author B.Aditya
 * @version Thu Nov  9 01:38:48 IST 2000
 */
public class EMChangeLoginServlet extends HttpServlet {
	 /**
	  * <code>doPost</code> - takes the subeventid and spews out the corresponding
	  * page of the subeventmanager after changing session vars.
	  * 
	  * @param HttpServletRequest req
	  * @param HttpServletResponse res
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {

			   HttpSession hs;
			   PrintWriter pw;
			   String userid;
			   String eventid;
			   String subeventid;
			   String semlogin;
			   int usertype;

			   pw = res.getWriter();
			   hs = req.getSession(false);
			   res.setContentType("text/html");

			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					userid = (String)(hs.getValue("userid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					eventid = (String)(hs.getValue("eventid"));
					subeventid = req.getParameter("subeventid");
					// to change to this.

					if (usertype!=0){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", "", "", pw);
					} else {
						 // now to change the session vars.
						 semlogin = sat.SharedObjects.qe.getSEMLogin(eventid,subeventid);
						 hs.putValue("masquerade","yes");
						 hs.putValue("subeventid",subeventid);
						 hs.putValue("usertype",new Integer(1));
						 hs.putValue("userid",semlogin);
						 hs.putValue("olduserid",userid);
						 hs.putValue("oldusertype",new Integer(usertype));
						 
						 InterfaceObjects.smi.start(pw,semlogin,eventid, subeventid);
					}
			   }
			   pw.close();
		  }
}

