package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class displays the subevent details for a given subevent.
 * Can be invoked by event manager.
 */
public class EMGetSubEventDetailsServlet extends HttpServlet {
	/**
	 * doPost - gets an eventid from EMViewSubEventsServlet and 
	 * posts the appropriate data on screen.
	 * 
	 * @param request HttpRequest
	 * @param response HttpResponse
	 *
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
		 throws ServletException, IOException {
		HttpSession session;
		PrintWriter pw;
		String userid,subeventid,eventid;
		int usertype;
		SubEventData sed;
		TimeInfo ti;
		Attrib a;
		Enumeration e;

		// define some data form to accept se data (itis variable)

		pw = response.getWriter();
		response.setContentType("text/html");
		session = request.getSession(false);
		String hp = sat.Config.hostname +":"+ sat.Config.port;

		if (session == null) {
		 	HtmlGen.writeHeader("Session Error",pw);
		 	pw.println("<h1> There was an error processing your session");
		 	HtmlGen.writeFooter("","","","",pw);
		} else {
			userid = (session.getValue("userid")).toString();
			usertype = ((Integer)(session.getValue("usertype"))).intValue();
			
			if (usertype==0) {
				eventid = (String)(session.getValue("eventid"));
				subeventid = request.getParameter("subeventid");
					 
			 	if (subeventid == null /*|| eventid is not valid*/) {
					HtmlGen.writeHeader("Error",pw);
					pw.println("<h1>You haven't selected any event to view. Please do so.</h1>");
					pw.println("<center> Click <a href="+hp+"/servlet/emvse> here </a> to view sub event list");
					HtmlGen.writeFooter(hp+"/servlet/rtoc","Return to Control Page",hp+"/servlet/logout","Logout",pw);
				} else {
					// throw out page
					
			        sed = sat.SharedObjects.qe.getSubEventData(eventid, subeventid);
					// display the subevent details now....
					
					HtmlGen.writeHeader("Sub Event Details",pw);
					pw.println("<h1>Sub Event details for " + subeventid + "</h1><hr>");
					
					pw.println("<table align=center width=50% cols=2 border=0>");
					pw.println("<tr><td>Sub Event ID </td><td>"+sed.subevent_id+"</td></tr>");
					pw.println("<tr><td>Sub Event Name </td><td>"+sed.subevent_name+"</td></tr>");
					pw.println("<tr><td>Venue </td><td>"+sed.venue+"</td></tr>");
					pw.println("<tr><td>Capacity </td><td>"+sed.capacity+"</td></tr>");
					if (sed.moderation_flag==1)
						 pw.println("<tr><td>Moderated? </td><td> Yes </td></tr>");
					else
						 pw.println("<tr><td>Moderated? </td><td> No </td></tr>");

					pw.println("</table><hr>");
					pw.println("<table align=center width=50% cols=3 border=0>");
					pw.println("<th>Date</th><th>Start Time </th><th>End Time</th>");

					if (sed.times==null) {
						 pw.println("</table>");
						 pw.println("<p> Times not set by SEM<hr>");
					} else {
						 e = sed.times.elements();
						 while (e.hasMoreElements()) {
							  ti = (TimeInfo)(e.nextElement());
							  pw.println("<tr>");
							  pw.println("<td>"+ti.date+"</td>");
							  pw.println("<td>"+ti.start_time+"</td>");
							  pw.println("<td>"+ti.end_time+"</td>");
							  pw.println("</tr>");
						 }
						 pw.println("</table><hr>");
					}

					pw.println("<table align=center width=50% cols=2 border=0>");
					pw.println("<th>Attribute</th><th>Value</th>");
					if (sed.attrib_vals==null) {
						 pw.println("</table>");
						 pw.println("<p> Attribute values not set by SEM<hr>");
					} else {
						 e = sed.attrib_vals.elements();
						 while (e.hasMoreElements()) {
							  a = (Attrib)(e.nextElement());
							  pw.println("<tr>");
							  pw.println("<td>"+a.name+"</td>");
							  pw.println("<td>"+a.value+"</td>");
							  pw.println("</tr>");
						 }
						 pw.println("</table><hr>");
					}
					HtmlGen.writeFooter(hp+"/servlet/emvse","Back to event list",hp+"/servlet/rtoc", "Back to Control Page",pw);
				}
			} else {
				 HtmlGen.writeHeader("Access Error",pw);
				 pw.println("<h1> You are not authorised to access this page.Go away </h1>");
				 HtmlGen.writeFooter("","","","",pw);
			}
		}
		pw.close();
		 }
}
