package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This servlet takes a userid for an event and throws out all the details about that
 * participant (be he individual or contingent)
 *
 * @author B.Aditya
 * @version 1.00 Sun Oct 29 22:52:49 IST 2000
 */
public class EMPDetailsServlet extends HttpServlet {
	 /**
	  * <code> doGet </code> takes a loginid as parameter from the caller and calls up
	  * the appropriate details and displays all. That's all!!
	  *
	  * @param HttpServletRequest req
	  * @param HttpServletResponse res
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {

			   HttpSession hs;
			   PrintWriter pw;
			   String eventid;
			   String subeventid;
			   String userid;
			   int usertype;
			   String loginid;
			   String name;
			   boolean teambased;

			   hs = req.getSession(false);
			   res.setContentType("text/html");
			   pw = res.getWriter();
			   String hp = sat.Config.hostname +":"+ sat.Config.port;
			   
			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					userid = (String)(hs.getValue("userid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					eventid = (String)(hs.getValue("eventid"));
					subeventid = (String)(hs.getValue("subeventid"));

					if (usertype!=1){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", "", "", pw);
					} else {
						 loginid = req.getParameter("loginid");
						 name = req.getParameter("name");
						 HtmlGen.writeHeader("Participant details",pw);
						 pw.println("<h1>  Participant details </h1><hr>");
						 // now to check if indiv or team.
						 // if indiv, throw out all appropriate details
						 // if team, get contingent details as well as team details.
						 teambased = sat.SharedObjects.val.isTeamBased(eventid);
						 if (teambased) {
							  ContData cd;
							  Enumeration e1,e2,e3,e4;
							  String se,sid,team;
							  String arr1,arr2;

							  cd = sat.SharedObjects.qe.getContData(eventid,loginid);
							  
							  e1 = cd.attrib_vals.elements(); // EMSpec PVals
							  e2 = cd.se.elements(); // SubEvent names
							  e3 = cd.sid.elements(); // SID 
							  e4 = cd.team_name.elements();


							  pw.println("<p> Contingent Details</p>");
							  pw.println("<table align=center cols=2 width=50% border=0>");
							  pw.println("<tr><td>Name</td><td>"+cd.cl_name+"</td></tr>");
							  pw.println("<tr><td>Contact Email</td><td>"+cd.email+"</td></tr>");
							  pw.println("<tr><td>Name</td><td>"+cd.name+"</td></tr>");
							  pw.println("<tr><td>CL Name</td><td>"+cd.cl_name+"</td></tr>");
							  pw.println("</table>");
							  pw.println("<p>Values of EM Specfied attributes </p>");
							  pw.println("<table align=center cols=2 width=50% border=0>");
							  pw.println("<th>Attribute</th><th>Value</th>");
							  while (e1.hasMoreElements()) {
								   arr1 = (String)(e1.nextElement());
								   arr2 = (String)(e1.nextElement());
								   pw.println("<tr><td>"+arr1+"</td><td>"+arr2+"</td></tr>");
							  }
							  pw.println("</table><hr>");
							  pw.println("<p> List of subevents registered for</p>");
							  pw.println("<table align=center cols=3 width=50% border=0>");
							  pw.println("<th>SubEvent ID</th><th>SubEvent Name</th><th>Name</th>");
							  while (e2.hasMoreElements()) {
								   se = (String)(e2.nextElement());
								   sid = (String)(e3.nextElement());
								   team = (String)(e4.nextElement());
								   pw.println("<tr><td>"+sid+"</td><td>"+se+"</td><td>"+team+"</td></tr>");
							  }
							  pw.println("</table><hr>");
							  
							  HtmlGen.writeFooter(hp+"/servlet/sempending","Back to Pending list",hp+"/servlet/rtoc","Back to Control Page",pw);
						 } else {
							  // individual based. 
							  IndData id;
							  IndSEData ised;
							  Enumeration e1,e2,e3,e4,e5;
							  
							  id = sat.SharedObjects.qe.getIndData(eventid, loginid);
							  String arr1,arr2;
							 
							  e1 = id.sid.elements(); // subeventid
							  e2 = id.se.elements();  // subevent names
							  e3 = id.pi.elements();  // participation for above (approved or not)
							  e4 = id.attrib_vals.elements(); // EMSpec PVal
							  pw.println("<table align=center width=50% cols=2 border=0>");
							  pw.println("<tr><td>Name :</td><td>"+id.name+"</td></tr>");
							  pw.println("<tr><td>Email ID :</td><td>"+id.email+"</td></tr>");
							  pw.println("</table>");
							  pw.println("<hr><p>Event Manager Specified Participant values</p>");
							  pw.println("<table align=center cols=2 width=50% border=0>");
							  pw.println("<th>Attribute</th><th>Value</th>");
							  while (e4.hasMoreElements()) {
								   arr1 = (String)(e4.nextElement());
								   arr2 = (String)(e4.nextElement());
								   pw.println("<tr><td>"+arr1+"</td><td>"+arr2+"</td></tr>");
							  }
							  pw.println("</table><hr>");
							  pw.println("<p> This participant has applied to participate in the foll subevents as well</p>");
							  pw.println("<table align=center cols=3 width=50% border=0>");
							  pw.println("<th>SubEvent ID</th><th>SubEvent Name</th><th>Approved?</th>");
							  while (e1.hasMoreElements()) { // e1, e2 and e3 are all equal in length
								   String se,seid;
								   boolean flag;
								   seid = (String)(e1.nextElement());
								   se = (String)(e2.nextElement());
								   flag = ((Boolean)(e3.nextElement())).booleanValue();
								   pw.println("<tr>");
								   pw.println("<td>"+seid+"</td>");
								   pw.println("<td>"+se+"</td>");
								   if (flag) 
										pw.println("<td> Yes </td>");
								   else
										pw.println("<td> No </td>");
								   pw.println("</tr>");
							  }
							  pw.println("</table><hr>");
							  HtmlGen.writeFooter(hp+"/servlet/sempending","Back to Pending list",hp+"/servlet/rtoc","Back to Control Page",pw);
						 }
					}
			   }
			   pw.close();
		  }
}
