package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class allows the event manager to view/modify the following details of the
 * event: name, startDate, endDate, IC_flag, moderated_flag, location
 *
 * @author Tejas Iyer
 * @version Fri Oct 13 03:12:34 IST 2000
 *
 * tweaked a little by B.Aditya - added some manouevering between pages on Sun Oct 15 02:40:59 IST 2000
 */

public class EMViewEventServlet extends HttpServlet {
	/**
	 * The init method of the servlet
	 */
	public void init() {
	}

	/**
	 * processes a get request and spews out a form for the sysad to fill
	 *
	 * @param req The HttpServletRequest which asked for the form
	 * @param res The HttpServletResponse to which the form shall be written
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
		HttpSession hs;
		PrintWriter pw;
		String userid, eventid;
		EMSpecData emsd;
		String hp = sat.Config.hostname+":"+sat.Config.port;
		
		int capacity;
		String name, startDate, endDate, location, IC_flag, moderated_flag;
		
		pw = res.getWriter();
		hs = req.getSession(false);
		res.setContentType("text/html");
		
		if (hs == null) {
			HtmlGen.writeHeader("Invalid Session", pw);
			pw.println("<h1>Invalid Session!</h1>");
			HtmlGen.writeFooter("", "", "", "", pw);
		} else {
			eventid = (String)(hs.getValue("eventid"));
			emsd = sat.SharedObjects.qe.getEventDetails(eventid);
			hs.putValue("emsd", emsd);
			
			capacity = emsd.capacity;
			// If event is individual based event, the IC_flag must be 0
			// so checked !
			IC_flag = (emsd.IC_flag == 0) ? "checked" : "";
			moderated_flag = (emsd.moderated_flag == 1) ? " checked " : "";
			
			name = emsd.name;
			startDate = emsd.startDate.toString();
			endDate = emsd.endDate.toString();
			location = emsd.location;
			
			HtmlGen.writeHeader("View / Modify Event Details", pw);
			pw.println("<h1>Enter event-specific details</h1><hr>");
			pw.println("<form action=\"" + 
						  sat.Config.hostname + ":" + sat.Config.port + 
						  "/servlet/emves\" method=POST>");
			pw.println("<table cols=2 align=center width=50% frame=null border=0 cellpadding=3 cellspacing=3>");
			pw.println("<tr><td>Event-Id:</td><td>" + eventid + "</td></tr>");
			pw.println("<tr><td>Capacity:</td><td>" + capacity + "</td></tr>");
			pw.println("<tr><td>Name:</td><td><input type=text name=name size=30 value=\"" + name + "\"></td></tr>");
			pw.println("<tr><td>Start Date (yyyy-mm-dd):</td><td><input type=text name=startdate size=20 value="
					  + startDate + "></td></tr>");
			pw.println("<tr><td>End Date (yyyy-mm-dd):</td><td><input type=text name=enddate size=20 value="
					  + endDate + "></td></tr>");
			pw.println("<tr><td>Location:</td><td><input type=text name=location size=20 value=\""
					  + location + "\"></td></tr>");
			pw.println("<tr><td>Individual Event ? </td><td><input type=checkbox " + 
					  "name=IC_flag " + IC_flag + "></td></tr>");
			pw.println("<tr><td>Moderated Event ? </td><td><input type=checkbox " + 
					  "name=moderated_flag " + moderated_flag + "></td></tr>");
			pw.println("<tr><td><input type=submit value=Submit></td>");
			pw.println("<td><input type=reset value=Reset></td></tr>");
			pw.println("</table></form><hr>");
			HtmlGen.writeFooter(hp+"/servlet/rtoc", "Back to Control Page", hp+"/servlet/logout", "Logout", pw);		 
		}
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
		PrintWriter pw;
		HttpSession hs;
		EMSpecData emsd;
		String name, startDate, endDate, location, eventid;
		int IC_flag, moderated_flag;
		String hp = sat.Config.hostname+":"+sat.Config.port;
		
		hs = req.getSession(false);
		res.setContentType("text/html");
		pw = res.getWriter();
		emsd = (EMSpecData)(hs.getValue("emsd"));
		hs.removeValue("emsd");
		eventid = (String)(hs.getValue("eventid"));

		name = req.getParameter("name");
		startDate = req.getParameter("startdate");
		endDate = req.getParameter("enddate");
		location = req.getParameter("location");
	
		// SO BADDY HERE YOU SHOULD GET THE OLD
		// VALUE OF THE IC_FLAG AND MODIFY ACCORDINGLY
		
		if (req.getParameter("IC_flag") == null) 
			IC_flag = 1;  // teambased = 1
		else
			IC_flag = 0;  // individual = 0
		// toggled athe above - check up the defn for ICFlag...
		if (req.getParameter("moderated_flag") == null)
			moderated_flag = 0;
		else
			moderated_flag = 1;
	
		emsd.name = name;
		emsd.setDates(startDate, endDate); 
		emsd.location = location;
		emsd.moderated_flag = moderated_flag;
		emsd.IC_flag = IC_flag;

		sat.SharedObjects.qe.insertEventDetails(eventid, emsd);
		
		
		HtmlGen.writeHeader("Event Details updated", pw);
		pw.println("<h1>The event details have been updated to the following values </h1><hr>");
		pw.println("<table align=center width=40% border=0 cols=2 cellpadding=3 cellspacing=3>");
		pw.println("<th>Attribute Name</th><th>Current Value</th>");
		pw.println("<tr><td>Name </td>");
		pw.println("<td>"+req.getParameter("name") + "</td></tr>");
		pw.println("<tr><td>Start Date</td>");
		pw.println("<td>"+req.getParameter("startdate") + "</td></tr>");
		pw.println("<tr><td>End Date</td>");
		pw.println("<td>"+req.getParameter("enddate") + "</td></tr>");
		pw.println("<tr><td>Location </td>");
		pw.println("<td>"+req.getParameter("location") + "</td></tr>");
		pw.println("<tr><td>Individual Flag </td>");
		pw.println("<td>"+req.getParameter("IC_flag") + "</td></tr>");
		pw.println("<tr><td>Moderated Flag </td>");
		pw.println("<td>"+req.getParameter("moderated_flag") + "</td></tr>");
		pw.println("<tr><td> Capacity (as set by sysad)</td>");
		pw.println("<td>"+sat.SharedObjects.qe.getCapacity(eventid)+"</td></tr>");
		pw.println("</table>");
		HtmlGen.writeFooter(hp+"/servlet/rtoc", "Control Page", hp+"/servlet/emves", "Modify again", pw);
	}
}
