package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**This servlet allows the Event Manager to view all the contingents 
 * which are registered for an event and the teams which belong 
 * to those contingents.
 *
 * @author Vijay D'silva
 * @version 1.00 Tuesday October 31
 */

public class EMViewParticipantsServlet extends HttpServlet {
	 /**
	  * <code> doGet </code> takes a Eventid as parameter from the caller and  
	  * displays all the contingents which are registered for that event. 
	  *
	  * @param HttpServletRequest req
	  * @param HttpServletResponse res
	  */

	 public void doGet(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {
			   //Get all the parameters for the servlet.
			   HttpSession hs;
			   PrintWriter pw;
			   String eventid,eventname;
			   String userid,name;
			   String contname,clname,clogin; //contingent name, login and leader name.
			   Vector outcome,participants; //Participants and info about participants vectors.
			   Enumeration pe,ie;//Participant enumeration and information enumeration.
			   int usertype;
			   boolean teambased,indflag; //To indicate whether an event individual or teambased.

			   hs = req.getSession(false);
			   res.setContentType("text/html");
			   pw = res.getWriter();
			   String host = sat.Config.hostname +":"+ sat.Config.port;

			   //If a session isnot alive, then donot allow the person to proceed
			   //any further.
			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", host+"/servlet/logout", "Logout", pw);
			   } else {
					eventid = (String)(hs.getValue("eventid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					
					//Check if the person trying to perform this operation is 
					//indeed an event manager.
					if (usertype!=0){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h1>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", host+"/servlet/logout", "Logout", pw);
					} else {
						 eventname = sat.SharedObjects.qe.getEventName(eventid);
						 participants = sat.SharedObjects.qe.getEventParticipants(eventid);
						 teambased = sat.SharedObjects.val.isTeamBased(eventid);
					
						 //To check if the event is Individual or contingent based.
						 if (teambased != true){
							  indflag=true;
							  start(pw,eventname,eventid,indflag);
							
							  //Incase there are no participants, say so.
							  if (participants==null) {
								   pw.println("<h1> No Participants Have registered so far. </h1>");
								   HtmlGen.writeFooter(host+"/servlet/rtoc","",host+"/servlet/logout","Logout",pw);
							  } else {
								   pe = participants.elements();

								   //Display the list of participants.
								   while(pe.hasMoreElements()){
										userid = (String)(pe.nextElement());
										name = (String)(pe.nextElement());
										ShowParticipantData(pw,userid,name);
								   }
								   pw.println("</table>");
								   HtmlGen.writeFooter(host+"/servlet/rtoc", "Return To Control",host+"/servlet/logout", "Logout", pw);
							  }
						 } else {
							  //For a Contingent Based event.
							  indflag = false;
							  start(pw,eventname,eventid,indflag);
							  //First create the headers etc for the page.
							  //The list of contingents which are registered for the event.

							  if (participants==null) {
								   pw.println("<h1> No Contingents Have registered so far. </h1>");
								   HtmlGen.writeFooter(host+"/servlet/rtoc","Return To Control",host+"/servlet/logout","Logout",pw);
							  } else {
								   //Display participant information.
								   pe = participants.elements();
								   while(pe.hasMoreElements()){
										userid = (String)(pe.nextElement());
										name = (String)(pe.nextElement());
										sat.ContData cinfo = sat.SharedObjects.qe.getContData(eventid,userid);
										clname = cinfo.cl_name;
										contname = cinfo.name;
										ShowContingentData(pw,userid,contname,clname);
								   }
								   pw.println("</table>");
								   HtmlGen.writeFooter(host+"/servlet/rtoc", "Return To Control", host+"/servlet/logout", "Logout", pw);
							  }

						 }	 
					}
			   }   
		  }

	 //The post method of the same servlet. This part is used for the displaying
	 //of details about a participant/contingent.
	 public void doPost(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {

			   HttpSession hs;
			   PrintWriter pw;
			   String userid;
			   String eventid,subevent;
			   String name,clname,teamname;
			   String eventname;
			   int usertype; 
			   String email;
			   Vector subevents,teams; //Subevents that a participant takes part in.
			   Vector pinfo,attribs;  //vector of participant information details.
			   Enumeration ei,es,et; //enumeration for the details
			   boolean teambased;

			   pw = res.getWriter();
			   hs = req.getSession(false);
			   res.setContentType("text/html");
			   String host = sat.Config.hostname+":"+sat.Config.port;

			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", host+"/servlet/logout", "Logout", pw);
			   } else {
					eventid = (String)(hs.getValue("eventid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					userid = (String)(req.getParameter("userid"));
					teambased = sat.SharedObjects.val.isTeamBased(eventid);
					
					//Check if the person trying to perform this operation is 
					//indeed an event manager.
					if (usertype!=0){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", host+"/servlet/logout", "Logout", pw);
					} else {
						 eventname = sat.SharedObjects.qe.getEventName(eventid);
					//Check if the event is individual or team based.
						 if(teambased == false){
							  //Indivudual data type. Use for that info.
							  sat.IndData indinfo = sat.SharedObjects.qe.getIndData(eventid,userid);
							  name = indinfo.name;	
							  email = indinfo.email;
							  subevents = indinfo.se; //Subevents that the person has registered for.

							  pinfo = indinfo.pi;
							  attribs = indinfo.attrib_vals;
							  initdisp(pw,name);
							  System.out.println("got that extra info for indivudial \n");
							  //Print the person's name and email address
							  pw.println("<h2>Participant Name : "+name+"</h2>");
							  pw.println("<h2>Email Address    :"+email+"</h2><hr>");
							  //The subevents which they are taking part in.
							  System.out.println("printed initial data\n");
							  if(subevents != null){
								   System.out.println("printing subevent data\n");
								   pw.println("<h2> Sub Events the participant is taking part in:</h2>");
								   pw.println("<center>");
								   pw.println("<table width=50%  cellspacing=0 cellpadding=1>");
								   pw.println("<th>Sub Event Name</th>");
								   pw.println("<tbody>");
								   es = subevents.elements();
								   //Display the list of subevents.
								   while(es.hasMoreElements()){
										subevent = (String)(es.nextElement());
										pw.println("<tr><td>"+subevent+"</td></tr>");
								   }
								   pw.println("</table>");
								   pw.println("</center>");
							  }
							  //Now print the em specified participant attributes.
							  if ((attribs.elements()).hasMoreElements() == true){
								   pw.println("<h2> Additional Information:</h2>");
								   pw.println("<table width=50%  cellspacing=0 cellpadding=1>");
								   pw.println("<tbody>");
								   //Attrib attr;
								   //Attrib attr;
								   Enumeration ea;
								   ea = attribs.elements();
								   String attribname,attribval;
								   while(ea.hasMoreElements()){
								
										System.out.println("printing participant attribs\n");
										System.out.println("printed participant attrib casting.\n");
										attribname = (String)(ea.nextElement());
										attribval = (String)(ea.nextElement());
										System.out.println("Casting done as required.\n");
										pw.println("<tr><td>"+attribname+"</td><td></td><td></td><td>"+attribval+"</td></tr>");
								   }
								   pw.println("</table>");
								   //ShowAttributes(pw,attribs);
							  }
							  HtmlGen.writeFooter(host+"/servlet/emvpi", "Return To Control", host+"/servlet/logout", "Logout", pw);
						 } else {
							  //The same foe the contingent.
							  sat.ContData continfo = sat.SharedObjects.qe.getContData(eventid,userid);
							  name = continfo.name;	
							  clname = continfo.cl_name;
							  email = continfo.email;
							  subevents = continfo.se; //subevents and team from the contingent which takes part in it.
							  teams = continfo.team_name;
							  attribs = continfo.attrib_vals; //EM Spec attribs.
							  es = subevents.elements();
							  et = teams.elements(); //team enumeration
							  initdisp(pw,name);
							  pw.println("Contingent Name       : "+name);
							  pw.println("<br>Contingent Leader     :"+clname);
							  pw.println("<br>Contact Email Address :"+email);

							  if ((attribs.elements()).hasMoreElements() == true){
								   pw.println("<h2> Additional Information:</h2>");
								   pw.println("<table width=50%  cellspacing=0 cellpadding=1>");
								   pw.println("<tbody>");
							//display the required em  spec attribs.
								   ShowAttributes(pw,attribs);
							  }
							  if ((subevents.elements()).hasMoreElements() == true){
								   pw.println("<hr><h2>Participation</h2>");
								   pw.println("<center>");
								   pw.println("<table width=85%  cellspacing=0 cellpadding=1>");
								   pw.println("<th>Sub Event Name</th><th>Team Name</th>");
								   pw.println("<tbody>");
								   while(et.hasMoreElements()){
										subevent = (String)(es.nextElement());
										teamname = (String)(et.nextElement());
										if (teamname == null)
											 pw.println("<tr><td>"+subevent+"</td><td>No Participation</td></tr>");
										else
											 pw.println("<tr><td>"+subevent+"</td><td>"+teamname+"</td></tr>");
								   }
								   pw.println("</table>");
							  }
							  HtmlGen.writeFooter(host+"/servlet/rtoc", "Return To Control", host+"/servlet/logout", "Logout", pw);



						 }
					}	  
			   }
		  }


	 /** 
	  * Spews out the template page for displaying the results.
	  *
	  * @param pw PrintWriter
	  * @param eventid String which gives the Event-ID
	  */
	 void start(PrintWriter pw,String eventname,String eventid,boolean indflag){
		  if (indflag == false){
			   String Title = "Contingents Registered for" + eventid;
			   HtmlGen.writeHeader(Title,pw);
			   pw.println("<h1> Contingent Details for "+eventname+"</h1>");
			   pw.println("<hr><br><br>");
			   pw.println("<center>");
			   pw.println("<table width=55% cols=5 cellspacing=0 cellpadding=1>");
			   pw.println("<th>Contingent Name</th><th>Contingent Leader Name</th><th>Login ID</th><th>More Info</th>");
			   //pw.println("<tbody>");
		  }
		  else{
			   String Title = "Participants Registered for" + eventid;
			   HtmlGen.writeHeader(Title,pw);
			   pw.println("<h1> Participants In "+eventname+"</h1>");
			   pw.println("<hr><br><br>");
			   pw.println("<center>");
			   pw.println("<table width=50%  cellspacing=0 cellpadding=1>");
			   pw.println("<th> Name </th><th>Login ID</th><th>More Info</th>");
			   pw.println("<tbody>");

		  }
	 }

	 void initdisp(PrintWriter pw,String name){
		  String Title = "Details for " + name;
		  HtmlGen.writeHeader(Title,pw);
		  pw.println("<h1> Participation Details for "+name+"</h1>");
		  pw.println("<hr><br><br>");
	 }

	 void ShowParticipantData(PrintWriter pw,String login,String name){
		  String host = sat.Config.hostname+":"+sat.Config.port;
		  pw.print("<tr>");
		  pw.print("<td>"+name+"</td><td>"+login+"</td>");
		  pw.println("<td><form name=view action="+host+"/servlet/emvpi method=POST><input type=hidden name=userid value="+login+"><input type=submit value=\"View Details\"></form></td>");
		  pw.println("</tr>");

	 }

	 void ShowContingentData(PrintWriter pw,String clogin,String name,String clname){
		  String host = sat.Config.hostname+":"+sat.Config.port;
		  pw.print("<tr>");
		  pw.print("<td>"+name+"</td><td>"+clname+ "</td><td>"+clogin+"</td>");
		  pw.println("<td><form name=view action="+host+"/servlet/emvpi method=POST><input type=hidden name=userid value="+clogin+"><input type=submit value=\"View Details\"></form></td>");
		  pw.println("</tr>");
	 }

	 void ShowAttributes(PrintWriter pw,Vector attribs){
		  Enumeration ea = attribs.elements();
		  Attrib attr;
		  String attribname,attribval;
		  while(ea.hasMoreElements()){
			   System.out.println("printing participant attribs\n");
			   //attr = (Attrib)(ea.nextElement());
			   System.out.println("printed participant attrib casting.\n");
			   attribname = (String)(ea.nextElement());
			   attribval = (String)(ea.nextElement());
			   System.out.println("Casting done as required.\n");
			   pw.println("<tr><td>"+attribname+"</td><td></td><td></td><td>"+attribval+"</td></tr>");
		  }
		  pw.println("</table>");
	 }
} 
