package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class displays the list of all subevents for a given event and allows the 
 * event manager to then view individual details for any subevent.
 * 
 * @author B. Aditya
 * @version 1.00 Sun Oct 15 02:54:50 IST 2000
 */
public class EMViewSubEventsServlet extends HttpServlet
{
	 /**
	  * The doGet function checks if the session is ok and the user is indeed an EM.
	  * If so, it displays a list of subevents currently in the database, with links going
	  * off from each of them - which show a particular subevent's complete details.
	  *
	  * @param request HttpServletRequest
	  * @param response HttpServletResponse
	  */
	 public void doGet(HttpServletRequest request, HttpServletResponse response)
		  throws ServletException, IOException
		  {
			   HttpSession session;
			   String userid,eventid,subeventid,subeventname;
			   int usertype;
			   ResultSet subeventlist;
			   PrintWriter pw;

			   pw = response.getWriter();
			   session = request.getSession(false);
			   response.setContentType("text/html");
			   String hp = sat.Config.hostname+":"+sat.Config.port;

			   if (session==null)
			   {
					HtmlGen.writeHeader("Session Error",pw);
					pw.println("<h1> An error was encountered while processing session </h1>");
					HtmlGen.writeFooter("","","","",pw);
			   }
			   else
			   {
					userid = (session.getValue("userid")).toString();
					usertype = ((Integer)(session.getValue("usertype"))).intValue();
					eventid = (session.getValue("eventid")).toString();
					
					if (usertype==0)
					{
						 HtmlGen.writeHeader("Sub Event List",pw);
						 subeventlist = sat.SharedObjects.qe.getSubEvents(eventid);
						 // display
						 pw.println("<h1> Sub Event Control Page</h1>");
						 pw.println("<center><a href="+hp+"/servlet/emase>Add SubEvent</a><hr>");
						 pw.println("<table align=center cols=4 width=50% frame=null border=0 cellspacing=3 cellpadding=3>");
						 pw.println("<th> Sub Event List </th>");
						 try {
							 while (subeventlist.next()) {
								  subeventid = subeventlist.getString(1);
								  subeventname = subeventlist.getString(2);
								  
								  pw.println("<tr>");
								  pw.println("<td>"+subeventname+"</td>");
								  pw.println("<td><form name=view action="+hp+"/servlet/emgsed method=POST><input type=hidden name=subeventid value="+subeventid+"><input type=submit value=\"View Details\"></form></td>");
								  pw.println("<td><form name=del action="+hp+"/servlet/emrse method=POST><input type=hidden name=subeventid value="+subeventid+"><input type=submit value=\"Delete\"></form></td>");
								  pw.println("<td><form name=loginas action="+hp+"/servlet/emlog method=POST><input type=hidden name=subeventid value="+subeventid+"><input type=submit value=\"Login as\"></form></td>");
								  pw.println("</tr>");
							 }
						 }catch (SQLException sqle)
						 {
							  System.err.println("SQLException caught while accessing eventlist" + sqle);
						 }
						 pw.println("</TABLE>");
						 HtmlGen.writeFooter(sat.Config.hostname+":"+sat.Config.port+"/servlet/rtoc","Back to Control Page",sat.Config.hostname+":"+sat.Config.port+"/servlet/logout","Logout",pw);
					}
					else
					{
						 HtmlGen.writeHeader("Access Error",pw);
						 pw.println("<h1> You are not authorised to access this page. Go away");
						 HtmlGen.writeFooter("","","","",pw);
					}
			   }
			   pw.close();
		  }
}
