package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

public class GroupSEProfileServlet extends HttpServlet {
	public void init() {
	}

	public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
		HttpSession hs;
		PrintWriter pw;
		String userid, eventid, sid, cntgntname, subeventname, teamname;
		Vector valvec;
		Enumeration valenum;
		ContData contdata;
		Attrib attr;
		QueryEngine qe;
		TeamSEData tsed;
		int teamsize;
		Vector teammembers_vec;
		Enumeration teammembers_enum;
		String mems0, mems1;
		
		hs = req.getSession(false);
		pw = res.getWriter();
		res.setContentType("text/html");
		qe = sat.SharedObjects.qe;
		
		if (hs == null) {
			failure(pw);
		} else {
			userid = (String)hs.getValue("userid");
			eventid = (String)hs.getValue("eventid");
			sid = req.getParameter("sid");
			subeventname = qe.getSubEventName(eventid, sid);
			tsed = qe.getTeamSEData(eventid, sid, userid);
				 
			contdata = qe.getContData(eventid, userid);
			cntgntname = contdata.name;
			teamname = tsed.team_name;
			teamsize = qe.getTeamSize(eventid, sid);
			
			valvec = qe.getSEMSpecPAttribVals(eventid, sid, userid, teamname);
			valenum = valvec.elements();
			hs.putValue("valvec", valvec);

			HtmlGen.writeHeader(userid + "@" + sid + ":" + eventid, pw);
			pw.println("<h1>Profile for " + teamname + " in " + subeventname + "</h1><hr>");

			String foo = sat.Config.hostname + ":" + sat.Config.port;
			
			pw.println("<center><form method=post action=\"" + foo + req.getRequestURI() + "\">");
			pw.println("<input type=hidden name=sid value=\"" + sid + "\">");
			pw.println("<input type=hidden name=teamname value=\"" + teamname + "\">");
			pw.println("<table border=0>");
			pw.println("<tr><td>Event Name : </td><td>" + qe.getEventName(eventid) + "</td></tr>");
			pw.println("<tr><td>Sub Event Name : </td><td>" + qe.getSubEventName(eventid, sid) + "</td></tr>");
			pw.println("<tr><td>Contingent Name : </td><td>" + cntgntname + "</td></tr>");
			pw.println("<tr><td>Contingent ID : </td><td>" + userid + "</td></tr>");
			pw.println("<tr><td>Team Name : </td><td>" + teamname + "</td></tr>");
			pw.println("<tr><td>Contact Name : </td><td><input name=contactname size=20 type=text value=\"" + tsed.name + "\"></td></tr>");
			pw.println("<tr><td>Contact E-Mail : </td><td><input name=contactemail size=30 type=text value=\"" + tsed.email + "\"></td></tr>");
			pw.println("</table><hr>");
			
			teammembers_vec = tsed.members;
			teammembers_enum = teammembers_vec.elements();
			
			pw.println("<h2>Team Members</h2><br>");
			pw.println("<table border=0>");
			pw.println("<tr><td></td><td>Member Name</td><td>Member Email</td></tr>");
			for (int i = 0; i < teamsize; i++) {
				mems0 = (String)teammembers_enum.nextElement();
				mems1 = (String)teammembers_enum.nextElement();
				pw.println("<tr><td>" + (i + 1) + "</td><td><input type=text size=20 name=pname" + i + 
						  " value=\"" + mems0 + "\"</td><td><input type=text size=20 name=email" + i + 
						  " value=\"" + mems1 + "\"></td></tr>");
			}
			pw.println("</table>");
			
			
			pw.println("<table border=0>");
			while (valenum.hasMoreElements()) {
				attr = (Attrib)(valenum.nextElement());
				pw.println("<tr><td>" + attr.name + "</td>");
				pw.println("<td><input type=text size=20 name=\"" + attr.name + "\" value=\"" +
						  attr.value + "\"></td></tr>");
			}
			
			pw.println("<tr><td><input type=submit name=Submit value=Submit></td>");
			pw.println("<td><input type=reset name=Reset value=Reset></td></tr>");
			pw.println("</table><hr>");
			HtmlGen.writeFooter(foo + "/servlet/rtoc", "Back to Control Page", foo + "/servlet/logout", "Logout", pw);		 
		}
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
		HttpSession hs;
		PrintWriter pw;
		String userid, eventid, sid, name, subeventname, teamname;
		Vector valvec;
		Enumeration valenum;
		ContData contdata;
		Attrib attr;
		boolean success;
		QueryEngine qe;
		int teamsize;
		String[] names, emails;
		String contactname, contactemail;
		
		hs = req.getSession(false);
		pw = res.getWriter();
		res.setContentType("text/html");
		qe = sat.SharedObjects.qe;
		String foo = sat.Config.hostname + ":" + sat.Config.port;

		if (hs == null) {
			failure(pw);
		} else {
			userid = (String)hs.getValue("userid");
			eventid = (String)hs.getValue("eventid");
			sid = req.getParameter("sid");
			subeventname = qe.getSubEventName(eventid, sid);
			contdata = qe.getContData(eventid, userid);
			name = contdata.name;
			teamname = req.getParameter("teamname");
			teamsize = qe.getTeamSize(eventid, sid);

			valvec = (Vector)hs.getValue("valvec");
			valenum = valvec.elements();
			hs.removeValue("valvec");

			while (valenum.hasMoreElements()) {
				attr = (Attrib)valenum.nextElement();
				attr.value = req.getParameter(attr.name);
			}

			names = new String[teamsize];
			emails = new String[teamsize];

			for (int i = 0; i < teamsize; i++) {
				names[i] = req.getParameter("pname" + i);
				emails[i] = req.getParameter("email" + i);
			}
			
			contactname = req.getParameter("contactname");
			contactemail = req.getParameter("contactemail");
		
			success = qe.updateTeamEntry(eventid, sid, userid, names, emails, teamname, contactname, contactemail);

			success = success && qe.updateSEMSpecPVals(eventid, sid, userid, teamname, valvec);

			if (success) {
				HtmlGen.writeHeader("Change Successful", pw);
				pw.println("<h2>Profile Changed Successfully</h2><br>");
				pw.println("Your profile for " + subeventname + " has been changed, " + userid + "!");
				HtmlGen.writeFooter(foo + "/servlet/rtoc", "Back to Control Page", foo + "/servlet/logout", "Logout", pw);		 
			} else {
				HtmlGen.writeHeader("Change Failed", pw);
				pw.println("<h2>Profile not changed</h2><br>");
				pw.println("Some errors were present in the data entered. Please reenter the changes.");
				HtmlGen.writeFooter(foo + "/servlet/rtoc", "Back to Control Page", foo + "/servlet/logout", "Logout", pw);		 
			}
		}
	}
	
	public void failure(PrintWriter pw) {
		HtmlGen.writeHeader("Invalid User Session", pw);
		pw.println("<h2>Sorry, it appears you have not logged in. Please proceed to the login page.</h2>");
		HtmlGen.writeFooter("", "", "", "", pw);
	}
}
