package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

/**
 * Event Manager Interface - generates the interface page for an event manager
 *
 */

public class GroupUserInterface {
	GroupUserInterface() {
	}

	/**
	 * Takes a printwriter - and appropriately throws out a control page
	 *
	 * @param pw PrintWriter
	 * @param userid userid of the person logging in
	 * @param eventid Event Id
	 * @param subeventid Sub Event Id - should be null
	 */
	public void start(PrintWriter pw,String userid,String eventid, String subeventid) {
		showControls(pw,userid,eventid);
	}

	/**
	 * <code>showControls</code> generates the controls page for an event manager
	 *
	 * @param pw PrintWriter
	 * @param userid UserId of the Gp Participant
	 * @param eventid Event Id
	 */
	public void showControls(PrintWriter pw, String userid, String eventid) {
		ContData contdata;
		String cl_name, cl_email, cntgnt_name, eventname;
		Vector se_vec, seid_vec, teamname_vec;
		String sename, seid, teamname;
		
		contdata = sat.SharedObjects.qe.getContData(eventid, userid);
		eventname = sat.SharedObjects.qe.getEventName(eventid);
		
		cl_name = contdata.cl_name;
		cl_email = contdata.email;
		cntgnt_name = contdata.name;
		
		se_vec = contdata.se;
		seid_vec = contdata.sid;
		teamname_vec = contdata.team_name;

		HtmlGen.writeHeader("Change Event Profile", pw);
		pw.println("<h1>" + eventname + " - Profile " + cntgnt_name + "</h1>");
		pw.println("<hr>");

		String foo = sat.Config.hostname + ":" + sat.Config.port + "/servlet/indprofile";
		pw.println("<center><a href=\"" +sat.Config.hostname + ":" + sat.Config.port  + "/servlet/sds?eventid="+eventid+"\">View Schedule</a>");
	
		pw.println("<h2>Your Contingent Profile</h2>");
		pw.println("<table border=0>");
		pw.println("<tr>");
		pw.println("<td>Name of Contingent : </td>");
		pw.println("<td>" + cntgnt_name + "</td>");
		pw.println("</tr><tr>");
		pw.println("<td>Name of Contingent Leader : </td>");
		pw.println("<td>" + cl_name + "</td>");
		pw.println("</tr><tr>");
		pw.println("<td>E-Mail of Contingent Leader : </td>");
		pw.println("<td>" + cl_email + "</td>");
		pw.println("</tr></table>");
		pw.println("<hr>");
		
		pw.println("<h2>Sub events your contingent has already registered for:</h2>");
		Enumeration e, f, g;
		e = se_vec.elements();
		f = seid_vec.elements();
		g = teamname_vec.elements();

		foo = sat.Config.hostname + ":" + sat.Config.port + "/servlet/gsep";

		pw.println("<table border=0>");
		pw.println("<tr><td>Sub Event</td><td>Team Name</td><td></td></tr>");
		
		while (e.hasMoreElements()) {
			sename = (String)(e.nextElement());
			seid = (String)(f.nextElement());
			teamname = (String)(g.nextElement());

			if (teamname != null) {
				pw.println("<tr><td>" + sename + "</td><td>" + teamname + "</td><td><a href=\""
						  + foo + "?sid=" + seid + "\">View / Modify Team Profile</a></td></tr>");
			}
		}
		pw.println("</table>");
		pw.println("<hr>");

		pw.println("<h2>Register teams for other subevents.</h2>");
		e = se_vec.elements();
		f = seid_vec.elements();
		g = teamname_vec.elements();
		
		foo = sat.Config.hostname + ":" + sat.Config.port + "/servlet/gser";

		pw.println("<table border=0>");
		while (e.hasMoreElements()) {
			sename = (String)(e.nextElement());
			seid = (String)(f.nextElement());
			teamname = (String)(g.nextElement());
			
			if (teamname == null) {
				pw.println("<tr><td>" + sename + " : </td><td>" + "<a href=\"" 
						  + foo + "?sid=" + seid + "\">Register a team !</a></td></tr>");
			}
		}
		pw.println("</table>");
		pw.println("<hr>");

		String hp = sat.Config.hostname + ":" + sat.Config.port;
		pw.println("<a href=\"" + hp + "/servlet/srs?eventid="+eventid+"\">View Results for " + eventname + "</a>");
		pw.println("<hr>");
		
		HtmlGen.writeFooter("" + Config.hostname + ":" + Config.port + "/servlet/logout", "Logout", 
							"" + Config.hostname + ":" + Config.port + "/servlet/cps", "Change Password", pw);
	}
}
