package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

/**
 * This class contains small functins useful in generating dyanmic HTML pages.
 * <p>
 * The <code>HtmlGen</code> class is not part of any hierarchy. 
 *
 * @author B. Aditya
 * @version 1.01, 26/09/2000
 * @since the beginning of the flood
 */
public class HtmlGen
{
	/**
	 * Puts out a header for any html page
	 * <p>
	 *
	 * @param Title The Title of the HTML page
	 * @param pw The PrintWriter of the requesting Servlet
	 * @since blah
	 */
	public static void writeHeader(String Title, PrintWriter pw) {
		try {
			pw.print("<html>");
			pw.println("<head>");
			pw.println("<title>" + Title + "</title>");
			pw.println("<link rel=\"Stylesheet\" type=\"text/css\" href=\"" + sat.Config.webserver + sat.Config.tilda + "/style.css\">");
			pw.println("</head>");
			pw.println("<body>");
			pw.println("<font face=\"verdana, arial\">");
		} catch (Exception e) {
			System.err.println("Exception in HtmlGen.writeHeader()");
		}
	}

	/**
	 * Puts out a footer for any html page
	 * <p>
	 *
	 * @param backURL URL of page before this one
	 * @param backLabel Name of backURL
	 * @param nextURL URL of page coming after 
	 * @param nextLabel Url of page coming after
	 * @param pw PrintWriter
	 * @since blah
	 */
	public static void writeFooter(String backURL, String backLabel, String nextURL,String nextLabel, PrintWriter pw) {
		try{
			pw.println("<center><a href=\"" + backURL + "\">" + backLabel + "</a>");
			pw.println("<a href=\"" + nextURL + "\">" + nextLabel + "</a></center>");
			pw.println("<center>This page has been brought to you by the <b>GEM</b> project. <br>&copy <b>VAST</b> Inc.</center>");
			pw.println("</font></body></html>");
		} catch (Exception e) {
			System.err.println("Exception in HtmlGen.writeFooter()");
		}
	}
}  
