package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * This class provides a login page for each event
 *
 * @author		Tejas Iyer
 * @version		1.00, Wed Sep 27 14:08:38 IST 2000
 */

public class LoginServlet extends HttpServlet {
	/**
	 * Init method of the servlet
	 */
/*
	EventManagerInterface emi = new EventManagerInterface();
	SubEventManagerInterface smi = new SubEventManagerInterface();
	IndivUserInterface iui = new IndivUserInterface();
	GroupUserInterface gui = new GroupUserInterface();
*/	
	/**
	 * Processes all get requests and prints a form for 
	 * logging in the user/event-organiser/subevent-organiser
	 * @param	req	the HttpServletRequest sent by the form/page
	 * @param	res	the HttpServletResponse contains the response for the request
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		
		String eventName;
		PrintWriter pw;

		pw = res.getWriter();

		res.setContentType("text/html");
		// eventid should be passed as a hidden parameter from the calling page ie
		// the event page.
		HttpSession session = req.getSession(false);
		
		if (session != null) {
			 String userid, eventid, subeventid;
			 userid = (session.getValue("userid")).toString();
			 eventid = (session.getValue("eventid")).toString();
			 subeventid = (session.getValue("subeventid")).toString();
			 int usertype = ((Integer)(session.getValue("usertype"))).intValue();
			 goChoice(session,pw,userid,eventid, subeventid, usertype);
		} else { 
		     String eventid;
			 eventid = req.getParameter("eventid");
			 
			 HtmlGen.writeHeader("Login (" + eventid + ")", pw);
			 pw.println("<hr><center>");
			 pw.println("<h1> Login for " + sat.SharedObjects.qe.getEventName(eventid) + " </h1>");
			 pw.println("<form action=\"" + sat.Config.hostname + ":" + sat.Config.port + "/servlet/login\" method=post>");
			 pw.println("<table border=0 cellspacing=3 cellpadding=3>");
			 pw.println("<input type=hidden name=eventid value=" + eventid + ">");
			 pw.println("<tr><td>");
			 pw.println("User-Id: </td><td>");
			 pw.println("<input type=text name=userid size=20>");
			 pw.println("</td></tr>");
			 pw.println("<tr><td>");
			 pw.println("Password: </td><td>");
			 pw.println("<input type=password name=passwd size=20>");
			 pw.println("</td></tr>");
			 pw.println("<tr><td>");
			 pw.println("<center><input type=submit name=submit value=\"Go!\"></center>");
			 pw.println("</td><td>");
			 pw.println("<center><input type=reset name=reset value=Clear></center>");
			 pw.println("</td></tr></table>");
			 pw.println("</form></center><hr>");
			 HtmlGen.writeFooter("", "", "", "", pw);
		}

		pw.close();
	}

	/**
	 * Verifies the userid, password and recognises the class of the user
	 * @param	req	the HttpServletRequest which generated the post
	 * @param	res	the HttpServletResponse contains the response for the request
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		 PrintWriter pw;
		 String userid, passwd,eventid;

		 response.setContentType("text/html");
		 pw = response.getWriter();

		 eventid = request.getParameter("eventid");
		 userid = request.getParameter("userid");
		 passwd = request.getParameter("passwd");

		 // 0 - event manager
		 // 1 - sub-event manager
		 // 2 - user-indiv
		 // 3 - user-gp
		 HttpSession session = request.getSession(false);
		 // probe for session
		 boolean pcheck = sat.SharedObjects.au.checkPassword(userid, passwd,eventid); 
		 
//		if (session == null) {
			if (pcheck) {
				// login okay - so set session.
				//HttpSession session = request.getSession(true);
				String subeventid = sat.SharedObjects.qe.getSubEventID(userid);
				if (subeventid==null)
				 	subeventid="";
				int usertype = sat.SharedObjects.qe.getUserType(userid);
				
				session = request.getSession(true);
				
				session.putValue("SessionOn",new Integer(0));
				session.putValue("eventid",eventid);
				session.putValue("subeventid",subeventid);
				session.putValue("userid",userid);
				session.putValue("passwd",passwd);
				session.putValue("usertype",new Integer(usertype));
				
				// If the user is the sysad
				if (userid.equals("sysad")) {
					HtmlGen.writeHeader("Please go to the sysad login page!", pw);
					pw.println("Please go to the admin login <A HREF=htmls/login.htm>page</A> !");
					HtmlGen.writeFooter("", "", "", "", pw);
				} else {
					goChoice(session,pw,userid,eventid,subeventid,usertype);
			  	}
				
			} else {
				HtmlGen.writeHeader("Invalid Login", pw);
				pw.println("<HR>Sorry Pal - Invalid username or password!<HR>");
				HtmlGen.writeFooter(""+sat.Config.hostname+":"+sat.Config.port+"/servlet/login?eventid="+eventid, "Try Again", "", "", pw);
			}
/*		} else {
			HtmlGen.writeHeader("Invalid Login", pw);
			pw.println("<HR>You have already logged in. Go repent for sinning!<HR>");
			pw.println("<A HREF=\"" + sat.Config.hostname + ":" + 
					  sat.Config.port + "/servlet/logout\">Logout</A>");
			HtmlGen.writeFooter("","","","",pw);
		}			 
*/		
		pw.close();
	}

	public void goChoice(HttpSession session,PrintWriter pw, String userid, String eventid, String subeventid, int usertype) {
/*		pw.println("<p>Some session vars");
		pw.println("<p>sessionon =" + session.getValue("SessionOn"));
		pw.println("<p>eventid =" + session.getValue("eventid"));
		pw.println("<p>subeventid =" + session.getValue("subeventid"));
		pw.println("<p>userid =" + session.getValue("userid"));
		pw.println("<p>passwd =" + session.getValue("passwd"));
		pw.println("<p>usertype =" + session.getValue("usertype"));
*/		switch(usertype) {
		     case 0: InterfaceObjects.emi.start(pw,userid,eventid,subeventid);
					 break;
		     case 1: InterfaceObjects.smi.start(pw,userid,eventid,subeventid);
					 break;
		     case 2: InterfaceObjects.iui.start(pw,userid,eventid,subeventid);
					 break;
		     case 3: InterfaceObjects.gui.start(pw,userid,eventid,subeventid);
					 break;
		     default: return;
		}
	}

}
