package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * This Servlet logs out the user and resets the Session vars.
 *
 * @author B. Aditya
 * @version 1.00 Fri Sep 29 14:28:59 IST 2000
 */
public class LogoutServlet extends HttpServlet {
	 /**
	  * <code>doGet</code> checks if a session is currently on 
	  * and terminates it.
	  * 
	  * @param request HttpServletRequest
	  * @param reponse HttpServletResponse
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException,IOException {
			   HttpSession hs;
			   PrintWriter pw;
			   String eventid;
			   String masq;
			   String userid;
			   String hp,hw;

			   res.setContentType("text/html");
			   pw = res.getWriter();
			   hs = req.getSession(false); 
			   hp = sat.Config.hostname+":"+sat.Config.port;
			   hw = sat.Config.webserver;

			   if (hs!=null) {
					masq = (String)(hs.getValue("masquerade"));
					if (masq==null) {
						 eventid = (String) hs.getValue("eventid");
						 //			   pw.println("Session eventid =" + eventid);
						 //			   pw.println("Session On? =" + hs.getValue("SessionOn"));

						 hs.invalidate(); 
						 HtmlGen.writeHeader("Logout Complete",pw);
						 pw.println("<h1>Logout Complete</h1>");
						 pw.println("<hr>You have been successfully logged out of the system.");
						 if (eventid.equals("sysad"))
							  pw.println("<center>Click <a href=" + hw + sat.Config.tilda + "/adminlogin.htm>here</a> to login again.");
						 else
							  pw.println("<center>Click <a href=\""+hp+"/servlet/login?eventid=" + eventid + "\">here</a> to login again.");
						 HtmlGen.writeFooter("","","","",pw);
					} else {
						 // now reset the original values and return flo to control.
						 eventid = (String) hs.getValue("eventid");
						 hs.removeValue("masquerade");
						 userid = (String)(hs.getValue("olduserid"));
						 hs.putValue("userid",userid);
						 hs.putValue("usertype",new Integer(0));
						 hs.putValue("subeventid","");
						 hs.removeValue("olduserid");
						 hs.removeValue("oldusertype");
						 // now values are restored. will return to control page.
						 InterfaceObjects.emi.start(pw,userid,eventid,"");
					}	 
			   } else {
					eventid = null;
					HtmlGen.writeHeader("Error",pw);
					pw.println("<h1>Error</h1>");
					pw.println("<hr>You cant logout without logging in, dummy!");
					pw.println("Now go sit in a corner and repent");
					HtmlGen.writeFooter("","","","",pw);
			   }
			   pw.close();
		  }
}
