package tejas;
import sat.*;
import java.io.*;
import java.util.*;
import java.net.*;

      /** Class to send mail. This mailer runs as a thread so that other
        activities  are not blocked by the slow smtp server.
       */
public class Mailer extends Thread {
	private static final int smtpport = sat.Config.smtpport;
	String from, address, body, subject;

	/** Stores e-mail address and message body.
	 * @param from whom the mail comes from
	 * @param addr e-mail address in string format
	 * @param subject subject of email
	 * @param body message body. Should have header fields other that from,
	 * to. e.g. SMTP doesn't define a header field called Subject but all
	 * mail-reader programs recognize it. Such fields should be put at the
	 * top of message body and after such fields two \n 's to seperate it from
	 * main message body.
	*/
	public Mailer(String from, String addr, String subject, String body) {
		this.from = from;
		address = addr;
		this.body = body;
		this.subject = subject;
	}

	// Calls the method mail to send the requested mail to user.
	public void run() {
	    try {
			mail();
		} catch (IOException e) {
		}
	}

	/** Method to send mail. This connects to SMTP port ( 25 ) of the server
	 * specified in configuration file and sends data to the server.
	 * @exception IOException Thrown when read/write to socket fails. This is
	 * also thrown in the program if UnknownHostException occurs.
	*/
	private void mail() throws IOException {
		// get smtp server name and our own e-mail address from configuration
		// file.
		String hostname = Config.mailserver;

		Socket sock;   
		try {
			// connect to port 25 of the specified host
			sock = new Socket(hostname, smtpport);
		} catch (UnknownHostException u) {
			throw new IOException();
		}

		InputStream in = sock.getInputStream();
		OutputStream out = sock.getOutputStream();

		/* write SMTP stuff to the socket. Coudn't find out a simpler but
		 platform independant way to implement mailer:-( There is some
		 JavaMail API by sun but it requires JavaBeans Framework or some
		 such thing. */
		
		String mesg = "MAIL From: " + from + "\n" 
			 + "RCPT To: " + address + "\n" 
			 + "DATA\n" 
			 + "Subject: " + subject + "\n"
			 + body + "\n.\n";

		out.write(mesg.getBytes());
		out.flush();
		
		/* have to read atleast one byte from the socket otherwise the mail
		 is not sent ( why is this ? ) */
		in.read();

		in.close();
		out.close();
		sock.close();
	}
}
