package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import java.sql.*;

/**
 * This class allows a participant to register for an event. The participant
 * supplies his profile information through a form and requests a user-id for
 * a particular event. 
 *
 * @author 	Tejas Iyer
 * @version	Thu Sep 28 15:08:15 IST 2000
 */
public class RegisterServlet extends HttpServlet {
	/**
	 * Init method of the servlet
	 */
	public void init() {
	}

	/**
	 * Processes all get requests and spews out a form for
	 * submission of user profile.
	 * @param	req	the HttpServletRequest sent by the form/page
	 * @param	res	the HttpServletResponse contains the response for the request
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		PrintWriter pw;
		HttpSession hs;
		String eventid;
		Vector pregattr;
		Enumeration eregattr;
		String nextattr;
		
		res.setContentType("text/html");
		pw = res.getWriter();
		hs = req.getSession(true);
		eventid = req.getParameter("eventid");
		
		if (sat.SharedObjects.val.isValidEventID(eventid)) {
			hs.putValue("eventid", eventid);
			
			HtmlGen.writeHeader("Register Yourself For " + sat.SharedObjects.qe.getEventName(eventid), pw);
			pw.println("<h1>" + sat.SharedObjects.qe.getEventName(eventid) + "</h1>");
			pw.println("<HR>");
			pw.println("<FORM ACTION=" + req.getRequestURI() + " METHOD=POST>");
			pw.println("<CENTER><TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>");
			
			if (sat.SharedObjects.val.isTeamBased(eventid)) 
				printFormRow(pw, "Contingent Name", "name", "text");
			else
				printFormRow(pw, "Name", "name", "text");
			printFormRow(pw, "E-Mail", "emailid", "text");
			if (sat.SharedObjects.val.isTeamBased(eventid)) 
				printFormRow(pw, "Contingent Leader Name", "contingent", "text");
				 
			printFormRow(pw, "Your desired login-id", "loginid", "text");
			printFormRow(pw, "Password", "password", "password");
			
			pregattr = sat.SharedObjects.qe.getEMSpecPAttribs(eventid);
			eregattr = pregattr.elements();
			
			// Now I want to pass the same vector object back to
			// satyen's insert method. So I put it in the session
			hs.putValue("emspvec", pregattr);
			
			while (eregattr.hasMoreElements()) {
				nextattr = ((Attrib)(eregattr.nextElement())).name;
				printFormRow(pw, nextattr, nextattr, "text");
			}

			pw.println("<TR><TD>");
			pw.println("<INPUT TYPE=submit VALUE=Submit>");
			pw.println("</TD><TD>");
			pw.println("<INPUT TYPE=reset VALUE=Reset>");
			pw.println("</TD></TR>");
			
			pw.println("</TABLE></CENTER></FORM><HR>");
			HtmlGen.writeFooter("", "Back", "", "Next", pw);
		} else {
			HtmlGen.writeHeader("Invalid Event", pw);
			pw.println("<HR>Please check the event-id. Reload the page.<HR>");
			HtmlGen.writeFooter("", "Back", "", "Next", pw);
		}
	}

	public void printFormRow(PrintWriter pw, String label, String inputName, String inputType) {
		pw.println("<TR><TD>");
		pw.println(label);
		pw.println("</TD><TD>");
		pw.println("<INPUT TYPE=" + inputType + " NAME=\"" + inputName + "\" SIZE=40>");
		pw.println("</TD></TR>");
	}
	
	/**
	 * Processes all post requests and registers the flo for the event.
	 * @param	req	the HttpServletRequest sent by the form/page
	 * @param	res	the HttpServletResponse contains the response for the request
	 */
	public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		PrintWriter pw;
		String eventid, nextattr;
		HttpSession hs;
		String name, emailid, contingent, loginid, password;
		Vector pregattr;	// Contains the emspec participant attributes
		Enumeration eregattr;
		Attrib attr;
		boolean succ_reg;	// Whether it was a successful registration
		
		res.setContentType("text/html");
		pw = res.getWriter();
		hs = req.getSession(false);
		eventid = (String)(hs.getValue("eventid"));
		
		// Get back the vector from the session.
		pregattr = (Vector)(hs.getValue("emspvec"));
		eregattr = pregattr.elements();
		hs.removeValue("emspvec");
		
		// Get the default compulsory attributes
		name = req.getParameter("name");
		emailid = req.getParameter("emailid");
		loginid = req.getParameter("loginid");
		password = req.getParameter("password");
		if (sat.SharedObjects.val.isTeamBased(eventid)) 
			contingent = req.getParameter("contingent");
		else
			contingent = "";
	
		// modify the eregattr and then put it.
		while (eregattr.hasMoreElements()) {
			attr = (Attrib)(eregattr.nextElement());
			attr.value = req.getParameter(attr.name);
		}
		
		// Insert the default details for any participant
		PartDefData pdd = new PartDefData();

		pdd.name = name;
		pdd.password = password;
		pdd.event_id = eventid;
		pdd.email_id = emailid;
		pdd.login_id = loginid;
		pdd.cl_name = contingent;
		
		succ_reg = sat.SharedObjects.qe.insertPartDefData(pdd);
		
		// Insert the Event manager specified participant details
		succ_reg = (sat.SharedObjects.qe.insertEMSpecPVals(eventid, loginid, pregattr)) && succ_reg;
		hs.invalidate();
		
		if (succ_reg) {
			// Print some cheapo headers
			HtmlGen.writeHeader("Successful Registration", pw);
			pw.println("<h1>Successful Registration for " + eventid + "</h1>");
	
			pw.println("You have successfully registered for " + sat.SharedObjects.qe.getEventName(eventid)
					  + " with the following details: <BR>");
			pw.println("Name: " + name + "<BR>E-Mail: " + emailid + 
					  	"<BR>Loginid: " + loginid + "<BR>Password: " + password + "<BR>");
			
			pw.println("Please proceed to the <A HREF=\"" + Config.hostname + ":" + Config.port + 
					"/servlet/login?eventid=" + eventid + "\">login</A> page");
			
			HtmlGen.writeFooter("", "", "", "", pw);
		} else {
			HtmlGen.writeHeader("Unsuccessful Registration", pw);
			pw.println("<h1>Unsuccessful Registration</h1>");
			pw.println("Sorry, you were not registered for " + eventid + " successfully.");
			
			// if that username already exists in the database!! Cool Idea!
			if (sat.SharedObjects.val.isRegisteredFor(loginid, eventid)) 
				pw.println("That loginid has already been chosen.");
			else 
				pw.println("Some of the fields you entered were invalid.");

			HtmlGen.writeFooter(Config.hostname + ":" + Config.port + 
					  "/servlet/rs?eventid=" + eventid, "Register Again", "", "", pw);
		}
	}
}
