package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

/**
 * ReturnToControl 
 * Small servlet that returns one to the control page based on the type of user.
 * Works for admin and also any other type of user
 *
 * @author B.Aditya 
 * @version 1.00 Mon Oct  9 22:53:22 IST 2000
 */

public class ReturnToControlServlet extends HttpServlet
{
	/**
	 * <code>doPost </code> takes httprequest and response and returns user to control page.
	 * Userid / usertype are all in the session
	 */
	 public void doGet(HttpServletRequest request, HttpServletResponse response)
		  throws ServletException, IOException
		  {
			   PrintWriter pw;
			   HttpSession session;

			   response.setContentType("text/html");
			   pw = response.getWriter();
			   session = request.getSession(false);
			   String hp = sat.Config.hostname+":"+sat.Config.port;

			   if (session==null)
			   {
					HtmlGen.writeHeader("Error",pw);
					pw.println("<h1> Error - session not created. Go away. </h1>");
					HtmlGen.writeFooter("","","","",pw);
			   }
			   else
			   {
					String userid = (session.getValue("userid")).toString();
					if (userid.equals("sysad")) {
						 HtmlGen.writeHeader("Administrator Controls" , pw);
						 pw.println("<h1> Administrator Controls </h1>");
						 pw.println("<table align=center width=40% cols=1 border=0 frame=null cell-spacing=20% cell-padding=20%>");
						 pw.println("<tr> <td> <a href=\""+hp+"/servlet/acer\"> Add Event</a> </td> </tr>");
						 pw.println("<tr> <td> <a href=\""+hp+"/servlet/ave\"> View/remove Events</a> </td> </tr>");
						 pw.println("</table>");
						 HtmlGen.writeFooter(""+hp+"/servlet/logout","Logout", ""+hp+"/servlet/cps","Change Password",pw);

					}
					else {
						 int usertype = ((Integer)(session.getValue("usertype"))).intValue();
						 String eventid = (session.getValue("eventid")).toString();
						 String subeventid = (session.getValue("subeventid")).toString();

						 switch(usertype) {
							  case 0: InterfaceObjects.emi.start(pw,userid,eventid,subeventid);
									  break;
							  case 1: InterfaceObjects.smi.start(pw,userid,eventid,subeventid);
									  break;
							  case 2: InterfaceObjects.iui.start(pw,userid,eventid,subeventid);
									  break;
							  case 3: InterfaceObjects.gui.start(pw,userid,eventid,subeventid);
									  break;
							  default: return;
						 }
					}
			   }
			   pw.close();
		  }
}

