package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * Takes a judge email and throws out a page to type the mail.
 * On submitting, it mails fellow.
 */
public class SEMMailJudgeServlet extends HttpServlet {
	 /*
	  * doGet - gets an email id and throws out a textarea to mail judge.
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res)
		  throws ServletException, IOException {
			   HttpSession hs;
			   PrintWriter pw;
			   String eventid;
			   String subeventid;
			   String userid;
			   int usertype;
			   String jname, jemail;
			   String hp = sat.Config.hostname+":"+sat.Config.port;
			   String subeventname;
			   String sememail;
			   
			   pw = res.getWriter();
			   res.setContentType("text/html");
			   hs = req.getSession(false);

			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					userid = (String)(hs.getValue("userid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					eventid = (String)(hs.getValue("eventid"));
					subeventid = (String)(hs.getValue("subeventid"));
					subeventname = sat.SharedObjects.qe.getSubEventName(eventid,subeventid);

					if (usertype!=1){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", "", "", pw);
					} else {
						 jname = req.getParameter("jname");
						 jemail = req.getParameter("jemail");
						 HtmlGen.writeHeader("Mail judge",pw);
						 pw.println("<h1> Mail judge </h1><hr>");
						 pw.println("<form name=mail action="+hp+"/servlet/semmj method=POST>");
						 sememail = sat.SharedObjects.qe.getSEMEmail(eventid,subeventid);
						 //sememail = "tejas@cse.iitb.ernet.in";
						 pw.println("<input type=hidden name=from value=\""+sememail+"\">");
						 pw.println("<center>Email Id:<input type=text name=to value="+jemail+">");
						 pw.println("<center>Subject:<input type=text name=subject value=(subject)>");
						 pw.println("<center><textarea rows=10 cols=60 name=body value=\"Dear "+jname+",\"></textarea>");
						 pw.println("<hr><center><input type=submit value=Mail>");
						 HtmlGen.writeFooter(hp+"/servlet/semvj","Back to Judge List",hp+"/servlet/rtoc","Back to Control Page",pw);
					}
			   }
			   pw.close();
		  }

	 /**
	  * doPost takes the stuff from above and mails it!!
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {
			   HttpSession hs;
			   PrintWriter pw;
			   String eventid;
			   String subeventid;
			   String subeventname;
			   int usertype;
			   String hp = sat.Config.hostname+":"+sat.Config.port;
			   String from;
			   String to;
			   String subject;
			   String body;
			   Mailer m;
			   
			   pw = res.getWriter();
			   res.setContentType("text/html");
			   hs = req.getSession(false);
			   
			   if (hs == null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();
					eventid = (String)(hs.getValue("eventid"));
					subeventid = (String)(hs.getValue("subeventid"));
					subeventname = sat.SharedObjects.qe.getSubEventName(eventid,subeventid);

					if (usertype!=1){
						 HtmlGen.writeHeader("Sorry, access denied.", pw);
						 pw.println("<h>Access Denied. You are not allowed here </h1>");
						 HtmlGen.writeFooter("", "", "", "", pw);
					} else {
						 from = req.getParameter("from");
						 to = req.getParameter("to");
						 subject = req.getParameter("subject");
						 body = req.getParameter("body");
						 
						 m = new Mailer(from, to, subject, body);
						 m.run();
						 boolean success = true;
						 if (success) {
							  HtmlGen.writeHeader("Mail Sent",pw);
							  pw.println("<h1> Mail sent. </h1><hr>");
							  HtmlGen.writeFooter(hp+"/servlet/semvj","Back to Judge List",hp+"/servlet/rtoc","Back to Control Page",pw);
						 } else {
							  HtmlGen.writeHeader("Mail Not Sent",pw);
							  pw.println("<h1> Mail not sent. </h1><hr>");
							  HtmlGen.writeFooter(hp+"/servlet/semvj","Back to Judge List",hp+"/servlet/rtoc","Back to Control Page",pw);
						 }
					}
			   }
			   pw.close();
		  }
}
