package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

/**
 * <code>SEMOneServlet </code> takes the input when the SEM logs in for the
 * first time and pushes into the database. Then returns fellow to control
 * page.
 * 
 * @author B.Aditya
 * @version 1.00 Sat Oct 21 03:10:45 IST 2000
 */

public class SEMOneServlet extends HttpServlet {

	 /**
	  * <code>doPost </code> method takes the parameters when the SEM logs in
	  * for the first time and inserts into Database. If any error, redisplays
	  * page else shows page to return to control.
	  * 
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
	 public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		  HttpSession session;
		  PrintWriter pw;
		  int usertype;
		  String eventid;
		  String subeventid;
		  String userid;
		  SubEventData sed = new SubEventData();
		  String pattribs[] = new String[5];
		  int ismand[] = new int[5];
		  int sem_flag[] = new int[5];
		  boolean success;
		  boolean check;

		  res.setContentType("text/html");
		  session = req.getSession(false);
		  pw = res.getWriter();

		  if (session==null) {
			   HtmlGen.writeHeader("Session Error",pw);
			   pw.println("<h1> Go away - error processing session</h1>");
			   HtmlGen.writeFooter("","","","",pw);
		  } else {
			   usertype = ((Integer)(session.getValue("usertype"))).intValue();
			   userid = (String)(session.getValue("userid"));
			   eventid = (String)(session.getValue("eventid"));
			   subeventid = (String)(session.getValue("subeventid"));

			   if (usertype!=1) {
					HtmlGen.writeHeader("Access Error",pw);
					pw.println("<h1> You are not authorized to access this page </h1>");
					HtmlGen.writeFooter("","","","",pw);
			   } else {
					// I assume all data is ok and I can insert happily.
					String hp = sat.Config.hostname +":" + sat.Config.port;
					sed.event_id = req.getParameter("eid");
					sed.subevent_id = req.getParameter("seid");
					sed.subevent_name = sat.SharedObjects.qe.getSubEventName(sed.event_id,sed.subevent_id);
					sed.venue = req.getParameter("venue");
					if (sat.SharedObjects.val.isTeamBased(eventid)) {
						 sed.team_size = Integer.parseInt(req.getParameter("teamsize"));
					}

					// keep getting dates and times until a "" is read. then 
					// assume that is the last.
					for (int i=0;i<=4;i++) {

						 String date = req.getParameter("date"+i);
						 String stime = req.getParameter("stime"+i);
						 String etime = req.getParameter("etime"+i);

						 if ((date == null) || (stime == null) || (etime == null)) {
							  break;
						 }

						 // if blank returned, that was the last attrib.
						 // am not checking..
						 if (date.equals("") || stime.equals("") || etime.equals("")) {
							  break;
						 }
						 sed.insertTimeInfo(date+" junk","junk "+stime,"junk "+etime);
					}
					Vector v = sat.SharedObjects.qe.getEMSpecSEAttribs(eventid);
					int size = v.size();

					Enumeration e = v.elements();
					sed.attrib_vals = new Vector(10,10);
				    Vector myvec = new Vector(10,10);	
					while (e.hasMoreElements()) {
						 Attrib a = (Attrib)(e.nextElement());
						 String name = a.name;
						 String value = (String)(req.getParameter(name));

						 a.value = value;
						 myvec.addElement(a);
						 sed.insertAttribVal(name,value);
					}

					sat.SharedObjects.qe.insertEMSpecSEVals(eventid,subeventid,myvec); 

					/*if (req.getParameter("sereg")==null)
					  ssd.reg_flag=0;
					  else
					  ssd.reg_flag=1;*/
					if (req.getParameter("semod")==null)
						 sed.moderation_flag=0;  // not moderated
					else
						 sed.moderation_flag=1;  // moderated
					/*if (req.getParameter("sejud")==null)
					  ssd.judges=0;
					  else
					  ssd.judges=1;*/
					for (int i=0;i<=4;i++) { // just initializing.
						 pattribs[i]="";
						 ismand[i]=0;
						 sem_flag[i]=0;
					}
						 
					for (int i=0;i<=4;i++) {
						 // assume these are filled in order.
						 // so once i hit a blank, i quit. else i keep
						 // reading.
						 String pi = (String)(req.getParameter("pattrib"+i));
				
						 if ((pi == null) || (pi.equals(""))) 
							  break;
						 pattribs[i]=pi;
						 if (req.getParameter("pismand"+i)==null) 
							  ismand[i]=0; // not mandatory
						 else 
							  ismand[i]=1; // is mandatory
						 if (req.getParameter("semfilled"+i)==null)
							  sem_flag[i]=0; // not filled by sem
						 else
							  sem_flag[i]=1; // filled by sem
						 System.out.println(i+":"+pi+":"+ismand[i]+":"+sem_flag[i]); 
					} // add all the extra attribs

					// add the new details. get boolean

					success = sat.SharedObjects.qe.updateSubEventData(eventid, subeventid,sed);
					check = sat.SharedObjects.qe.insertSEMSpecPAttribs(eventid, subeventid, pattribs, sem_flag, ismand);

					if (success && check)
					{
						 HtmlGen.writeHeader("Details inserted",pw);
						 pw.println("<h1> The details have been inserted properly. </h1><hr>");
						 pw.println("Follow the links to reach your control page.");
						 HtmlGen.writeFooter(hp+"/servlet/rtoc","Go to Control Page",hp+"/servlet/logout","Logout",pw);
					} else {
						 InterfaceObjects.smi.start(pw,userid, eventid, subeventid, true);
					}
			   }
		  }
	 }
}
