package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class allows a SEM to remove results.
 *  
 * @author B.Aditya
 * @version 1.00 Sat Oct 28 17:52:50 IST 2000
 */
public class SEMRemoveResultsServlet extends HttpServlet {
	  /**
	   * <code>doPost</code> takes all judge details and updates the database.
	   * 
	   * @param req HttpRequest
	   * @param res HttpResponse
	   *
	   */
	  public void doPost(HttpServletRequest req, HttpServletResponse res) 
		   throws ServletException, IOException {
				HttpSession session;
				PrintWriter pw;
				String userid;
				String subeventid;
				String eventid;
				int usertype;
				boolean success;
				String name,result;
				String hp = sat.Config.hostname+":"+sat.Config.port;
				
				success = false;
				res.setContentType("text/html");
				pw = res.getWriter();
				session = req.getSession(false);

				if (session==null) {
					 HtmlGen.writeHeader("Error in Session",pw);
					 pw.println("<h1> Error while processing your session </h1>");
					 HtmlGen.writeFooter("","","","",pw);
				}
				else {
					 userid = (String)(session.getValue("userid"));
					 usertype = ((Integer)(session.getValue("usertype"))).intValue();
					 eventid =(String)(session.getValue("eventid"));
					 subeventid = (String)(session.getValue("subeventid"));
					 
					 if (usertype==1) {

						  name = req.getParameter("name");
						  result = req.getParameter("result");
						  
						  success =  sat.SharedObjects.qe.deleteResult(eventid,subeventid,name,result);
						  
						  if (success) {
							   HtmlGen.writeHeader("Removed results",pw);
							   pw.println("<h1> Results removed</h1><hr>");
							   HtmlGen.writeFooter(hp+"/servlet/semres","Back to Results page",hp+"/servlet/rtoc","Go back to Control page",pw);
						  }
						  else {
							   HtmlGen.writeHeader("Delete unsuccessful",pw);
							   pw.println("<h1> Delete unsuccessful </h1>");
							   pw.println("<p> Please try again </p>");
							   HtmlGen.writeFooter(hp+"/servlet/semres","Back to Results page",hp+"/servlet/rtoc","Go back to Cotnrol page",pw);
						  }
					 }
					 else {
						  HtmlGen.writeHeader("Access Error",pw);
						  pw.println("<h1> Access error </h1>");
						  pw.println("<p> you are unauthorised to access this page. Go away");
						  HtmlGen.writeFooter("","","","",pw);
					 }
				}
				pw.close();
		   }
}
				
