package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This servlet displays the current results and also allows the SEM to add,update 
 * results. 
 *
 * @author B. Aditya 
 * @version 1.00 Sat Oct 28 19:05:31 IST 2000
 */
public class SEMResultsServlet extends HttpServlet {

	 /**
	  * The doGet displays all the current results. It allows adding, updating and
	  * removing of results.
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {
			   HttpSession hs;
			   PrintWriter pw;
			   Vector v; // holds current results.
			   Enumeration e;
			   String userid;
			   String eventid;
			   String subeventid;
			   int usertype;
			   String rname;
			   String rresult;
			   String hp;

			   res.setContentType("text/html");
			   pw = res.getWriter();
			   hs = req.getSession(false);
			   hp = sat.Config.hostname+":"+sat.Config.port;

			   if (hs==null) {
					HtmlGen.writeHeader("Invalid Session", pw);
					pw.println("<h1>Invalid Session!</h1>");
					HtmlGen.writeFooter("", "", "", "", pw);
			   } else {
					eventid = (String)(hs.getValue("eventid"));
					subeventid = (String)(hs.getValue("subeventid"));
					userid = (String)(hs.getValue("userid"));
					usertype = ((Integer)(hs.getValue("usertype"))).intValue();

					if (usertype!=1) {
						 HtmlGen.writeHeader("Access Error",pw);
						 pw.println("<h1> You are not allowed access here </h1>");
						 HtmlGen.writeFooter("","","","",pw);
					} else {
						 v = sat.SharedObjects.qe.getResults(eventid,subeventid);

						 HtmlGen.writeHeader("Results",pw);
						 pw.println("<h1>Results for " + 
								   sat.SharedObjects.qe.getSubEventName(eventid,subeventid) + 
								   "</h1>");
						 pw.println("<hr>");
						 pw.println("<center><a href="+hp+"/servlet/semar>Add Results </a></center>");
						 pw.println("<hr>");
						 if (v==null) {
							  pw.println("<p> No Results stored! </p>");
							  HtmlGen.writeFooter(hp+"/servlet/rtoc","Return to Control Page",hp+"/servlet/logout","Logout",pw);
						 } else {
							  pw.println("<table align=center width=50% cols=4 border=0>");
							  pw.println("<th>Description(name/position)</th><th>Result</th>");	
							  e = v.elements();
							  while (e.hasMoreElements()) {
								   pw.println("<tr>");
								   rname = (String)(e.nextElement());
								   rresult = (String)(e.nextElement());
								   pw.println("<td>"+rname+"</td>");
								   pw.println("<td>"+rresult+"</td>");
								   pw.println("<td><form name=view action="+hp+"/servlet/semur><input type=hidden name=subeventid value="+subeventid+"><input type=hidden name=name value=\""+rname+"\"><input type=hidden name=result value=\""+rresult+"\"><input type=submit value=\"Update\"></form></td>");
								   pw.println("<td><form name=del action="+hp+"/servlet/semrr method=POST><input type=hidden name=subeventid value="+subeventid+"><input type=hidden name=name value=\""+rname+"\"><input type=hidden name=result value=\""+rresult+"\"><input type=submit value=\"Delete\"></form></td>");
								   pw.println("</tr>");
							  }
							  pw.println("</table><hr>");
							  HtmlGen.writeFooter(hp+"/servlet/rtoc","Return to Control Page",hp+"/servlet/logout","Logout",pw);
						 }
					}
			   }
			   pw.close();
		  }
}
