package tejas;

import java.sql.*;

/** a cheapo class which is just used to pass data as a
 * single object to the <code>QueryEngine</code>.
 *
 * @author B. Aditya
 * @version 1.00, Sat Oct 21 04:17:11 IST 2000
 */
public final class SEMSpecData {
	/** lotsa public fields for the various attributes.
	 * all are specified to be package access.
	 */
	public String eid;
	public String seid;
	public String location;
	public Date startDate;
	public Date endDate;
	public String startTime;
	public String endTime;
	public int reg_flag; // 1 if reg is required
	public int mod_flag; // 1 if reg_flag is 1 AND moderation is reqd
	public int judges; // 1 if judges required
	public String attribs[];
	public int mand_flags[];
	public int valid_attribs; // keeps count of no of valid attribs

	/**
	 * Constructor - initializes the srting array to null
	 */
	SEMSpecData() {
		 attribs = new String[5];
		 for (int i=0;i<=4;i++)
			  attribs[i]=new String("");
		 mand_flags = new int[5];
		 valid_attribs = 0;
	}
	
	/**
	 * set start date and end date
	 *
	 * @param start the start date
	 * @param end the end date
	 * @return true if the dates are in correct format, false otherwise
	 */
	public boolean setDates(String start, String end) {
		try {
			startDate = Date.valueOf(start);
			endDate = Date.valueOf(end);
			return true;
		} catch (IllegalArgumentException iae) {
			System.err.println(iae.getMessage());
		}
		return false;
	}
}
