package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This servlet allows a user to change any already entered result.
 *
 * @author B.Aditya 
 * @version 1.00 Sat Oct 28 19:40:38 IST 2000
 */
public class SEMUpdateResultsServlet extends HttpServlet {
	 /*
	  * <code> doGet</code> takes the values and displays a form. 
	  * On submitting, it posts the old and new values and calls for an update
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {
				HttpSession session;
				PrintWriter pw;
				String userid;
				String subeventid;
				String eventid;
				int usertype;
				boolean success;
				String name;
				String result;
				String hp = sat.Config.hostname+":"+sat.Config.port;
				
				success = false;
				res.setContentType("text/html");
				pw = res.getWriter();
				session = req.getSession(false);
				if (session==null) {
					 HtmlGen.writeHeader("Error in Session",pw);
					 pw.println("<h1> Error while processing your session </h1>");
					 HtmlGen.writeFooter("","","","",pw);
				}
				else {
					 userid = (String)(session.getValue("userid"));
					 eventid = (String)(session.getValue("eventid"));
					 subeventid = (String)(session.getValue("subeventid"));
					 usertype = ((Integer)(session.getValue("usertype"))).intValue();
					 String subeventname = sat.SharedObjects.qe.getSubEventName(eventid,subeventid);
					 name = req.getParameter("name");
					 result = req.getParameter("result");
					 
					 if (usertype!=1) {
						  HtmlGen.writeHeader("Access Error",pw);
						  pw.println("<h1> Access error </h1>");
						  pw.println("<p> you are unauthorised to access this page. Go away");
						  HtmlGen.writeFooter("","","","",pw);
					 } else {
						  HtmlGen.writeHeader("Update results",pw);
						  pw.println("<h1> Update results - "+subeventname+"</h1><hr>");
						  pw.println("<form action="+hp+"/servlet/semur method=POST>");
						  pw.println("<input type=hidden name=oldn value=\""+name+"\">");
						  pw.println("<input type=hidden name=oldr value=\""+result+"\">");
						  
						  pw.println("<table cols=2 width=50% align=center border=0>");
						  pw.println("<tr><td>Description:</td><td><input type=text name=newn value=\""+name+"\"></td></tr>");
						  pw.println("<tr><td>Result:</td><td><input type=text name=newr value=\""+result+"\"></td></tr>");
						  pw.println("<tr><td><input type=submit value=Update></td></tr>");
						  pw.println("</table></form>");
						  HtmlGen.writeFooter(hp+"/servlet/semres","Back to results page",hp+"/serlvet/rtoc","Back to Control Page",pw);
					 }
				}
				pw.close();
		  }
						  
	 /**
	   * <code>doPost</code> takes old results and new results and makes the change.
	   * 
	   * @param req HttpRequest
	   * @param res HttpResponse
	   *
	   */
	  public void doPost(HttpServletRequest req, HttpServletResponse res) 
		   throws ServletException, IOException {
				HttpSession session;
				PrintWriter pw;
				String userid;
				String subeventid;
				String eventid;
				int usertype;
				boolean success;
				String oldn,newn,oldr,newr;
				String hp = sat.Config.hostname+":"+sat.Config.port;
				
				success = false;
				res.setContentType("text/html");
				pw = res.getWriter();
				session = req.getSession(false);

				if (session==null) {
					 HtmlGen.writeHeader("Error in Session",pw);
					 pw.println("<h1> Error while processing your session </h1>");
					 HtmlGen.writeFooter("","","","",pw);
				}
				else {
					 userid = (String)(session.getValue("userid"));
					 usertype = ((Integer)(session.getValue("usertype"))).intValue();
						  eventid =(String)(session.getValue("eventid"));
						  subeventid =(String)(session.getValue("subeventid"));

					 if (usertype!=1) {
						  HtmlGen.writeHeader("Access Error",pw);
						  pw.println("<h1> Access error </h1>");
						  pw.println("<p> you are unauthorised to access this page. Go away");
						  HtmlGen.writeFooter("","","","",pw);
					 } else {
						  oldn = req.getParameter("oldn");
						  oldr = req.getParameter("oldr");
						  newn = req.getParameter("newn");
						  newr = req.getParameter("newr");
						  
						  success =  sat.SharedObjects.qe.updateResult(eventid, subeventid,oldn,oldr,newn,newr);

						  if (success) {
							   HtmlGen.writeHeader("Update complete",pw);
							   pw.println("<h1> Update complete. </h1><hr>");
							   HtmlGen.writeFooter(hp+"/servlet/semres","Back to Results page",hp+"/servlet/rtoc","Return to Control Page",pw);
						  }
						  else {
							   HtmlGen.writeHeader("Update incomplete",pw);
							   pw.println("<h1> Update unsuccessful</h1>");
							   pw.println("<p>Please try again - enter the values correctly</p><hr>");
							   HtmlGen.writeFooter(hp+"/servlet/semres","Back to Results page",hp+"/servlet/rtoc","Return to Control Page",pw);
						  }
					 }
				}
				pw.close();
		   }
}

