package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class displays a list of judges for the subevent. 
 * Also lets SEM either view or delete that judge.
 *
 * @author B.Aditya
 * @version 1.00 Tue Oct 24 01:35:42 IST 2000
 */
public class SEMViewJudgeServlet extends HttpServlet
{
	 /**
	  * The doGet function checks if the session is ok and the user is indeed an EM.
	  * If so, it displays a list of subevents currently in the database, with links going
	  * off from each of them - which show a particular subevent's complete details.
	  *
	  * @param request HttpServletRequest
	  * @param response HttpServletResponse
	  */
	 public void doGet(HttpServletRequest request, HttpServletResponse response)
		  throws ServletException, IOException
		  {
			   HttpSession session;
			   String userid,eventid,subeventid,subeventname;
			   int usertype;
			   ResultSet subeventlist;
			   PrintWriter pw;
			   Vector v;
			   Judge j;
			   Enumeration e;

			   pw = response.getWriter();
			   session = request.getSession(false);
			   response.setContentType("text/html");
			   String hp = sat.Config.hostname+":"+sat.Config.port;

			   if (session==null)
			   {
					HtmlGen.writeHeader("Session Error",pw);
					pw.println("<h1> An error was encountered while processing session </h1>");
					HtmlGen.writeFooter("","","","",pw);
			   }
			   else
			   {
					userid = (session.getValue("userid")).toString();
					usertype = ((Integer)(session.getValue("usertype"))).intValue();
					eventid = (session.getValue("eventid")).toString();
					subeventid = (session.getValue("subeventid")).toString();

					if (usertype==1)
					{
						 HtmlGen.writeHeader("Judge List",pw);
						 pw.println("<h1> Judge Control Page </h1>");
						 pw.println("<center><a href="+hp+"/servlet/semaddjud>Add Judge</a><hr>");
						 v = sat.SharedObjects.qe.getJudges(eventid,subeventid);
						 e = v.elements();
						 // display
						 if (v==null) { // no judges in database
							  HtmlGen.writeHeader("Empty Judge List",pw);
							  pw.println("<p> No judges have been added for this subevent</p>");
							  pw.println("<hr>");
							  HtmlGen.writeFooter(hp+"/servlet/rtoc","Back to Control Page",hp+"/servlet/logout","Logout",pw);
						 }
						 else {
							  pw.println("<table align=center cols=3 width=50% frame=null border=0 cellspacing=3 cellpadding=3>");
							  pw.println("<th> Judge List </th>");
							  try {
								   while (e.hasMoreElements()) {
										j = (Judge)(e.nextElement());
										String jemail = j.email_id;
										String name = j.name;

										pw.println("<tr>");
										pw.println("<td>"+name+"</td>");
										pw.println("<td><form name=view action="+hp+"/servlet/semvj method=POST><input type=hidden name=subeventid value="+subeventid+"><input type=hidden name=jemail value="+jemail+"><input type=submit value=\"View Details\"></form></td>");
										pw.println("<td><form name=del action="+hp+"/servlet/semrj method=POST><input type=hidden name=subeventid value="+subeventid+"><input type=hidden name=jemail value="+jemail+"><input type=submit value=\"Delete\"></form></td>");
										pw.println("<td><form name=mail action="+hp+"/servlet/semmj><input type=hidden name=subeventid value="+subeventid+"><input type=hidden name=jname value=\""+name+"\"><input type=hidden name=jemail value="+jemail+"><input type=submit value=\"Mail\"></form></td>");
										pw.println("</tr>");
								   }
							  }catch (Exception sqle)
							  {
								   System.err.println("SQLException caught while accessing eventlist" + sqle);
							  }
							  pw.println("</table>");
							  HtmlGen.writeFooter(hp+"/servlet/rtoc","Back to Control Page",hp+"/servlet/logout","Logout",pw);
						 }
					}
					else
					{
						 HtmlGen.writeHeader("Access Error",pw);
						 pw.println("<h1> You are not authorised to access this page. Go away");
						 HtmlGen.writeFooter("","","","",pw);
					}
			   }
			   pw.close();
		  }

	 public void doPost(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException {
			   HttpSession session;
			   PrintWriter pw;
			   Judge j;
			   String userid;
			   String eventid;
			   String subeventid;
			   int usertype; 
			   String jemail;
			   Vector v;
			   Enumeration e;
			   boolean found;

			   pw = res.getWriter();
			   session = req.getSession(false);
			   res.setContentType("text/html");
			   String hp = sat.Config.hostname+":"+sat.Config.port;
			   j = new Judge();

			   if (session==null)
			   {
					HtmlGen.writeHeader("Session Error",pw);
					pw.println("<h1> An error was encountered while processing session </h1>");
					HtmlGen.writeFooter("","","","",pw);
			   }
			   else
			   {
					userid = (session.getValue("userid")).toString();
					usertype = ((Integer)(session.getValue("usertype"))).intValue();
					eventid = (session.getValue("eventid")).toString();
					subeventid = (session.getValue("subeventid")).toString();
					jemail = (String)(req.getParameter("jemail"));

					if (usertype==1)
					{
						 v = sat.SharedObjects.qe.getJudges(eventid,subeventid);
						 // there will be some judges for this event - else this would
						 // not be accessible.
						 e = v.elements();
						 found = false;
						 while (e.hasMoreElements()) {
							  j = (Judge)(e.nextElement());
							  if (j.email_id.equals(jemail)) {
								   found = true;
								   break; 
							  }
						 }
						 if (found) {
							  HtmlGen.writeHeader("Judge details",pw);
							  pw.println("<h1> Judge details </h1><hr>");
							  pw.println("<p> You can change any of these values. Press submit to effect the change. Else return to the previous page.");
							  pw.println("<form action="+hp+"/servlet/semuj method=POST>");
							  pw.println("<table align=center cols=2 width=50% border=0>");
							  pw.println("<tr><td>Name:</td><td><input type=text name=name value=\""+j.name+"\"></td></tr>");
							  pw.println("<tr><td>Email Id:</td><td>\""+j.email_id+"\"</td></tr>");
							  pw.println("<input type=hidden name=email value=\""+j.email_id+"\">");
							  pw.println("<tr><td>Address 1:</td><td><input type=text name=add1 value=\""+j.address1+"\"></td></tr>");
							  pw.println("<tr><td>Address 2:</td><td><input type=text name=add2 value=\""+j.address2+"\"></td></tr>");
							  pw.println("<tr><td>Phone no.:</td><td><input type=text name=phone value=\""+j.phone+"\"></td></tr>");
							  pw.println("<tr><td>Fax:</td><td><input type=text name=fax value=\""+j.fax+"\"></td></tr>");
							  pw.println("<tr><td><input type=submit value=Submit></td></tr>");
							  pw.println("</table>");
							  HtmlGen.writeFooter(hp+"/servlet/semvj","Back to Judge list",hp+"/servlet/rtoc","Back to Control page",pw);
						} else {
							 HtmlGen.writeHeader("Judge not found",pw);
							 pw.println("<h1> Judge not found </h1>");
							 pw.println("<p> You asked for details of a nonexistent entity. Go back to the judge list and try again</p>");
							 HtmlGen.writeFooter(hp+"/servlet/semvj","Back to Judge list",hp+"/servlet/rtoc","Back to Control page",pw);
						}
					}
			   }
			   pw.close(); 
		  }
}
