package tejas;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import sat.*;

/**
 * This class allows a subevent to view and reset details of his subevent.
 * semvsed
 * @author B.Aditya
 * @version 1.00 Sun Oct 22 20:47:41 IST 2000
 */
public class SEMViewSEServlet extends HttpServlet {
	/**
	 * The init method of the servlet
	 */
	public void init() {
	}

	/**
	 * processes a get request and spews out a form for the sysad to fill
	 *
	 * @param req The HttpServletRequest which asked for the form
	 * @param res The HttpServletResponse to which the form shall be written
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
		HttpSession hs;
		PrintWriter pw;
		String userid,eventid,subeventid;
		int usertype,i;
		SubEventData sed;
		Enumeration e;
		TimeInfo ti;
		Attrib a;
		
		pw = res.getWriter();
		hs = req.getSession(false);
		res.setContentType("text/html");
		
		if (hs == null) {
			HtmlGen.writeHeader("Invalid Session", pw);
			pw.println("<h1>Invalid Session!</h1>");
			HtmlGen.writeFooter("", "", "", "", pw);
		} else {
			eventid = (String)(hs.getValue("eventid"));
			subeventid = (String)(hs.getValue("subeventid"));
			userid = (String)(hs.getValue("userid"));
			usertype = ((Integer)(hs.getValue("usertype"))).intValue();
			
			if (usertype!=1) {
				 HtmlGen.writeHeader("Access Error",pw);
				 pw.println("<h1> You are not allowed access here </h1>");
				 HtmlGen.writeFooter("","","","",pw);
			} else {
				 sed = sat.SharedObjects.qe.getSubEventData(eventid,subeventid);
				 hs.putValue("sed", sed);
				 String hp = sat.Config.hostname+":"+sat.Config.port;

				 HtmlGen.writeHeader("View / Modify Event Details", pw);
				 pw.println("<h1>Change sub-event-specific details</h1><hr>");
				 pw.println("<form action="+ hp + "/servlet/semvsed method=POST>");
				 pw.println("<p><b> Basic details</b> </p>");
				 pw.println("<table align=center cols=2 width=50% border=0>");
				 pw.println("<tr><td>Sub Event ID </td><td>"+sed.subevent_id+"</td></tr>");
				 pw.println("<tr><td>Sub Event Name </td><td><input type=text name=sename value=\""+sed.subevent_name+"\"></td></tr>");
				 pw.println("<tr><td>Venue </td><td><input type=text name=venue value=\""+sed.venue+"\"></td></tr>");
				 if (sat.SharedObjects.val.isTeamBased(eventid))
					  pw.println("<tr><td>Team Size </td><td><input type=text name=teamsize value=\""+sed.team_size+"\"></td></tr>");
					  
				 pw.println("<tr><td>Capacity </td><td>" + sed.capacity + "</td></tr>");
				 pw.println("<input type=hidden name=capacity value="+sed.capacity+">");
				 if (sed.moderation_flag==1)
					  pw.println("<tr><td>Moderated? </td><td><input name=modf type=checkbox value=yes checked></td></tr>");
				 else
					  pw.println("<tr><td>Moderated? </td><td><input name=modf type=checkbox value=yes> </td></tr>");

				 pw.println("</table><hr>");

				 pw.println("<p><b>Dates and times</b></p>");

				 pw.println("<table align=center width=50% cols=3 border=0>");
				 pw.println("<th>Date(yyyy-mm-dd)</th><th>Start Time(hh:mm)</th><th>End Time(hh:mm)</th>");

				 i = 0;
				 e = sed.times.elements();
				 while (e.hasMoreElements()) {
					  ti = (TimeInfo)(e.nextElement());
					  
					  pw.println("<tr>");
					  pw.println("<td><input type=text name=date"+i+" value=\""+ti.date+"\"></td>");
					  pw.println("<td><input type=text name=stime"+i+" value=\""+ti.start_time+"\"></td>");
					  pw.println("<td><input type=text name=etime"+i+" value=\""+ti.end_time+"\"></td>");
					  pw.println("</tr>");
					  i++;
				 }
				 pw.println("<input type=hidden name=times value="+i+">");
				 pw.println("</table><hr>");
				
				 i=0;
				 pw.println("<p><b>Event Manager specified data</b></p>");
				 pw.println("<table align=center width=50% cols=2 border=0>");
				 pw.println("<th>Attribute</th><th>Value</th>");
				 if (sed.attrib_vals==null) {
				 } else {
					  e = sed.attrib_vals.elements();
					  while (e.hasMoreElements()) {
						   a = (Attrib)(e.nextElement());
						   pw.println("<tr>");
						   pw.println("<td>"+a.name+"</td>");
						   pw.println("<input type=hidden name=attrib" + i + " value=\"" + a.name + "\">");
						   pw.println("<td><input name=value"+i+" value=\""+a.value+"\"></td>");
						   pw.println("</tr>");
						   i++;
					  }
				 }
				 pw.println("<input type=hidden name=attribs value="+i+">");

				 pw.println("<tr><td><input type=submit value=Submit></td></tr>");
				 pw.println("</table></form><hr>");
				 HtmlGen.writeFooter(hp+"/servlet/rtoc", "Back to Control Page", hp + "/servlet/logout", "Logout", pw);		 
			}
		}
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
		 PrintWriter pw;
		 HttpSession hs;
		 SubEventData sed;
		 String name, venue, eventid,subeventid;
		 int moderation_flag;
		 int teamsize=1;
		 int times=0;
		 int attribs=0;
		 Enumeration e;
		 TimeInfo ti;
		 Attrib a;
		 boolean check;

		 String hp = sat.Config.hostname+":"+sat.Config.port;
		 hs = req.getSession(false);
		 res.setContentType("text/html");
		 pw = res.getWriter();
		 sed = (SubEventData)(hs.getValue("sed"));
		 hs.removeValue("sed");
		 eventid = (String)(hs.getValue("eventid"));
		 subeventid = (String)(hs.getValue("subeventid"));
		
		 name = req.getParameter("sename");
		 // CHANGED THIS TOO - SATYEN - WAS "location" EARLIER - SHOULD BE "venue"
		 venue = req.getParameter("venue");
		 try {
			  if (sat.SharedObjects.val.isTeamBased(eventid))
				   teamsize = (new Integer(req.getParameter("teamsize"))).intValue();
			  times = (new Integer(req.getParameter("times"))).intValue();
			  attribs = (new Integer(req.getParameter("attribs"))).intValue();
		 } catch (NumberFormatException nfe) {
			  HtmlGen.writeHeader("Error",pw);
			  pw.println("<h1> Error in entries. Please follow the link and retry </h1>");
			  pw.println("<hr>");
			  HtmlGen.writeFooter(hp + "/servlet/semvsed","Try Again",hp+"/servlet/rtoc","Return to Control Page",pw);
		 }
		 
		 if (req.getParameter("modf") == null)
			  moderation_flag = 0;
		 else
			  moderation_flag = 1;

		 sed.subevent_name = name;
		 sed.venue = venue;
		 sed.capacity = 0;
		 sed.team_size = teamsize;
		 sed.moderation_flag = moderation_flag;
		 
		 sed.times = new Vector(10, 10);
		 for (int i=0;i<times;i++) {
			  String d = req.getParameter("date"+i);
			  String st = req.getParameter("stime"+i);
			  String et = req.getParameter("etime"+i);
			  
			  sed.insertTimeInfo(d+" junk","junk "+st,"junk "+et);
		 }
		 sed.capacity = (new Integer(req.getParameter("capacity"))).intValue();
		 sed.attrib_vals = new Vector(10,10);
		 for (int i=0;i<attribs;i++) {
			  sed.insertAttribVal(req.getParameter("attrib"+i),
						req.getParameter("value"+i));
		 }

		 check = sat.SharedObjects.qe.updateSubEventData(eventid, subeventid, sed);
		 //check=true;
		 if (check) {
			  HtmlGen.writeHeader("Sub Event Details updated", pw);
			  pw.println("<h1>The sub event details have been updated to the following values </h1><hr>");
			  pw.println("<table align=center width=50% cols=2 border=0>");
			  pw.println("<tr><td>Sub Event ID </td><td>"+sed.subevent_id+"</td></tr>");
			  pw.println("<tr><td>Sub Event Name </td><td>"+sed.subevent_name+"</td></tr>");
			  pw.println("<tr><td>Venue </td><td>"+sed.venue+"</td></tr>");
			  pw.println("<tr><td>Capacity </td><td>"+sed.capacity+"</td></tr>");
			  if (sat.SharedObjects.val.isTeamBased(eventid))
				   pw.println("<tr><td>Team Size </td><td>"+sed.team_size+"</td></tr>");
				   
			  if (sed.moderation_flag==1)
				   pw.println("<tr><td>Moderated? </td><td> Yes </td></tr>");
			  else
				   pw.println("<tr><td>Moderated? </td><td> No </td></tr>");

			  pw.println("</table><hr>");
			  pw.println("<table align=center width=50% cols=3 border=0>");
			  pw.println("<th>Date</th><th>Start Time </th><th>End Time</th>");

			  e = sed.times.elements();
			  for (int i=0;i<times;i++) {
				   ti = (TimeInfo)(e.nextElement());
				   pw.println("<tr>");
				   pw.println("<td>"+ti.date+"</td>");
				   pw.println("<td>"+ti.start_time+"</td>");
				   pw.println("<td>"+ti.end_time+"</td>");
				   pw.println("</tr>");
			  }
			  pw.println("</table><hr>");


			  pw.println("<table align=center width=50% cols=2 border=0>");
			  pw.println("<th>Attribute</th><th>Value</th>");
			  e = sed.attrib_vals.elements();
			  for (int i=0;i<attribs;i++) {
				   a = (Attrib)(e.nextElement());
				   pw.println("<tr>");
				   pw.println("<td>"+a.name+"</td>");
				   pw.println("<td>"+a.value+"</td>");
				   pw.println("</tr>");
			  }
				   
			  pw.println("</table><hr>");

			  HtmlGen.writeFooter(hp+"/servlet/rtoc", "Control Page",hp+"/servlet/semvsed", "Modify again", pw);
		 } else {
			  HtmlGen.writeHeader("Error",pw);
			  pw.println("<h1> Error in entries. Please follow the link and retry </h1>");
			  pw.println("<hr>");
			  HtmlGen.writeFooter(hp + "/servlet/semvsed","Try Again",hp+"/servlet/rtoc","Return to Control Page",pw);
		 }

	}
}
