package tejas;
import sat.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

/**
 * Sub Event Manager Interface - generates the interface page for an event manager
 *
 */

public class SubEventManagerInterface
{
	 SubEventManagerInterface()
	 {}

	 /**
	  * Takes a printwriter - and appropriately throws out a control page
	  *
	  * @param pw PrintWriter
	  * @param userid userid of the person logging in
	  * @param eventid Event Id
	  * @param subeventid Sub Event Id
	  */
	 public void start(PrintWriter pw,String userid,String eventid, String subeventid)
	 {
		  boolean ft = sat.SharedObjects.val.firstTime(eventid,subeventid);
		  if (ft)
			   getAllDetails(pw,userid,eventid,subeventid);
		  else
			   showControls(pw,userid,eventid,subeventid);
	 }

	 public void start(PrintWriter pw,String userid,String eventid, String subeventid,boolean ft)
	 {
		  if (ft)
			   getAllDetails(pw,userid,eventid,subeventid);
		  else
			   showControls(pw,userid,eventid,subeventid);
	 }

	 /**
	  * <code>showControls</code> generates the controls page for an event manager
	  *
	  * @param pw PrintWriter
	  * @param userid UserId of the Sub Event Manager
	  * @param eventid Event Id
	  * @param subeventid Sub Event Id 
	  *
	  */
	 public void showControls(PrintWriter pw, String userid,String eventid, String subeventid)
	 {
		  String hp = sat.Config.hostname+":"+sat.Config.port;
		  HtmlGen.writeHeader("Sub Event Manager Controls",pw);
		  pw.println("<h1>Sub Event Manager Control Page - "+sat.SharedObjects.qe.getSubEventName(eventid,subeventid)+"</h1><hr>");
		  pw.println("<table align=center cols=1 width=40% frame=null border=0>");
		  pw.println("<tr><td><a href=\"" + hp + "/servlet/semvsed\">View/modify SubEvent Details </a> </td></tr>");
		  //if (sat.SharedObjects.val.hasRegistration(eventid,subeventid))
		  pw.println("<tr><td><a href=\"" + hp + "/servlet/semreg\">View Participant Details </a> </td></tr>");
		  //if (sat.SharedObjects.val.isModerated(eventid,subeventid))
		  pw.println("<tr><td><a href=\"" + hp + "/servlet/sempending\">View/approve pending participant applications </a> </td></tr>");
		  //if (hasJudges(eventid,subeventid)) {
		  //pw.println("<tr><td><a href=\"" + hp + "/servlet/semaddjud\">Add Judge</a> </td></tr>");
		  pw.println("<tr><td><a href=\"" + hp + "/servlet/semvj\">Judge Control Page </a> </td></tr>");
		  //}

		  pw.println("<tr><td><a href=\"" + hp + "/servlet/semres\">Results Control</a> </td></tr>");
		  pw.println("<tr><td><a href=\"" + hp + "/servlet/sds?eventid="+eventid+"\">View Schedule</a></td></tr>");
		  pw.println("<tr><td><a href=\"" + hp + "/servlet/srs?eventid="+eventid+"\">View Results</a></td></tr>");
		  pw.println("</table>");
		  HtmlGen.writeFooter(""+sat.Config.hostname+":"+sat.Config.port+"/servlet/logout","Logout",""+sat.Config.hostname+":"+sat.Config.port+"/servlet/cps","Change Password",pw);
	 }

	 /**
	  * <code> getAllDetails is called the first time the event manager logs in.
	  * It shows a form asking for extra details and other stuff.
	  *
	  * @param pw Print Writer of calling servlet
	  * @param userid User Id of subevent manager
	  * @param eventid Event Id
	  * @param subeventid Subeventid
	  */
	 public void getAllDetails(PrintWriter pw, String userid,String eventid,String subeventid)
	 {
		  String hp = sat.Config.hostname+":"+sat.Config.port;
		  Vector v = new Vector();
		  String subeventname;
		  subeventname = sat.SharedObjects.qe.getSubEventName(eventid, subeventid);
		  Enumeration e;
		  Attrib a;
		  HtmlGen.writeHeader("Sub Event Manager Controls",pw);
		  pw.println("<h1>Sub Event Manager Control Page - "+sat.SharedObjects.qe.getSubEventName(eventid,subeventid)+"</h1>");

		  pw.println("<hr><p>Please remember that this is the only chance you get to set these details.Do it well.</p><hr>");
		  pw.println("<form name=sedetails action="+hp+"/servlet/semone method=POST>");
		  pw.println("<input type=hidden name=eid value="+eventid+">");
		  pw.println("<input type=hidden name=seid value="+subeventid+">");
		  pw.println("<h1> Details for "+subeventname+"</h1>");

		  pw.println("<table>");
		  pw.println("<tr><td>Venue:</td><td><input name=venue type=text></td></tr>");
		  pw.println("<tr><td>Requires moderation ?</td><td><input name=semod type=checkbox></td></tr>");
		  if (sat.SharedObjects.val.isTeamBased(eventid)) {
			   pw.println("<tr><td>Team Size</td><td><input name=teamsize type=text></td></tr>");
		  }
		  pw.println("</table>");
		  pw.println("<hr>");

		  pw.println("<table align=center cols=3 width=50% border=0>");
		  pw.println("<th>Date(yyyy-mm-dd)</th><th>Start Time(hh:mm)</th><th>End Time(hh:mm)</th>");
		  for (int i=0;i<=4;i++) {
			   pw.println("<tr>");
			   pw.println("<td><input name=date"+i+" type=text value=\"\"></td>");
			   pw.println("<td><input name=stime"+i+" type=text value=\"\"></td>");
			   pw.println("<td><input name=etime"+i+" type=text value=\"\"></td></tr>");
		  }
		  pw.println("</table>");

		  pw.println("<hr>");
		  pw.println("<p> Event manager specified attributes </p>");
		  pw.println("<table align=center cols=2 width=50% frame=null border=0>");
		  v = sat.SharedObjects.qe.getEMSpecSEAttribs(eventid);
		  e = v.elements();
		  while (e.hasMoreElements()) {
			   a = (Attrib)(e.nextElement());
			   pw.println("<tr><td>"+a.name+":</td><td><input name=\""+a.name+"\" type=text></td></tr>");
		  }
		  pw.println("</table>");
		  pw.println("<hr>");
		  pw.println("<p> Insert upto 5 participant details you wish the participants to enter.</p>");
		  pw.println("<table align=center width=50% cols=3 frame=null border=0 cellspacing=3 cellpadding=3>");
		  pw.println("<th>Attribute Name</th><th> Mandatory? </th><th>Filled by SEM?</th>");
		  for (int i=0;i<=4;i++)
		  {
			   pw.println("<tr><td><input type=text name=pattrib"+i+" value=\"\"></td>");
			   pw.println("<td><input type=checkbox name=pismand"+i+"></td>");
			   pw.println("<td><input type=checkbox name=semfilled"+i+"></td></tr>");
		  }
		  pw.println("<hr>");
		  pw.println("<tr><td><input type=Submit value=submit></td><td><input type=Reset value=reset></td></tr>");
		  pw.println("</table");

		  HtmlGen.writeFooter(""+sat.Config.hostname+":"+sat.Config.port+"/servlet/logout","Logout",""+sat.Config.hostname+":"+sat.Config.port+"/servlet/cps","Change Password",pw);
	 }
}
