package sat;

import java.sql.*;

/**
 * this class has functions which validate the data passed in 
 * as parameters. It also returns metadata about events/subevents -
 * whether the event is team based or not, whether a user has registered
 * for subevent or not, etc.
 *
 * @author Satyen Kale
 * @version 1.00, 2/10/2K
 */

public class Validator {
	/**
	 * a connection object.
	 */
	Connection con;

	/**
	 * a constructor.
	 */
	public Validator() {
		con = SharedObjects.qe.con;
	}

	/** checks if a given event_id exists.
	 *
	 * @param event_id the id to be checked
	 * @return true if event_id exists, false otherwise
	 */
	public boolean isValidEventID(String event_id) {
		try {
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery("select * from Event " +
				" where event_id = '" + event_id + "'");
			boolean ret = rs.next();
			rs.close();
			stmt.close();
			return ret;
		} catch (SQLException sqle) {
			System.out.println("Exception isValidEventID" + sqle.getMessage());
			sqle.printStackTrace();
		}
		
		return false;
	}
	
	/** checks if a given subevent_id exists within a given event_id.
	 *
	 * @param event_id the event under which the subevent_id should exist.
	 * @param subevent_id the id to be checked.
	 * @return true if subevent_id exists, false otherwise.
	 */
	public boolean isValidSubEventID(String event_id, String subevent_id) {
		try {
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery("select * from Event " +
				" where event_id = '" + event_id + "'" +
				" and subevent_id = '" + subevent_id + "'");
			boolean ret = rs.next();
			rs.close();
			stmt.close();
			return ret;
		} catch (SQLException sqle) {
			System.out.println("Exception isValidSubEventID" + sqle.getMessage());
			sqle.printStackTrace();
		}
		
		return false;
	}

	/** returns true if a an event is team based.
	 *
	 * @param	event_id	the id of the event
	 * @exception IllegalArgumentException if this method is called when this field has not been set yet.
	 * @return	true if event is team based, false if not.
	 */
	public boolean isTeamBased(String event_id) throws IllegalArgumentException {
		try {
		Statement stmt = con.createStatement();
		ResultSet rs = stmt.executeQuery("select IC_flag from Event where event_id = '" + event_id + "'");
			if (rs.next()) {
				if (rs.getInt(1) == 1) { rs.close(); stmt.close(); return true;}
			} else 
				if (rs.getInt(1) == 0)
					{rs.close(); stmt.close(); return false;}
				else {
					rs.close();
					stmt.close();
					throw new IllegalArgumentException("ic status unknown");
				}
		} catch (SQLException sqle) {
			System.out.println("Exception isTeamBased" + sqle.getMessage());
			sqle.printStackTrace();
		}
		
		return false;
	}

	/** returns true if an event is moderated.
	 *
	 * @param	event_id	the id of the event
	 * @exception IllegalArgumentException if this method is called when this field has not been set yet.
	 * @return	true if event is moderated, false if not.
	 */
	public boolean isModerated(String event_id) throws IllegalArgumentException {
		try {
		Statement stmt = con.createStatement();
		ResultSet rs = stmt.executeQuery("select MODERATION_FLAG from Event where event_id = '" + event_id + "'");
			if (rs.next()) {
				if (rs.getInt(1) == 1) { rs.close(); stmt.close(); return true;}
			} else
				if (rs.getInt(1) == 0) {
					rs.close();
					stmt.close();
					return false;
				} else {
					rs.close();
					stmt.close();
					throw new IllegalArgumentException("moderation status unknown");
				}
		} catch (SQLException sqle) {
			System.out.println("Exception isModerated" + sqle.getMessage());
			sqle.printStackTrace();
		}
		
		return false;
	}
	
	/** returns true if a subevent is moderated.
	 *
	 * @param	event_id	the id of the event
	 * @param	subevent_id the id of the subevent
	 * @return	true if event is moderated, false if not.
	 */
	public boolean isModerated(String event_id, String subevent_id) {
		try {
		Statement stmt = con.createStatement();
		ResultSet rs = stmt.executeQuery("select MODERATION_FLAG from SubEvent " +
			"where event_id = '" + event_id + "' and " +
			"subevent_id = '" + subevent_id + "'");
			if (rs.next()) {
				if (rs.getInt(1) == 1) {
					rs.close();
					stmt.close();
					return true;
				}
			} else {
				rs.close();
				stmt.close();
				return false;
			}
		} catch (SQLException sqle) {
			System.out.println("Exception isModerated" + sqle.getMessage());
			sqle.printStackTrace();
		}
		
		return false;
	}
	
	/** returns true if the userid is registered for the given event
	 *
	 * @param userid the user's login id
	 * @param event_id the given event
	 * @return true if the user is registered, false if not
	 */
	public boolean isRegisteredFor(String userid, String event_id) {
		try {
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery("select * from Registered_for where " +
				"login_id = '" + userid + "' and event_id = '" + event_id + "' and approved = 1");
			boolean ret = rs.next();
			rs.close();
			stmt.close();
			return ret;
		} catch (SQLException sqle) {
			System.out.println("Exception isRegisteredFor" + sqle.getMessage());
			sqle.printStackTrace();
		}
		
		return false;
	}
	
	/** returns true if the Event_Manager has logged in
	 * for the first time.
	 *
	 * @param event_id the ID of the event
	 * @return true if the Event_Manager has logged in <br>for the first time, false if not.
	 */
	public boolean firstTime(String event_id) {
		try {
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery("select IC_flag from Event where event_id = '" +
				event_id + "'");
			if (! rs.next()) { rs.close(); stmt.close(); return false; }
			int IC_flag = rs.getInt(1);
			rs.close();
			stmt.close();
			if (IC_flag == 2) return true;
			return false;
		} catch (SQLException sqle) {
			System.out.println("Exception firstTime" + sqle.getMessage());
			sqle.printStackTrace();
		}
		return false;
	}
	
	/** returns true if the SubEvent_Manager has logged in
	 * for the first time.
	 *
	 * @param event_id the ID of the event
	 * @param subevent_id the ID of the subevent
	 * @return true if the SubEvent_Manager has logged in <br>for the first time, false if not.
	 */
	public boolean firstTime(String event_id, String subevent_id) {
		try {
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery("select moderation_flag from SubEvent where event_id = '" +
				event_id + "' and subevent_id = '" + subevent_id + "'");
			if (! rs.next()) { rs.close(); stmt.close(); return false; }
			int mod_flag = rs.getInt(1);
			rs.close();
			stmt.close();
			if (mod_flag == 2) return true;
			return false;
		} catch (SQLException sqle) {
			System.out.println("Exception firstTime" + sqle.getMessage());
			sqle.printStackTrace();
		}
		return false;
	}

	/**
	 * returns the next PID in the list
	 *
	 * @return the next PID
	 */
	public int nextPID() {
		try {
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery("select max(PID) from Participants");
			if (rs.next()) {
				return rs.getInt(1) + 1;
			} else {
				return 1;
			}
		} catch (SQLException sqle) {
			System.out.println("Exception nextPID" + sqle.getMessage());
			sqle.printStackTrace();
		}
		return -1;
	}
	
	/** checks if flo is already a team member
	 *
	 * @param email the email ID of the flo
	 * @return true if team member, false otherwise
	 */
	public boolean isTeamMember(String email) {
		try {
			Statement stmt = con.createStatement();
			if (email == null) return false;
			email = email.trim();
			ResultSet rs = stmt.executeQuery(
				" select email_id from Team_Member where email_id = '" + email + "'");
			boolean ret = rs.next();
			rs.close();
			stmt.close();
			return ret;
		} catch (SQLException sqle) {
			System.out.println("Exception " + sqle.getMessage());
			sqle.printStackTrace();
		}
		return false;
	}
}
