package tejas;
import java.io.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import sat.*;
import java.util.*;

/**
 * This Class displays the results of a given Sub Event as a table.
 * @author Vijay
 * @version 1.00 5 October 2000
 */
public class ViewResultServlet extends HttpServlet {
	 public void init(){
	 }
	 /**
	  * Given Gets the event and Subevent details from the page and displays
	  * the corresponding results.
	  */
	 public void doGet(HttpServletRequest req, HttpServletResponse res) 
		  throws ServletException, IOException { 
			   String eventid,subeventname,subeventid,desc,result;
			   PrintWriter pw;
			   Vector outcome;
			   Enumeration e;


			   pw = res.getWriter();
			   res.setContentType("text/html");
			   eventid = req.getParameter("eventid");
			   subeventid = req.getParameter("subeventid");
			   subeventname = sat.SharedObjects.qe.getSubEventName(eventid,subeventid); 

			   start(pw,eventid,subeventname,subeventid);
			   outcome = sat.SharedObjects.qe.getResults(eventid,subeventid);

			   if (outcome==null) {
					pw.println("<h1> No results added </h1>");
					pw.println("<p> Please try again later.");
					HtmlGen.writeFooter("","","","",pw);
			   } else {
					e = outcome.elements();
					while(e.hasMoreElements()) {
						 desc = (String)(e.nextElement());
						 result = (String)(e.nextElement());
						 Display(pw,desc,result);
					}
					pw.println("</table>");
					pw.println("</center>");
					HtmlGen.writeFooter("","","","",pw);    
			   }
		  }

	 void start(PrintWriter pw, String eventid, String subeventname, String subeventid){
		  HtmlGen.writeHeader("Results For"+subeventname,pw);
		  pw.println("<h1>Results of "+subeventname+" </h1>");
		  pw.println("<hr><br><br>");
		  pw.println("<center>");
		  pw.println("<table bgcolor=fffff0 width=50% cols=2 cellspacing=0 cellpadding=1>");
		  pw.println("<tr bgcolor=deb877><th> Description </th><th> Result </th></tr>");

	 }

	 void Display(PrintWriter pw, String desc, String result){
		  pw.print("<tr>");
		  pw.println("<td>"+desc+"</td><td>"+result+"</td></tr>");
	 }

}
