import java.awt.*;
import java.applet.*;
import java.util.*;
import java.lang.Math;

/*<applet code=Pie width=600 height=500>
<param name="arg0" value="20,nitin">
<param name="arg1" value="40,anuj">
<param name="arg2" value="30,arvind">
<param name="arg3" value="25,vishal">
</applet>
*/

class PieItem {
  public double frac; 
  public String label;

  PieItem (String s) {
    StringTokenizer t = new StringTokenizer(s, ",");
    frac = Double.valueOf(t.nextToken()).doubleValue();
    label = t.nextToken();
  } 

} 

class PieView extends Canvas {
  PieItem[] wedges; 
  double total = 0.0; 

  static final int ncolors = 5;
  Color wedgeColor[] = new Color[5];

  int pieViewSize; // size of square to incise pie into
  static final int pieBorderWidth = 50; // pixels from circle edge to side
  int pieDiameter; // derived from the view size
  int pieRadius; // ..
  int pieCenterPos; // ..
  
  public PieView(int asize, PieItem[] avec) { // constructor
    this.pieViewSize = asize; // copy args
    this.wedges = avec;

    pieDiameter = pieViewSize-2*pieBorderWidth;
    pieRadius = pieDiameter/2;
    pieCenterPos = pieBorderWidth+pieRadius;
    this.setFont(new Font("Helvetica",Font.BOLD,12));
    this.setBackground(Color.white);

    for (int i = 0; i<wedges.length; i++) {
      total += wedges[i].frac;
    }

    wedgeColor[0] = Color.green; // colors that black looks good on
    wedgeColor[1] = Color.pink;
    wedgeColor[2] = Color.cyan;
    wedgeColor[3] = Color.red;
    wedgeColor[4] = Color.yellow;
  } // constructor

  public void paint(Graphics g) {
    int startDeg = 0;
    int arcDeg;
    int x, y;
    double angleRad;

    g.setColor(Color.lightGray); // shadow
    g.fillOval(pieBorderWidth+3,pieBorderWidth+3,pieDiameter,pieDiameter);
    g.setColor(Color.gray); // "other" is gray
    g.fillOval(pieBorderWidth,pieBorderWidth,pieDiameter,pieDiameter);
    
    int wci = 0;
    int i;
    for (i = 0; i<this.wedges.length; i++) { // draw wedges
      arcDeg = (int)((this.wedges[i].frac / total) * 360);
      g.setColor(wedgeColor[wci++]);
      g.fillArc(pieBorderWidth,pieBorderWidth,pieDiameter,pieDiameter,
		startDeg, arcDeg);
      if (wci >= ncolors) {
	wci = 0; // rotate colors
      }
      startDeg += arcDeg;
    } // draw wedges
    
	startDeg = 0; // Do labels so they go on top of the wedges.
    for (i = 0; i<this.wedges.length; i++) {
      arcDeg = (int)((this.wedges[i].frac / total) * 360);
      if (arcDeg > 3) { // don't label small wedges
			g.setColor(Color.black);
			angleRad = (float) (startDeg+(arcDeg/2))* java.lang.Math.PI / 180.0;
			x = pieCenterPos + (int)((pieRadius*1.1)*java.lang.Math.cos(angleRad));
			y = pieCenterPos - (int)((pieRadius*1.1)*java.lang.Math.sin(angleRad))
            		+ 5; // 5 is about half the height of the text
			g.drawString(this.wedges[i].label+"("+this.wedges[i].frac+")", x, y);
      } // don't label small wedges
      startDeg += arcDeg;
    } // for
  } // paint()

  public Dimension preferredSize () {
    return new Dimension (pieViewSize,pieViewSize);
  } // preferredSize
  
} // PieView

// The Pie Chart applet
public class Pie extends Applet {
  private PieView the_pie = null;

  public Pie() {} 

  public void init () {
    String stemp;
    double dtemp;
    int i;

    int nargs = 0;
    while (this.getParameter("arg"+nargs) != null) {
      nargs++; 
    } 
	
    PieItem[] v = new PieItem[nargs];
    for (i=0; i<nargs; i++) {
      v[i] = new PieItem(getParameter("arg"+i));
    } 

      
	int h = this.size().height;
    int w = this.size().width;
    the_pie = new PieView(h-50, v); // shd be min(h-50,w)?
    this.setLayout(new BorderLayout(0,0));
    this.setBackground(Color.white);
    this.add("Center", the_pie);
  } 


} 
