import java.io.*;
import javax.servlet.http.* ;
import java.lang.*;
/** Functions for generating html tagged entries */
public class Page
{
	 StringBuffer matter;
	 String file;
	 
	 //Constructors
	 Page()
	 {
	 matter=new StringBuffer();
	 }
	
	 Page(String filename)
	 {
		  file= filename;
		  try{
		  BufferedReader infile=new BufferedReader(new FileReader("file"));
		  while
		  ((matter=matter.append(infile.readLine() ))!=null);
		  }catch (IOException e){};
	 }
	
	 //Functions to actually publish an HTML document
	 
	 public void printHtml(PrintWriter out)
	 {
		  out.write(matter.toString());
	 }
	 
	 public void printHtml(PrintWriter out,String filename)
	 {
		try{
		  FileInputStream f1=new FileInputStream(filename);
		  while (f1.available() >0)
	         out.write(f1.read());
		}catch(Exception e){System.out.println (e);}
	 }

	 public void writetofile(String filename)
	 {
		  try{
			   FileOutputStream fout=new FileOutputStream(filename);
			   fout.write(matter.toString().getBytes());
		  }catch (Exception e){ System.out.println(e);}
	 }

	 //HTML tags are created
	 public void addTitle(String title)
	 {
		 matter=matter.append("<html><head><title>"+title+"</title> </head>\n"+
	        "<body bgcolor='white' text='black' link='blue' vlink='pink' >\n");
	 }
	 
	 public String returnPage()
	 {
		  matter=matter.append("<br><a href='http://www.cse.iitb.ernet.in/~anuj/dbis/centre.html'>Click here</a>");
		  matter=matter.append("</body></html>\n");
		  return (matter.toString());
	 }

	 public String returnPage(String s)
	 {
		  matter=matter.append("</body></html>\n");
		  return (matter.toString());
	 }
	 
	 //Error messages generated here
	 public void printError(PrintWriter out,String error)
	 {
		  this.addTitle("ERROR");
		  this.addText(error,"bold");
		  this.returnPage();
		  this.printHtml(out);
	 }

	 public void printError(PrintWriter out,String errorcode,String error,Exception e)
	 {
		  this.addTitle(errorcode);
		  this.addText(error,"bold");
		  this.addText(e.getMessage(),"bold");
		  this.returnPage();
		  this.printHtml(out);
	 }


	//Tables created with these functions
	 public void addTable(String title)
	 {
		  matter=matter.append("<table border='0'>\n");
		  matter=matter.append("<caption>"+title+"</caption>\n");
	 }
     
	 public void addTableHeader(String headers[])
	 {
		for (int i=0;i<headers.length;i++)
		  {
			matter=matter.append("<th>"+headers[i]+"</th>\n") ;
		  }
	 }

	 public void addTableElement(String elements[])
	 {
			  matter=matter.append("<tr>\n");
		  for (int i=1;i<=elements.length;i++)
		  {
			matter=matter.append("<td> "+elements[i-1]+"</td>\n") ;
		  }
		  matter=matter.append("</tr>\n");
	 }
    	 
	 public void addTableElement(String element)
	 {
		  
		  matter=matter.append("<tr>\n");
		  matter=matter.append("<td>"+element+"</td>\n") ;
		  matter=matter.append("</tr>\n");
	 }

	 public void addTableRow(String desc)
	 {
		  matter=matter.append("<tr "+desc+" >\n");
	 }

	 public void endTableRow()
	 {
		  matter=matter.append("</tr>\n");
	 }

	 public void addTableData(String desc)
	 {
		  matter=matter.append("<td "+desc+" >\n");
	 }
     
	 public void returnTable()
	 {
		  matter=matter.append("</table>\n");
	 }

		//Forms created with these functions
	 public void addForm(String method , String action)
	 	{  matter = matter.append("<form method=" + method + " action=\"" + action +"\">\n" );
	    }
	 
	 public void addInputValue(String type , String value )
	 {  matter=matter.append("<br><input type=" + type + "  value=\"" + value + "\" >\n" );}

	 public void addInputName(String label ,String type , String name)
	 {
		matter=matter.append("<br>" + label + " <input type=" + type + "  name=\"" + name + "\" >\n" );	   
	 }
		  
	 public void addInput(String label ,String type , String name ,String value)
	 { matter = matter.append("<br>" + label + " <input type=" + type + "  name=\"" + name + "\"  value=\"" 
			                        + value + "\"  >\n") ;
	 }
	 public void returnForm()
	 {
		  matter=matter.append("</FORM>\n");
	 }
	 
	 // just add text
	public void addText(String text , String style)
	{   if (style.equals("bold")) 
		 matter = matter.append("<b> "+ text + " </b>");
		 else 
		 matter = matter.append("<it> "+ text + " </it>");
	}   	

	public void addQuestion(String body,String opt_count,String keyword){
		  matter = matter.append("<form method=post action='http://everest.cse.iitb.ernet.in:9001/servlet/questionHandler'>\n"); 
		  matter = matter.append("<br> <table border=\"0\">\n"); 
		  matter = matter.append("<caption><h1>Question Details</h1></caption>\n"); 
		  matter = matter.append("<tr>\n"); 
		  matter = matter.append("<td bgcolor=\"red\"> <font size=5>Question statement</font></td>\n"); 
		  matter = matter.append("<td>"); 
		  matter = matter.append("<textarea  name=\"body\" rows=\"4\" cols=\"100\">"+body+"</textarea>\n" ); 
		  matter = matter.append("</td>\n"); 
		  matter = matter.append("</tr>\n"); 
		  matter = matter.append("<tr>\n"); 
		  matter = matter.append("<td bgcolor=\"red\"><font size=5>Keywords( for search referencing)</font></td>\n" ); 
		  matter = matter.append("<td>\n"); 
		  matter = matter.append("<input type=text name=\"keyword\" value="+keyword+" >\n"); 
		  matter = matter.append("</td>\n"); 
		  matter = matter.append("</tr>\n"); 
		  matter = matter.append("<tr>\n"); 
		  matter = matter.append("<td bgcolor=\"red\"><font size=5> Number of options </font></td>\n"); 
		  matter = matter.append("<td>\n"); 
		  matter = matter.append("<input  type=text  name=\"opt_count\" value="+opt_count+" >\n"); 
		  matter = matter.append("</td>\n"); 
		  matter = matter.append("</tr>\n");
		  matter = matter.append("</table>\n");
	}

	
	public void addSection(String qpaper_title,int tmarks,int serial_no,int section_count,String section_title,String inst)
	{
		int sno=serial_no+1;
		matter=matter.append("<form method='post' action='http://everest.cse.iitb.ernet.in:9001/servlet/addquestionhow'> ");
		matter=matter.append("<table border='0'>" +
		" <caption><h1>Section "+ serial_no + " Details</h1></caption> \n" );
		matter=matter.append("<tr><td bgcolor='red'><font size=5>Section title</font></td>" +
		"<td><input type='text' name='section_title' value='"+section_title+"' size='20'></td></tr>" );
		matter=matter.append(" <tr><td bgcolor='red'><font size=5>Instructions</font></td><td><input type='text' name='section_instr' value='"+inst+"' size='20'></td></tr>");
		matter=matter.append("<input type='hidden' name='qpaper_title' value='"+qpaper_title+"'>");
		matter=matter.append("<input type='hidden' name='total_marks' value='"+tmarks+"'>");
		matter=matter.append("<input type='hidden' name='section_count' value='"+section_count+"'>");
		matter=matter.append("<input type='hidden' name='serial_no' value="+serial_no+">");
		matter=matter.append("<input type='hidden' nAme='flag' value=1>");
		matter=matter.append("<tr><td><input type='submit' value='Add question'><br></td></tr>");
		matter=matter.append("</table></form>");
/*		matter=matter.append("<form name='form1' method='post' action='http://everest.cse.iitb.ernet.in:9001/servlet/addOldQuestion'>");
		matter=matter.append("<input type='submit' value='add old question'><br>");
		matter=matter.append("<input type='hidden' name='qpaper_title' value='"+qpaper_title+"'>");
		matter=matter.append("<input type='hidden' name='total_marks' value='"+tmarks+"'>");
		matter=matter.append("<input type='hidden' name='section_count' value='"+section_count+"'>");
		matter=matter.append("<input type='hidden' name='serial_no' value="+serial_no+">");
		matter=matter.append("<input type='hidden' name='section_title' value='' >");
		matter=matter.append("</form>");*/
		matter=matter.append("<form method='post' action='http://everest.cse.iitb.ernet.in:9001/servlet/qpaperHandler'>");
		matter=matter.append("<input type='hidden' name='qpaper_title' value='"+qpaper_title+"'>");
		matter=matter.append("<input type='hidden' name='serial_no' value="+sno+">");
		matter=matter.append("<input type='hidden' name='total_marks' value='"+tmarks+"'>");
		matter=matter.append("<input type='hidden' name='section_count' value='"+section_count+"'>");
		matter=matter.append("<input type='submit' value='Done'></form>");
        matter=matter.append("<input type='hidden' name='flag' value=1 >");		
        matter=matter.append("<input type='hidden' name='flag1' value="ullu" >");		
		
	}
			  			
			


	public void addOption(int i)
	{
			  this.addTableRow("");
			  this.addTableData("");
			  this.addInput(" ","checkbox" ,"opt", "" + i);
			  this.addTableData("");
		 	  this.addInputName("Option " +i , "text" ,"option" + i );
			  this.endTableRow();
	}

	public void addCheckedOption(int i)
	{
			  this.addInputName("option " +i , "text" ,"option" + i );
			  this.addInput("","checkbox  checked " ,"opt", "" + i);
    } 
//to add extra tags apart from form and table tags
	public void addElt(String str){
		 matter = matter.append(str);
	}

		 
	
}

