import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import HtmlPage.*;
/* This establishes the connection */
public class EvalAnalyse extends EvalServlet

{
	
	 private PrintWriter out;
	 private int size;
	 private String test_title,grade,weight,floor,ceiling;
	 private float weightage;
	 private int range_floor,range_ceiling,num_of_students,num_of_questions;
	 private Grade_Scheme[] gradesDone;
	 private Grade_Scheme currentGrade;
	 private Statement stmt;
	 private String[][] Response;
	 private int[][] Marks;
	 private String[] Students,Grade;
	 private int[] Questions,TotalMarks;
	 private float[] Percentile;
	 
	 public synchronized void doGet(HttpServletRequest req,HttpServletResponse res) throws
		  					IOException,ServletException
	{
	
		 
		 res.setContentType("text/html");
		 out=res.getWriter(); 


		 int flag = Integer.parseInt(req.getParameter("flag"));
		 test_title=req.getParameter("test");
		 HtmlPage evalAnalysePage=new HtmlPage();
		 boolean ok,revalflag;
		 String temp;

		 temp=req.getParameter("reval");

		 revalflag=(temp==null);

		 
		 if ( !( ok=(readGrade(con)&&readGradeReport(con))) || revalflag)
			 ok= (evalMarks(con) && evalGradeReport(con));
		 if (ok)
		 	  switch(flag){
					  case 0:
				   		  //Grade Report
		 		 		  generateGR(evalAnalysePage,"");
				  		  break;
			  		  case 1:
				   		  //Gradewise Pie Chart
				   		  generatePC(evalAnalysePage,"");
				   		  break;
			  		  case 2:
				 		  //Gradewise Bar Graph
			 		  case 3:
				  		 //Questionwise response
		 			}
				   
	}
	
	 public void doPost(HttpServletRequest req,HttpServletResponse res) throws
		  					IOException,ServletException
	{ 
		 doGet(req,res);
	}

		 

	 public boolean evalMarks(Connection con)
	 {
		  try{
			  			   		
			   Statement stmt=con.createStatement();
			   ResultSet rs,rs1;
			   
			   //finding number of students
			   String query="select count (distinct rollno) from test_response"
					+" where test_title like '"+test_title+"'";
			   rs=stmt.executeQuery(query);
			   rs.next();
			   num_of_students=rs.getInt(1);
			   Students=new String[num_of_students];
			   TotalMarks=new int[num_of_students];
			   Percentile=new float[num_of_students];
			   Grade=new String[num_of_students];

			   //finding number of questions
			   query="select count (distinct question_no) from test_response"
					+" where test_title like '"+test_title+"'";
			   rs=stmt.executeQuery(query);
			   rs.next();
			   num_of_questions=rs.getInt(1);
			   Questions=new int[num_of_questions];

			   Response=new String[num_of_students][num_of_questions];
			   Marks=new int[num_of_students][num_of_questions];

			   //Responses read here
			   query="select rollno,question_no,choice from test_response"
					+" where test_title like '"+test_title+"' "
					+" order by rollno,question_no ";
			   rs=stmt.executeQuery(query);
			   for (int i=0;i<num_of_students;i++)
					for (int j=0;j<num_of_questions;j++)
					{
						 rs.next();
						 Students[i]=rs.getString(1);
						 Questions[j]=rs.getInt(2);
						 Response[i][j]=rs.getString(3);
						 TotalMarks[i]=0;
					}
			   
			   //Responses compared with answers and marks given
			   query="select test_response.rollno,test_response.question_no,question.ans,q_in_paper.marks "
					+" from question,q_in_paper,test_response "
					+" where q_in_paper.serial_no=test_response.question_no "
					+" and q_in_paper.q_id=question.id "
					+" order by test_response.rollno,test_response.question_no";
			   rs=stmt.executeQuery(query);
			   			 
			   Statement stmt1=con.createStatement();
			   
			   for (int i=0;i<num_of_students;i++)
					for (int j=0;j<num_of_questions;j++)
					{
						 rs.next();
						 if (Students[i].equals(rs.getString(1))
							&& Questions[j]==rs.getInt(2)	   
							&& Response[i][j].equals(rs.getString(3)) )
							  Marks[i][j]=rs.getInt(4);
						 else Marks[i][j]=0;
			   			 query="update test_response "
								+" set marks="+Marks[i][j]
								+" where test_title like '"+test_title+"'"
								+" and rollno like '"+Students[i]+"'"
								+" and question_no="+Questions[j]+"";

						 stmt1.executeUpdate(query);
						 TotalMarks[i]+=Marks[i][j];
					}
			   return true;
					
		  }catch(SQLException e){
		  		//catches NumberFormat as well as SQL exception
			   HtmlPage errorPage=new HtmlPage();
			   generate(errorPage," Exception : Could not update values"+e.getMessage());
			   return false;
		  }
	 }
						
	 public boolean readGrade(Connection con)
	 {
		  try{
			   Statement stmt=con.createStatement();
			   String query;
			   ResultSet rs,rs1;
			   
			   query="select count(grade) "
					+" from grade_scheme where test_title like '"+test_title+"'";
			   rs=stmt.executeQuery(query);

			   rs.next();
			   size=rs.getInt(1);

			   gradesDone=new Grade_Scheme[size];

			   query="select grade,weightage,range_floor,range_ceiling"
					+" from grade_scheme where test_title like '"+test_title+"'";
			   rs=stmt.executeQuery(query);

			   if (size==0) rs.next();

		  	   for  (int i=0;i<size;i++)
		  	   {
			   		rs.next();
					grade=rs.getString(1);
					weightage=rs.getFloat(2);
					range_floor=rs.getInt(3);
					range_ceiling=rs.getInt(4);

					gradesDone[i]=new Grade_Scheme(test_title,grade,weightage,range_floor,range_ceiling);
			   }

			   return true;
			   
		  }catch(Exception e)
		  {
		  		//catches NumberFormat as well as SQL exception
			   HtmlPage errorPage=new HtmlPage();
			   generate(errorPage," Exception : Could not read values from grade scheme <br>"+e.getMessage());
			   return false;
		  }
	 }

	 //awards Grades
	 public boolean evalGradeReport(Connection con)
	 {
		  try{
			  			   		
			   Statement stmt=con.createStatement();
			   ResultSet rs;
			   Grade_Report Greport;

			   for (int i=0;i<num_of_students;i++)
			   {
					Percentile[i]=evalPercentile(i);
					Grade[i]=evalGrade(i);
					Greport=new Grade_Report(test_title,Students[i],Grade[i],TotalMarks[i],Percentile[i]);
					Greport.insertRow(stmt);
			   }

			   return true;
			   
		  }catch(Exception e)
		  {
		  		//catches NumberFormat as well as SQL exception
			   HtmlPage errorPage=new HtmlPage();
			   generate(errorPage," Exception : Could not insert values in grade report "+e.getMessage());
			   return false;
		  }
	 }

	 public float evalPercentile(int m)
	 {
		  int numBelow=0;
		  for (int i=0;i<num_of_students;i++)
			   if(TotalMarks[i]<TotalMarks[m])
					numBelow++;
		  return (numBelow*100)/num_of_students;
	 }

	 public String evalGrade(int m)
	 {
		  for (int i=0;i<size;i++)
			   if ((TotalMarks[m]<gradesDone[i].range_ceiling)
					&& (TotalMarks[m]>=gradesDone[i].range_floor))
					return gradesDone[i].grade;
		  return "None";
	 }

	 public boolean readGradeReport(Connection con)
	 {
		  try
		  {
			   Statement stmt=con.createStatement();
			   ResultSet rs;

			   String query="select count(grade) from grade_report "
							+" where test_title like '"+test_title+"'";

			   rs=stmt.executeQuery(query);
			   rs.next();

			   num_of_students=rs.getInt(1);
			   if (num_of_students==0)
					return false;
			   else
			   {
					Students=new String[num_of_students];
					TotalMarks=new int[num_of_students];
					Percentile=new float[num_of_students];
					Grade=new String[num_of_students];

			   		query="select * from grade_report "
							+" where test_title like '"+test_title+"'";
					rs=stmt.executeQuery(query);
					if (num_of_students==0) rs.next();

					for (int i=0;i<num_of_students;i++)
					{
						 rs.next();
						 Students[i]=rs.getString(2);
						 Grade[i]=rs.getString(3);
						 TotalMarks[i]=rs.getInt(4);
						 Percentile[i]=rs.getFloat(5);
						 for(int j=0;j<size;j++)
							  if (Grade[i].equals(gradesDone[j].grade))
							  { System.out.println( "readgradereport "+Grade[i]+ " "+gradesDone[i].grade+" "+gradesDone[i].studentnum );
								   gradesDone[j].studentnum++;
							  }
					}
			   }
			   
			   return true;
			   
		  }catch(Exception e)
		  {
		  		//catches NumberFormat as well as SQL exception
			   HtmlPage errorPage=new HtmlPage();
			   generate(errorPage," Exception : Could not read values "+e.getMessage());
			   return false;
		  }
	 }



	 //generates Grade Report
	 public void generateGR(HtmlPage evalSchemePage,String message)
	 {
		  evalSchemePage.startPage("Grade Report");
		  evalSchemePage.setMenuItem("<h2>"+test_title+"</h2>");
		  evalSchemePage.setMenuItem("<b>"+message+"</b>");
		  evalSchemePage.setMenuItem("<a href=\"http://"+HOST+":"+SERVERPORT+"/servlet/EvalAnalyse?flag=0&reval=1&test="+test_title+"\">"
									+"<font color=red><h4> Revaluate</h4></font></a>");
		  evalSchemePage.setMenuItem("<a href=\"http://"+HOST+":"+SERVERPORT+"/servlet/EvalAnalyse?flag=1&test="+test_title+"\">"
									+"<font color=red><h4> View Gradewise Pie Chart</h4></font></a>");
		  evalSchemePage.setMenuItem("<a href=\"http://"+HOST+":"+SERVERPORT+"/servlet/EvalAnalyse?flag=2&test="+test_title+"\">"
									+"<font color=red><h4>View Gradewise Bar graph </h4></font></a>");
		  evalSchemePage.startBody();
		  evalSchemePage.setBodyItemRow("<td><font color=white><b>Student roll no</b></font></td>\n"
										+"<td><font color=white><b>Grade</b></font></td>\n"
										+"<td><font color=white><b>Total Marks</b></font></td>\n"
										+"<td><font color=white><b>Percentile</b></font></td>\n");
		  for (int i=0;i<num_of_students;i++)
		  {
			   HtmlPage gradeRow=new HtmlPage();
			   gradeRow.addTableData("","<font color=white><b>"+Students[i]+"</b></font>\n");
			   gradeRow.addTableData("","<font color=white><b>"+Grade[i]+"</b></font>\n");
			   gradeRow.addTableData("","<font color=white><b>"+TotalMarks[i]+"</b></font>\n");
			   gradeRow.addTableData("","<font color=white><b>"+Percentile[i]+"</b></font>\n");
			   evalSchemePage.setBodyItemRow(gradeRow);
		  }
		  evalSchemePage.startFooter();
   		  evalSchemePage.setFooterItem("<a href=\"http://"+HTMLHOME+"mainMenu.html\">Main Menu</a>");
   	  	  evalSchemePage.setFooterItem("<a href=\"http://"+HTMLHOME+"evalMenu.html\">Evaluation Menu</a>");
   		  evalSchemePage.setFooterItem("<a href=\"http://"+HOST+":"+SERVERPORT+"/servlet/LogoutServlet\">LOGOUT</a>");
   		  evalSchemePage.endPage(HTMLHOME);
   		
   		  evalSchemePage.printHtml(out);

	 }

	 
	 public void generatePC(HtmlPage evalSchemePage,String message)
	 {
		  evalSchemePage.startPage("Grade Report");
		  evalSchemePage.setMenuItem("<h2>"+test_title+"</h2>");
		  evalSchemePage.setMenuItem("<b>"+message+"</b>");
		  evalSchemePage.setMenuItem("<a href=\"http://"+HOST+":"+SERVERPORT+"/servlet/EvalAnalyse?flag=0&reval=1&test="+test_title+"\">"
									+"<font color=red><h4> Revaluate</h4></font></a>");
		  evalSchemePage.setMenuItem("<a href=\"http://"+HOST+":"+SERVERPORT+"/servlet/EvalAnalyse?flag=1&test="+test_title+"\">"
									+"<font color=red><h4> View Gradewise Pie Chart</h4></font></a>");
		  evalSchemePage.setMenuItem("<a href=\"http://"+HOST+":"+SERVERPORT+"/servlet/EvalAnalyse?flag=2&test="+test_title+"\">"
									+"<font color=red><h4>View Gradewise Bar graph </h4></font></a>");
		  evalSchemePage.startBody();
		  evalSchemePage.setBodyItemRow("<td><font color=white><b>Student roll no</b></font></td>\n"
										+"<td><font color=white><b>Grade</b></font></td>\n"
										+"<td><font color=white><b>Total Marks</b></font></td>\n"
										+"<td><font color=white><b>Percentile</b></font></td>\n");
		  for (int i=0;i<num_of_students;i++)
		  {
			   HtmlPage gradeRow=new HtmlPage();
			   gradeRow.addTableData("","<font color=white><b>"+Students[i]+"</b></font>\n");
			   gradeRow.addTableData("","<font color=white><b>"+Grade[i]+"</b></font>\n");
			   gradeRow.addTableData("","<font color=white><b>"+TotalMarks[i]+"</b></font>\n");
			   gradeRow.addTableData("","<font color=white><b>"+Percentile[i]+"</b></font>\n");
			   evalSchemePage.setBodyItemRow(gradeRow);
		  }

		  evalSchemePage.setBodyItem("<center><h3><font color=white>PIE CHART</h3></center>");
		  	HtmlPage pieApplet=new HtmlPage();
		  	pieApplet.addElt("<applet code=Pie.class codebase=\"http://"+HTMLHOME+"\" width=600 height=500>");
		  	for (int i=0;i<num_of_students;i++)
				   pieApplet.addElt("<param name=\"arg"+i+"\" value=\""
							 +gradesDone[i].studentnum+","+gradesDone[i].grade+"\">");
		  	pieApplet.addElt("</applet>");
		  
		  evalSchemePage.setBodyItem(pieApplet);	
		  evalSchemePage.startFooter();
   		  evalSchemePage.setFooterItem("<a href=\"http://"+HTMLHOME+"mainMenu.html\">Main Menu</a>");
   	  	  evalSchemePage.setFooterItem("<a href=\"http://"+HTMLHOME+"evalMenu.html\">Evaluation Menu</a>");
   		  evalSchemePage.setFooterItem("<a href=\"http://"+HOST+":"+SERVERPORT+"/servlet/LogoutServlet\">LOGOUT</a>");
   		  evalSchemePage.endPage(HTMLHOME);
   		
   		  evalSchemePage.printHtml(out);

	 }

	//Error pages etc printed by this
	 public void generate(HtmlPage evalSchemePage,String message)
	 {
		  evalSchemePage.startPage("Evaluation Scheme");
		  evalSchemePage.setMenuItem("<h2>"+test_title+"</h2>");
		  evalSchemePage.setMenuItem("<b>"+message+"</b>");
		  evalSchemePage.startBody();
		  evalSchemePage.startFooter();
   		  evalSchemePage.setFooterItem("<a href=\"http://"+HTMLHOME+"mainMenu.html\">Main Menu</a>");
   	  	  evalSchemePage.setFooterItem("<a href=\"http://"+HTMLHOME+"evalMenu.html\">Evaluation Menu</a>");
   		  evalSchemePage.setFooterItem("<a href=\"http://"+HOST+":"+SERVERPORT+"/servlet/LogoutServlet\">LOGOUT</a>");
   		  evalSchemePage.endPage(HTMLHOME);
   		
   		  evalSchemePage.printHtml(out);

	 }


//class ends
}
