import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import HtmlPage.*;
/* This establishes the connection */
public class EvalScheme extends EvalServlet

{
	
	 private PrintWriter out;
	 private int size;
	 private String test_title,grade,weight,floor,ceiling;
	 private float weightage;
	 private int range_floor,range_ceiling;
	 private Grade_Scheme[] gradesDone;
	 private Grade_Scheme currentGrade;
	 private Statement stmt;
	 
	 public synchronized void doGet(HttpServletRequest req,HttpServletResponse res) throws
		  					IOException,ServletException
	{
	
		 
		 res.setContentType("text/html");
		 out=res.getWriter(); 
		 int flag = Integer.parseInt(req.getParameter("flag"));
		 test_title=req.getParameter("test");
		 HtmlPage evalSchemePage=new HtmlPage();
		 readGrade(con);
		 
		 switch(flag){
			  case 0:
		 		   generate(evalSchemePage,"");
				   break;
			 
			  case 1:
				   grade=req.getParameter("grade");
				   weight=req.getParameter("weightage");
				   floor=req.getParameter("floor");
				   ceiling=req.getParameter("ceiling");

				   if (gradeUpdate(con,grade,weight,floor,ceiling))
				   {
		 				readGrade(con);
						generate(evalSchemePage,"");
				   }
				   break;
		 }
				   
	}
	
	 public void doPost(HttpServletRequest req,HttpServletResponse res) throws
		  					IOException,ServletException
	{ 
		 doGet(req,res);
	}

		 

	 public boolean gradeUpdate(Connection con,String grade,String weight,String floor,String ceiling)
	 {
		  try{
			   this.grade=grade.trim();
			   this.weight=weight.trim();
			   this.floor=floor.trim();
			   this.ceiling=ceiling.trim();
			   Float temp=new Float(weight);
			   this.weightage=temp.floatValue();
			   this.range_floor=Integer.parseInt(floor);
			   this.range_ceiling=Integer.parseInt(ceiling);
			   
			   if ((range_ceiling>=range_floor)&&(!(grade.equals(""))) 
					&& (Valid(range_floor,range_ceiling)|| Valid(grade) ) )
			   {
					currentGrade=new Grade_Scheme(test_title,grade,weightage,range_floor,range_ceiling);
			   		Statement stmt=con.createStatement();
		  	   		currentGrade.insertRow(stmt);
					return true;
					}
			   else 
			   {
					HtmlPage errorPage=new HtmlPage();
					generate(errorPage,"Data not of proper type");
			   		return false;
			   }
				
					
		  }catch(Exception e){
		  		//catches NumberFormat as well as SQL exception
			   HtmlPage errorPage=new HtmlPage();
			   generate(errorPage," Exception : Could not insert values"+e.getMessage());
			   return false;
		  }
	 }
						
	 public void readGrade(Connection con)
	 {
		  try{
			   Statement stmt=con.createStatement();
			   String query;
			   ResultSet rs;
			   
			   query="select count(grade) from grade_scheme "
					+" where test_title like '"+test_title+"'";
			   rs=stmt.executeQuery(query);

			   rs.next();
			   size=rs.getInt(1);

			   gradesDone=new Grade_Scheme[size];
			   

			   query="select grade,weightage,range_floor,range_ceiling"
					+" from grade_scheme"
					+" where test_title like '"+test_title+"'";
			   rs=stmt.executeQuery(query);

		  	   for  (int i=0;i<size;i++)
		  	   {
			   		rs.next();
					grade=rs.getString(1);
					weightage=rs.getFloat(2);
					range_floor=rs.getInt(3);
					range_ceiling=rs.getInt(4);

					gradesDone[i]=new Grade_Scheme(test_title,grade,weightage,range_floor,range_ceiling);
			   }
		  }catch(Exception e)
		  {
		  		//catches NumberFormat as well as SQL exception
			   HtmlPage errorPage=new HtmlPage();
			   generate(errorPage," Exception : Could not read values"+e.getMessage());
		  }
	 }

	 public boolean Valid(int range_floor,int range_ceiling)
	 {
		  boolean valid=true;
		  for (int i=0;i<size&&valid;i++)
			   valid=valid && !(( (range_floor <= gradesDone[i].range_ceiling) 
							  		&&(range_floor >gradesDone[i].range_floor)
						 		|| (range_ceiling < gradesDone[i].range_ceiling) 
							  		&&(range_ceiling >=gradesDone[i].range_floor)) );
		  return valid;
	 }

	 public boolean Valid(String grade)
	 {
		  boolean valid=false;
		  for (int i=0;i<size&& !(valid);i++)
			   valid=valid || (grade.equals(gradesDone[i].grade)); 
		  return valid;
	 }

	 public void generate(HtmlPage evalSchemePage,String message)
	 {
		  evalSchemePage.startPage("Evaluation Scheme");
		  evalSchemePage.setMenuItem("<h2>"+test_title+"</h2>");
		  evalSchemePage.setMenuItem("<b>"+message+"</b>");
		  evalSchemePage.startBody();
		  evalSchemePage.setBodyItemRow("<td><font color=white><b>Grade Title</b></font></td>\n"
										+"<td><font color=white><b>Weightage</b></font></td>\n"
										+"<td><font color=white><b>Range Ceiling</b></font></td>\n"
										+"<td><font color=white><b>Range Floor</b></font></td>\n");
		  evalSchemePage.addForm("POST","http://"+HOST+":"+SERVERPORT+"/servlet/EvalScheme");
		  evalSchemePage.addInput("","hidden","flag","1");
		  evalSchemePage.addInput("","hidden","test",test_title);
		  evalSchemePage.setBodyItemRow("<td><input type=\"text\" maxlength=10 name=\"grade\"></input></td>\n"
					            +"<td ><input type=\"text\" maxlength=5 name=\"weightage\"></input></td>\n"
								+"<td ><input type=\"text\" maxlength=5 name=\"ceiling\"></input></td>\n"
								+"<td ><input type=\"text\" maxlength=5 name=\"floor\"></input></td>\n");
		  evalSchemePage.setBodyItemRow("<td></td><td></td>\n"
								+"<td><input type=reset value=clear></input></td>\n"
								+"<td><input type=Submit value=Submit></input></td>\n");
		  evalSchemePage.returnForm();
		  for (int i=0;i<size;i++)
		  {
			   HtmlPage gradeRow=new HtmlPage();
			   gradeRow.addTableData("","<font color=white><b>"+gradesDone[i].grade+"</b></font>");
			   gradeRow.addTableData("","<font color=white><b>"+gradesDone[i].weightage+"</b></font>");
			   gradeRow.addTableData("","<font color=white><b>"+gradesDone[i].range_ceiling+"</b></font>");
			   gradeRow.addTableData("","<font color=white><b>"+gradesDone[i].range_floor+"</b></font>");
			   evalSchemePage.setBodyItemRow(gradeRow);
		  }
		  evalSchemePage.startFooter();
   		  evalSchemePage.setFooterItem("<a href=\"http://"+HTMLHOME+"mainMenu.html\">Main Menu</a>");
   	  	  evalSchemePage.setFooterItem("<a href=\"http://"+HTMLHOME+"evalMenu.html\">Evaluation Menu</a>");
   		  evalSchemePage.setFooterItem("<a href=\"http://"+HOST+":"+SERVERPORT+"/servlet/LogoutServlet\">LOGOUT</a>");
   		  evalSchemePage.endPage(HTMLHOME);
   		
   		  evalSchemePage.printHtml(out);

	 }


//class ends
}
