import java.io.*;
import javax.servlet.http.* ;
import java.lang.*;
/** Functions for generating html tagged entries */
public class HtmlPage
{
	 StringBuffer matter;
	 String file;
	 
	 //Constructors
	 HtmlPage()
	 {
	 matter=new StringBuffer();
	 }
	
	 HtmlPage(String filename)
	 {
		  file= filename;
		  try{
		  BufferedReader infile=new BufferedReader(new FileReader("file"));
		  while
		  ((matter=matter.append(infile.readLine() ))!=null);
		  }catch (IOException e){};
	 }
	
	 //Functions to actually publish an HTML document
	 
	 public void printHtml(PrintWriter out)
	 {
		  out.write(matter.toString());
	 }
	 
	 public void printHtml(PrintWriter out,String filename)
	 {
		try{
		  FileInputStream f1=new FileInputStream(filename);
		  while (f1.available() >0)
	         out.write(f1.read());
		}catch(Exception e){System.out.println (e);}
	 }

	 public String toString(String filename)
	 {
		try{
		  FileInputStream fis=new FileInputStream(filename);
		  DataInputStream dis = new DataInputStream(fis);
   		  BufferedReader input = new BufferedReader(new InputStreamReader(dis));
		  String in;
		  
		  while ((in=input.readLine())!=null)
		  { 
			   matter.append(in);
		  }
		  return matter.toString();

		}catch(IOException e){
			 return "FAIL";
			 }
	 }

	 public void writetofile(String filename)
	 {
		  try{
			   FileOutputStream fout=new FileOutputStream(filename);
			   fout.write(matter.toString().getBytes());
		  }catch (Exception e){ System.out.println(e);}
	 }

	 
	 public void insertPage(HtmlPage page)
	 {
		  matter=matter.append(page.matter);
	 }
	 
	 //HTML tags are created
	 public void addTitle(String title)
	 {
		 matter=matter.append("<html><head><title>"+title+"</title> </head>\n"+
					"<body text=black bgcolor=#d1a9a9>");
	 }
	 
	 
	 public String returnPage()
	 {
		  matter=matter.append("</body></html>\n");
		  return (matter.toString());
	 }

	 public void addHeading(String title)
	 {
		  matter=matter.append("<H1><i>"+title+"</i></h1>\n");
	 }
	  
	 public void addCentralHeading(String title)
	 {
		  matter=matter.append("<CeNTER><H1><i>"+title+"</i></h1></CENTER>\n");
	 }

	  
	 public void addSubHeading(String title)
	 {
		  matter=matter.append("<H2><i>"+title+"</i></h2>\n");
	 }
	 
	 public void addCentralSubHeading(String title)
	 {
		  matter=matter.append("<CENTER><H2><i>"+title+"</i></h2></CENTER>\n");
	 }
 

	 //Error messages generated here
	 public void printError(PrintWriter out,String error)
	 {
		  this.addTitle("ERROR");
		  this.addText(error,"bold");
		  this.returnPage();
		  this.printHtml(out);
	 }

	 public void printError(PrintWriter out,String errorcode,String error,Exception e)
	 {
		  this.addTitle(errorcode);
		  this.addText(error,"bold");
		  this.addText(e.getMessage(),"bold");
		  this.returnPage();
		  this.printHtml(out);
	 }


	//Tables created with these functions
	 public void addTable(String title,String desc)
	 {
		  matter=matter.append("<table "+desc+" >\n");
		  matter=matter.append("<caption><h2>"+title+"</h2></caption>\n");
	 }
     
	 public void addTableHeader(String headers[])
	 {
		for (int i=0;i<headers.length;i++)
		  {
			matter=matter.append("<th>"+headers[i]+"</th>\n") ;
		  }
	 }

    	 
	 public void addTableElement(String rowdesc,String dataDesc,String element)
	 {
		matter=matter.append("<tr "+rowdesc+" >\n");
		matter=matter.append("<td "+dataDesc+" >"+element+"</td>\n") ;
		matter=matter.append("</tr>\n");
	 }

	 public void addTableElement(String element)
	 {
		matter=matter.append("<tr>\n");
		matter=matter.append("<td>"+element+"</td>\n") ;
		matter=matter.append("</tr>\n");
	 }
	 
	 public void addTableRow(String desc)
	 {
		  matter=matter.append("<tr "+desc+" >\n");
	 }

	 public void endTableRow()
	 {
		  matter=matter.append("</tr>\n");
	 }

	 public void addTableData(String desc)
	 {
		  matter=matter.append("<td "+desc+" >\n");
	 }
     
	 public void addTableData(String desc,String value)
	 {
		  matter=matter.append("<td "+desc+" >"+value+"</td>\n");
	 }

	 public void endTableData()
	 {
		  matter=matter.append("</td>");
	 }

	 public void returnTable()
	 {
		  matter=matter.append("</table>\n");
	 }

		//Forms created with these functions
	 public void addForm(String method , String action)
	 {  
		  matter = matter.append("<form method=" + method + " action=\"" + action +"\">\n" );
	 }
	  
	 
	 public void addInputValue(String type , String value )
	 {  
		  matter=matter.append("<input type=" + type + "  value=\"" + value + "\" >\n" );
	 	  matter=matter.append("</input>");
	 }

	 public void addInputName(String label ,String type , String name)
	 {
		  matter=matter.append(label + " <input type=" + type + "  name=\"" + name + "\" >\n" );	   
	 	  matter=matter.append("</input>");
	 }
		  
	 public void addInput(String label ,String type , String name ,String value)
	 { 
		  matter = matter.append(label + " <input type=" + type + "  name=\"" + name + "\"  value=\"" 
			                        + value + "\"  >\n") ;
	 	  matter=matter.append("</input>");
	 }
	 
	 public void addInput(String desc,String info)
	 {
		  matter.append("<input "+desc+">"+info+" </input>");
	 }
	 
	 public void returnForm()
	 {
		  matter=matter.append("</FORM>\n");
	 }
	 
	 // just add text
	public void addText(String text , String style)
	{   if (style.equals("bold")) 
		 matter = matter.append("<b> "+ text + " </b>");
		 else 
		 matter = matter.append("<it> "+ text + " </it>");
	}   	

//to add extra tags apart from form and table tags
	public void addElt(String str){
		 matter = matter.append(str);
	}





	//Basic page format style followed everywhere
	public void startPage(String title)
	{
		 addTitle("PARIKSHA:The Online Test Administration Utility");
		 addCentralHeading("PARIKSHA");
		 addCentralSubHeading("The Online Test Administration Utility");
		 addTable("<font color=maroon>"+title+"</font>","width=100%");
		 addTableRow("");
		 addTableData("width=30% height=300 bgcolor=maroon\n");
		 addTable("","");
	}

	public void setMenuItem(HtmlPage page)
	{
		 //default font color is red
		 matter=matter.append("<tr><td><font color=red>\n");
		 matter=matter.append(page.matter);
		 matter=matter.append("\n</font></font></tr>\n");
	}
	
	public void setMenuItem(String item)
	{
		 //default font color is red
		 matter=matter.append("<tr><td><font color=red>\n");
		 matter=matter.append(item);
		 matter=matter.append("\n</font></td></tr>\n");
	}
	
	public void startBody()
	{
		 returnTable();
		 endTableData();
		 addTableData("width=70% height=300 bgcolor=#731cff");
		 addTable("","");
	}

	public void setBodyItem(HtmlPage page)
	{
		 //default font color is white
		 matter=matter.append("<tr><td><font color=white>\n");
		 matter=matter.append(page.matter);
		 matter=matter.append("\n</font></td></tr>\n");
	}
	
	public void setBodyItem(String item)
	{
		 //default font color is white
		 matter=matter.append("<tr><font color=white><td>\n");
		 matter=matter.append(item);
		 matter=matter.append("\n</font></td></tr>\n");
	}
	
	public void setBodyItemRow(String item)
	{
		 //default font color is white
		 matter=matter.append("<tr><font color=white>\n");
		 matter=matter.append(item);
		 matter=matter.append("\n</font></tr>\n");
	}
	
	public void setBodyItemRow(HtmlPage page) 
	{
		 //default font color is white
		 matter=matter.append("<tr><font color=white>\n");
		 matter=matter.append(page.matter);
		 matter=matter.append("\n</font></tr>\n");
	}
	
	public void startFooter()
	{
		 returnTable();
		 endTableRow();
		 returnTable();
		 addTable("","align=center");
		 addTableRow("");
	}

	public void setFooterItem(HtmlPage page)
	{
		 matter=matter.append("<td>\n");
		 matter=matter.append(page.matter);
		 matter=matter.append("\n</td>\n");
	}
	
	public void setFooterItem(String item)
	{
		 //default font color is red
		 matter=matter.append("<td>\n");
		 matter=matter.append(item);
		 matter=matter.append("\n</td>\n");
	}
	
	public void endPage(String HTMLHOME)
	{
		 endTableRow();
		 returnTable();
		 addElt("<br><hr>");
		 addTable("","align=center");
		 addTableRow("");
		 addTableData("","<a href=\"http://"+HTMLHOME+"disclaim.html\">[Disclaimer]</a>");
		 addTableData("","<a href=\"http://"+HTMLHOME+"aboutUs.html\">[More about us]</a>");
		 addTableData("","<a href=\"http://"+HTMLHOME+"help.html\">[Help]</a>");
		 endTableRow();
		 returnTable();
		 addElt("<font color=red size=2>");
     	 addElt("<p align=center><i>Copyright 2000 ANA Softwares</i></p>");
     	 addElt("<p align=center><i>All rights reserved</i></p></font>"); 
		 returnPage();
	}

//Functions for Test creation part


	public void addQuestion(String body,String opt_count,String keyword)
	{
		  matter = matter.append("<form method=post action='http://everest.cse.iitb.ernet.in:9001/servlet/questionHandler'>\n"); 
		  matter = matter.append("<br> <table border=\"0\">\n"); 
		  matter = matter.append("<caption><h1>Question Details</h1></caption>\n"); 
		  matter = matter.append("<tr>\n"); 
		  matter = matter.append("<td bgcolor=\"red\"> <font size=5>Question statement</font></td>\n"); 
		  matter = matter.append("<td>"); 
		  matter = matter.append("<textarea  name=\"body\" rows=\"4\" cols=\"100\">"+body+"</textarea>\n" ); 
		  matter = matter.append("</td>\n"); 
		  matter = matter.append("</tr>\n"); 
		  matter = matter.append("<tr>\n"); 
		  matter = matter.append("<td bgcolor=\"red\"><font size=5>Keywords( for search referencing)</font></td>\n" ); 
		  matter = matter.append("<td>\n"); 
		  matter = matter.append("<input type=text name=\"keyword\" value="+keyword+" >\n"); 
		  matter = matter.append("</td>\n"); 
		  matter = matter.append("</tr>\n"); 
		  matter = matter.append("<tr>\n"); 
		  matter = matter.append("<td bgcolor=\"red\"><font size=5> Number of options </font></td>\n"); 
		  matter = matter.append("<td>\n"); 
		  matter = matter.append("<input  type=text  name=\"opt_count\" value="+opt_count+" >\n"); 
		  matter = matter.append("</td>\n"); 
		  matter = matter.append("</tr>\n");
		  matter = matter.append("</table>\n");
	}


//class ends	
}


