
create table People (ID varchar(10) not null primary key,
                     Type varchar(1) check(Type in('S','E','C')),
					 password varchar(10) not null);
create table PayScale (Grade varchar(3) not null primary key,
                       LowerLimit Number (9, 2) not null,
                       Increment1 Number (9, 2) not null,
                       MiddleLimit Number (9, 2),
                       Increment2 Number (9, 2),
                       UpperLimit Number (9, 2) not null);

create table Designation (Post varchar(10) not null Primary Key,
                          Grade varchar(3) not null references PayScale);

create table Admin (AdminId varchar(8)  not null primary key,
                    AdminType varchar(8)  check (AdminType in ('root', 'salary', 'dept', 'cash')),
                    Password varchar(10) not null);
insert into Admin values ('root', 'root', 'root');

create table Department (DeptName varchar(50) not null,
                         DeptCode varchar(2) not null Primary Key,
                         AcctNo number(12),
                         Description varchar(50),
                         SalaryAdminId varchar(8) not null references Admin, 
                         DeptAdminId varchar(8) not null references Admin);

create table Employee ( ID varchar(10) not null,
                        SalaryCode number(12) not null primary key,
						Name varchar(30) not null,
                        Address varchar(100),
                        DOB date not null,
                        OldPayStage number(9, 2),
						OldGrade varchar(3) references PayScale,
                        PrvIncrDate date,--date when empl last got promoted, etc
						CurPayStage number(9, 2) not null,
						--CurPayScale date not null :can be inferred from post
						WithholdIncFrom date,
						WithholdIncTill date,
						PayWithheldInc char(1) check (PayWithheldInc is null
							or PayWithheldInc in ('Y', 'N')),
						AcctNo number(12),
                        Sex varchar(1) check(sex in ('M', 'F')),
                        HasWorkedAfterIncr char(1) 
							check (HasWorkedAfterIncr is null or 
								HasWorkedAfterIncr in ('Y', 'N')),
						LastIncrAmount number(9, 2),
						HasOwnHouse varchar(1) check(HasOwnHouse in('Y', 'N')),
                        Email varchar(40),
                        DeptCode varchar(2) not null references Department,
						Post varchar(10) not null references Designation,
						LastCalculated date,
						TIsinceMarch number(9,2) not null,
						HRAsinceMarch number(9,2) not null,
						ITPaid number(9,2) not null, 
						foreign key(ID) references People,
						unique (ID));


create table Leave (SalaryCode number(12) not null references Employee,
                    LeaveType varchar(3) check (LeaveType in ('EL', 'HPL', 'CL', 'EOL', 'ML','PL', 'SDL', 'HL', 'SL')),
                    FromD Date not null,
                    ToD Date not null,
					MonthConsidered date);


create table OtherPay (SalaryCode number(12) not null,
                       SalaryDate date,
                       Description varchar(30) not null,
                       Amount number(9,2)  not null);

create table OtherDed (SalaryCode number(12) not null,
                       salarydate date,
                       Description varchar(30) not null,
                       Amount number(9,2)  not null);

create table LoanNames (LoanType varchar(20) not null primary key);

create table LoanRates (LoanType varchar(20) not null references LoanNames,
						ApplicableFrom date not null,
						InterestRate number(6,2) not null,
						primary key(LoanType,ApplicableFrom));

create table Loan (SalaryCode number(12)  not null references Employee,
                   LoanId varchar(12) not null primary key, 
                   Type varchar(20) not null references LoanNames, 
                   DateTaken date  not null,
				   PayInSalary char(1) not null 
				        check (PayInSalary in ('Y', 'N')),
                   AmountTaken number(9, 2)  not null,
                   DueAmount number(9,2)  not null,
                   InterestAccumulated number(9, 2) not null,
				   DedQuantum number(9,2) not null,
				   RecoveryStart number(2) not null,
				   MonthPaid date);

create  table Student (ID varchar(10) not null primary key,
                       Name varchar(30) not null,
                       Address varchar(100),
                       AcctNo number(12),
                       DeptCode varchar(2) not null references Department,
                       email varchar(40),
					   foreign key(ID) references People);


create table Bills (BillNo number(5) not null,
                    Amount number(9,2) not null,
                    EntryDate Date not null, 
                    Status varchar(1) check(Status in ('N','P')),
                    Type varchar(1) check(Type in ('R','P')),
                    Description varchar(50) not null,
					DeptCode varchar(2) not null references Department,
                    PayeeType varchar(1) check(PayeeType in ('S', 'E', 'C')),
                    PayeeId varchar(10)  not null references People,
					primary key(EntryDate,BillNo));

create table PayDetails (RecptNo number(5) not null,
                         PaytDate Date not null,
                         PaytMode varchar(1) check (PaytMode in ('C','Q')),
                         ChequeNo number(12),
						 ChequeStatus varchar(1) 
						 	check (ChequeStatus is null or
								ChequeStatus in ('P', 'B', 'C')),
                         BillNo number(5) not null, 
						 EntryDate date not null,
						 primary key (RecptNo, PaytDate),
						 unique (ChequeNo),
						 foreign key (EntryDate,BillNo) references Bills,
						 check (PaytMode in ('C') or chequeno is not null));

create table RateOfDA (ForMonth Date not null primary key,
                      Rate number(5, 2) not null);

create table Promotion (SalaryCode number(12) not null references Employee,
                      DateOfPromotion date not null,
                      NewPost varchar(10) not null references Designation,
		           	  IsResHigher varchar(1) not null
					      check (IsResHigher in ('Y', 'N')));

create table ITaxSD (LowerLimit number(9,2) not null,
					HigherLimit number(9,2)not null,
					SD number(9,2) not null,
					SDPercent number(5,2) not null,
					ITPercent number(5,2) not null,
					HRADeduction number(5,2) not null,
					WomenRebate number(9,2) not null,
					AddedAmt number(9,2) not null,
					Surcharge number(5,2) not null);

create table SalaryDetails
                   (SalaryCode number(12) not null references Employee,
				    SalaryDate date,
					Grade varchar(3) references payscale,
					PayStage number(9,2),
					BasicPay number(9,2) not null,
					DA number(9,2) not null,
					HRA number(9,2) not null,
					CCA number(9,2) not null, 
					TransAllowance number(9,2) not null,
					ConsulHon number(9,2) not null,
					OTA number(9,2) not null,
					CEA number(9,2) not null,
					OtherPays number(9,2) not null,
					GrossPay number(9,2) not null,
					CPFSubs number(9,2) not null, 
					CPFAdvRefund number(9,2) not null, 
					NPA number(9,2) not null, 
					ITax number(9,2) not null, 
					LicenseFee number(9,2) not null,
					WaterCharge number(9,2) not null,
					CurrentCharge number(9,2) not null,
					LIP number(9,2) not null, 
					PayAndAllowance number(9,2) not null,
					ProfessionTax number(9,2) not null,
					GroupIns number(9,2) not null,
					OtherDeds number(9,2) not null, 
					TotalDed number(9,2) not null,
					NetSalary number(9,2) not null,
					BillNo number(9,2),
					BillDate date,
					foreign key (BillDate, BillNo) references Bills);

