
create table People (ID varchar(10) not null primary key,
                     Type varchar(1) check(Type in('S','E','C')),
					 password varchar(10) not null);
create table PayScale (Grade varchar(3) not null primary key,
                       LowerLimit Number (9, 2) not null,
                       Increment1 Number (9, 2) not null,
                       MiddleLimit Number (9, 2),
                       Increment2 Number (9, 2),
                       UpperLimit Number (9, 2) not null);

create table Designation (Post varchar(10) not null Primary Key,
                          Grade varchar(3) not null references PayScale);

create table Admin (AdminId varchar(8)  not null primary key,
                    AdminType varchar(8)  check (AdminType in ('root', 'salary', 'dept', 'cash')),
                    Password varchar(10) not null);


create table Department (DeptName varchar(50) not null,
                         DeptCode varchar(2) not null Primary Key,
                         AcctNo number(12),
                         Description varchar(50),
                         SalaryAdminId varchar(8) not null references Admin, 
                         DeptAdminId varchar(8) not null references Admin);

create table Employee ( ID varchar(10) not null Primary Key,
                        SalaryCode number(10) not null,
						Name varchar(30) not null,
                        Address varchar(100),
                        DOB date not null,
                        OldPayStage number(9, 2),
						OldGrade varchar(3) references PayScale,
                        PrvIncrDate date,--date when empl last got promoted, etc
						CurPayStage number(9, 2) not null,
						--CurPayScale date not null :can be inferred from post
						AcctNo number(12),
                        Sex varchar(1) check(sex in ('M', 'F')),
                        HasOwnHouse varchar(1) check(HasOwnHouse in('Y', 'N')),
                        Email varchar(40),
                        DeptCode varchar(2) not null references Department,
						Post varchar(10) not null references Designation,
						foreign key(ID) references People,
						unique (salarycode));


create table Leave (ID varchar(8) not null references Employee,
                    LeaveType varchar(3) check (LeaveType in ('EL', 'HPL', 'CL', 'EOL', 'ML','PL', 'SDL', 'HL', 'SL')),
                    FromD Date not null,
                    ToD Date not null,
					EntryDate date not null);

--create table OtherPay (ID varchar(8) not null references Employee,
--                       Description varchar(10) not null,
--                       Amount number(9,2)  not null);

--create table OtherDed (ID varchar(8) not null references Employee,
--                       Description varchar(10) not null,
--                       Amount number(9,2)  not null);

--create table Loan (ID varchar(8)  not null references Employee,
--                   LoanId varchar(12) not null primary key, 
--                   Type varchar(10) not null,
--                   DateTaken date  not null,
--                   Amount number(9, 2)  not null,
--                   DueAmount  number(9,2)  not null,
--                   DedQuantum number(9,2) not null);

create  table Student (ID varchar(10) not null primary key,
                       Name varchar(30) not null,
                       Address varchar(100),
                       AcctNo number(12),
                       DeptCode varchar(2) not null references Department,
                       email varchar(40),
					   foreign key(ID) references People);


create table Company (ID varchar(10) not null primary key,
                      Name varchar(20) not null,
                      Address varchar(50),
                      Acctno number(12),
                      ContractCode varchar(12),
                      Description varchar(30),
					  foreign key(ID) references People);

create table Bills (BillNo number(5) not null,
                    Amount number(9,2) not null,
                    EntryDate Date not null, 
                    Status varchar(1) check(Status in ('N','P')),
                    Type varchar(1) check(Type in ('R','P')),
                    Description varchar(50) not null,
					DeptCode varchar(2) not null references Department,
                    PayeeType varchar(1) check(PayeeType in ('S', 'E', 'C')),
                    PayeeId varchar(10)  not null references People,
					primary key(EntryDate,BillNo));

create table PayDetails (RecptNo number(5) not null primary key,
                         PaytDate Date not null,
                         PaytMode varchar(1) check (PaytMode in ('C','Q')),
                         ChequeNo number(12),
                         BillNo number(5) not null, 
						 EntryDate date not null,
						 foreign key (EntryDate,BillNo) references Bills,
						 check (PaytMode in ('C') or chequeno is not null));

create table Section (ID number(12) not null primary key,
                      Name varchar(20) not null,
                      Address varchar(50),
                      AcctNo number(12),
                      Description varchar(30));
