
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.lang.*;

class CashAdmin extends Admin
{
	static Connection conn = null;
	public CashAdmin(String i, PrintWriter toClient, AdminServlet as)
	{
		id = i;
		termlist.addElement("$USER$:" + id);
		as.putHtml(toClient, "cashamain.html", termlist);
	}
	public void doPost(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
		String formname;
		if ((formname = req.getParameter("formname")) == null)
		{
			toClient.println("Error: Invalid form");
			return;
		}
		else if (formname.equals("chpwadmin"))
		    ModifyPasswd(req,toClient,as); 
		else if (formname.equals("billinfo"))
            BillsInfo(req, toClient, as);
		else if (formname.equals("billclear"))
            BillClear(req, toClient, as);
		else if (formname.equals("allpbillsinfo"))
            AllPBillsInfo(req, toClient, as);
		else if (formname.equals("allbchequesinfo"))
            AllBChequesInfo(req, toClient, as);
		else if (formname.equals("allpchequeinfo"))
            AllPChequeInfo(req, toClient, as);
	    else if (formname.equals("chequestatus"))
		    CheqStatus(req, toClient, as);
		else
		{
			toClient.print("Error: Invalid form");
			return;
		}
	}

	public void doGet(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
		String action;
		if ((action = req.getParameter("action")) == null)
		{
			toClient.print("Error: Invalid form");
			return;
		}
        else if (action.equals("billclearreq"))
            BillClearReq(req, toClient, as);
		else
		{
			toClient.print("Error: Invalid action");
			return;
		}
	}
	void BillsInfo(HttpServletRequest req, PrintWriter toClient, 
			AdminServlet as)
	{
		Statement stmt = null;
		ResultSet rs = null;
		try
		{
			toClient.println("<html><head><title>Details of Bills" +
				"</title></head>" +
				"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
				"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>");
			stmt = as.conn.createStatement();
			String doe = req.getParameter("entrydate").trim().toLowerCase(),
			       bn = req.getParameter("billno").trim().toLowerCase();
			if (doe.length() == 0 || bn.length() == 0)
				throw new Exception("You cant leave any of the fields blank");
		   
			rs = stmt.executeQuery("select BillNo, Amount, EntryDate, " +
				 "Status, Type, bills.Description,DeptName,PayeeType," +
				 "PayeeId from Bills, department" +
				 " where EntryDate=to_date('" + doe + "', 'dd-mm-yyyy') " +
				 "and BillNo='" + bn + "' and bills.deptcode = department.deptcode");
	
			if (rs.next())
			{
				toClient.println("Click on the Bill No to settle the Bills<br> " +
					"<table><tr><th>BillNo" + 
					"<th>Amount <th>Status" +
					"<th>Type <th>Description <th>Issuing Dept<th>" +
					"PayeeType <th>PayeeID");
				if (rs.getString(4).equals("P"))
				{
					toClient.println("<th>Recipt No<th>Payment Mode<th>" +
						"Cheque No");
				}
				String d = Utility.toString(rs.getDate(3)), n = rs.getString(1),
					t = "";
				if (rs.getString(5).equals("P"))
					t = "Payment";
				else
					t = "Reciept";
				toClient.println("<tr><td>" + Utility.toBillNo(d, n) +
					"<td>" + rs.getString(2) + 
					"<td>" + rs.getString(4) + "<td>" + t +
					"<td>" + rs.getString(6) + "<td>" + rs.getString(7) +
					"<td>" + rs.getString(8) + "<td>" + rs.getString(9));
				if (rs.getString(4).equals("P"))
				{
					ResultSet rs2 = stmt.executeQuery("select RecptNo, " +
						"Paytdate, PaytMode, ChequeNo from PayDetails where " +
						"BillNo = " + rs.getString(1) + " and EntryDate = " +
						"to_Date('" + Utility.toString(rs.getDate(3)) + 
						"', 'DD-MM-YYYY')");
					if (!rs2.next())
						throw new Exception("Corrupted DataBase");
					String pm = "Cash", cn = "null";
					if (rs2.getString(3).equals("Q"))
					{
						pm = "Cheque"; cn = rs2.getString(4);
					}
					toClient.println("<td>" + 
						Utility.toBillNo(rs2.getDate(2), rs2.getString(1)) +
						"<td>" + pm + "<td>" + cn);
					toClient.println("</table><br><br>Bill is already in " +
						"Non-Pending state");
				}
				else
					toClient.println("</table><br><br><a href=\"http://" + 
						as.hostname + ":" + as.serverport + 
						"/servlet/AdminServlet?action=billclearreq&" +
						"billno=" + bn + "&entrydate=" + doe + "\">" +
						"Settle Bill</a>");
			}
			else	
		  		throw new Exception("No entry found");   
			toClient.println("</body></html>");
		}
		catch (Exception e)
		{
			Utility.printError(toClient, e);
		}
		try
		{
			stmt.close();
			rs.close();
		}
		catch (Exception e) {}
	}

	
	synchronized void BillClear(HttpServletRequest req, PrintWriter toClient, 
			AdminServlet as)
	{
		Statement stmt = null;
		ResultSet rs = null;
		try
		{
			toClient.println("<html><head><title>Response to Bill Clear</title></head>" +
				"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
				"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
			String doe = req.getParameter("entrydate").trim().toLowerCase(),
				bn = req.getParameter("billno").trim().toLowerCase(),
				paytmode = req.getParameter("paytmode"),
				chequeno = req.getParameter("chequeno").trim();
			if (!(paytmode.equals("Q") && Utility.toInt(chequeno) != 0) &&
			  !paytmode.equals("C"))
				throw new Exception("Invalid Data entered");
			if (conn == null)
			{
				conn = as.getNewConnection();
				conn.setAutoCommit(false);
			}
			stmt = conn.createStatement();
			rs = stmt.executeQuery("select Status from Bills where" +
				" BillNo=" + bn + " and EntryDate=to_Date('" + doe +
				"', 'dd-mm-yyyy') order by entrydate, billno");
			if (!rs.next())
				throw new Exception("No such bill to settle");
			if (rs.getString(1).equals("P"))
			{
				rs = stmt.executeQuery("select * from paydetails where " +
					"billno=" + bn + " and EntryDate = to_Date('" + 
					doe + "', 'dd-mm-yyyy') and chequestatus = 'B'");
				if (!rs.next())
					throw new Exception("Bill has already been settled");
				else
					stmt.executeUpdate("delete from paydetails where " +
						"billno=" + bn + " and EntryDate = to_Date('" + 
						doe + "', 'dd-mm-yyyy') and chequestatus = 'B'");
			}
			int recptno = as.getNewReciptNo();
			String dt = Utility.toString(new java.util.Date());
			stmt.executeUpdate("update bills set status = 'P' where billno=" +
				bn + " and EntryDate = to_Date('" + doe + "', 'dd-mm-yyyy')");
			String chequestatus = "null";
			if (paytmode.equals("C"))
				chequeno = "null";
			else
				chequestatus = "'P'";
			stmt.executeUpdate("insert into paydetails (recptno, Paytdate," +
				"PaytMode, ChequeNo, BillNo, EntryDate, ChequeStatus) values (" +
				recptno + ", to_Date('" + dt + "', 'dd-mm-yyyy'), '" + 
				paytmode + "', " + chequeno + ", " + bn + ", to_Date('" + 
				doe + "', 'dd-mm-yyyy'), " + chequestatus + ")");
			conn.commit();
			try
			{
				toClient.print("Bill No <b>" + Utility.toBillNo(doe, bn) +
					"</b> has succesfully been settled<br><br>");
			}
			catch (Exception e)
			{
				System.out.println("Exception: " + e);
			}
	  	}
		catch (Exception e)
		{
			Utility.printError(toClient, e);
			try
			{
				conn.rollback();
			} catch (Exception e2) {}
		}
		try
		{
			stmt.close();
			rs.close();
		}
		catch (Exception e) {}
	}

	void BillClearReq(HttpServletRequest req, PrintWriter toClient, 
		AdminServlet as)
	{
	  try
	  {
		String doe = req.getParameter("entrydate").trim().toLowerCase(),
		       bn = req.getParameter("billno").trim().toLowerCase();
		toClient.println("<html><title>Clearance of bill " + 
			Utility.toBillNo(doe, bn) + "</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>" +
			"<form action=http://" + as.hostname + ":" + as.serverport + 
			"/servlet/AdminServlet method=POST>" + 
			"<input type=hidden name=formname value=\"billclear\">" +
			"<input type=hidden name=billno value=\"" + bn + "\">" +
			"<input type=hidden name=entrydate value=\"" + doe + "\">" +
			"<br>Choose payment-mode" +
			"<br><select name=paytmode><option value=C selected>Cash" +
			"<option value=Q>Cheque</select><br>If cheque, enter cheque no." +
			"<br><input type=text name=chequeno>" + 
			"<BR><input type=submit value=\"Settle\"><input type=reset>" +
			"</form></body></html>");
	  }
	  catch (Exception e)
	  {
		Utility.printError(toClient, e);
	  }
	}
	
	synchronized void CheqStatus(HttpServletRequest req, PrintWriter toClient,AdminServlet as)  
	{
	  ResultSet rs = null;
	  Statement stmt = null;
	  try
	  {  
		stmt = as.conn.createStatement();
		toClient.println("<html><head><title>Changing status of bills" +
			"</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle1.css\"><body>");
		int counter = Utility.toInt(req.getParameter("counter"));
		for(int i=1 ; i <= counter; i++)
		{
		  String chequeno = null;
		  try
		  {
			String chqstatus = req.getParameter("chequestat" + i); 
			chequeno = req.getParameter("chequeno" + i);
			if (chqstatus.equals("pending"))
				continue;
			rs = stmt.executeQuery("select chequestatus from PayDetails " +
				"where ChequeNo=" + chequeno);
			if (!rs.next())
				throw new Exception("No Payment with cheque number " + 
					chequeno);
			else if (!rs.getString(1).equals("P"))
				throw new Exception("Cheque " + chequeno + 
					" has already been " + 
					(rs.getString(1).equals("B") ? "bounced" : "cleared"));
			//Clear Cheque 
			stmt.executeUpdate("update PayDetails set chequestatus='" +
				(chqstatus.equals("clear") ? "C" : "B") + 
				"'where chequeno=" + chequeno);  
			toClient.println("<br>Cheque " + chequeno + " has been " + 
				chqstatus + "ed");
		  }
		  catch (Exception e)
		  {
		  		toClient.println("<br>Error processing " + chequeno +
					": " + e);
		  }
		}
		toClient.println("<br><br>End of transaction");
	  }
	  catch (Exception e)
	  {
		Utility.printError(toClient, e); 
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
    }
	  
	void AllPBillsInfo(HttpServletRequest req, PrintWriter toClient, 
			AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		stmt = as.conn.createStatement();
		String whomtosend = req.getParameter("whomtosend"),
			who = req.getParameter("who"),
			id = req.getParameter("id");
		int days = 0;
		if (whomtosend.equals("allxdays"))
		{
			try {days = Utility.toInt(req.getParameter("days"));}
			catch (Exception e)
			{throw new Exception("Invalid value for days given");}
		}
		String action = req.getParameter("action");
		try
		{
			stmt.executeQuery("select * from tmpview");
		}
		catch (Exception e)
		{
			stmt.executeUpdate("create view tmpview as select id, email from " +
				"student union select id, email from employee");
		}
		String query = "select BillNo, Amount, EntryDate, " +
				 "Status, Type, bills.Description, DeptName, PayeeType," +
				 "PayeeId, email from Bills, department, tmpview where " +
				 " (status = 'N' or (status ='P' and (billNo, EntryDate) " +
				 	" in (select BillNo, EntryDate from PayDetails where " +
					"chequestatus = 'B'))) " +
				 "and id = PayeeId and bills.deptcode = department.deptcode ";
		java.util.Date d = new java.util.Date();
		java.util.Date dm = new java.util.Date();
		dm.setDate(d.getDate()); 
		if (days != 0)
		{
			query += " and to_date('" + Utility.toString(d) + 
				"', 'dd-mm-yyyy') - EntryDate >= " + days;
		}
		if (!who.equals("all"))
			query += " and id = '" + id + "' ";
		query += " order by PayeeId ASC, EntryDate DESC, billno DESC";
		rs = stmt.executeQuery(query);
		//Pass this info to a thread that will send all mails.
		if (action.equals("view"))
		{
			//Show bill info
			toClient.println("<html><head><title>Details of all pending bills");
			if (days != 0)
				toClient.println(" for " + days + " days");
			if (!who.equals("all"))
				toClient.println(" of " + id);
			toClient.println("</title></head>" +
				"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
				"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>" +
				//"<form action=http://" + as.hostname + ":" + 
				//as.serverport + "/servlet/AdminServlet method=POST>" +
				//"<input type=hidden name=formname value=clearbillgrpreq>" +
				"<table><tr><th>BillNumber" + 
				"<th>Amount<th>Type<th>Description <th>Issuing Dept<th>" +
				"PayeeType <th>PayeeID");
			//int counter = 1;
			while (rs.next())
			{
				String dd = Utility.toBillNo(rs.getDate(3), rs.getString(1)), 
					n = rs.getString(1), t = "";
				java.util.Date dat= rs.getDate(3);	
				if (rs.getString(5).equals("P"))
					t = "Payment";
				else
					t = "Receipt";
				toClient.println("<tr><td><a href=http://" + as.hostname + ":" + as.serverport  + 
					"/servlet/AdminServlet?action=billclearreq&billno=" + Utility.repl("0", 5 - n.length()) + n +
					"&entrydate=" + Utility.toString(dat) +">" + dd + "</a><td>"+ rs.getString(2) + "<td>" + t + "<td>" + 
					rs.getString(6) + "<td>" + rs.getString(7) + "<td>");
				//toClient.println("<tr><td><input type=checkbox " +
				//	"name=\"cb" + counter + "\"><td>" +
				//	dd + "<td>"+ rs.getString(2) + "<td>" + t + "<td>" + 
				//	rs.getString(6) + "<td>" + rs.getString(7) + "<td>");
				if (rs.getString(8).equals("S"))
					toClient.print("Student");
				else if (rs.getString(8).equals("E"))
					toClient.print("Employee");
				else 
					toClient.print("Company");
				toClient.print("<td>" + rs.getString(9));
				//toClient.println("<input type=hidden name=billno" + counter +
				//	" value=\"" + rs.getString(1) + "\">" +
				//	"<input type=hidden name=entrydate" + counter +
				//	" value=\"" + Utility.toString(rs.getDate(3)) + "\">");
				//counter++;
			}
			//toClient.println("</table><br><input type=submit " +
			//	"value=\"Settle\"></td><td><input type=reset>");
			toClient.println("</table><br>Note:type indicated role of" +
				" department.<br></body></html>");
			//toClient.println("<br>Note:type indicated role of" +
			//	" department.<br>Select the checkbox against the bill(s) you" +
			//	" want to be settled and click Settle </form></body></html>");
		}
		else
		{
			Mailer mailer = new Mailer(rs, as, days, stmt);
			mailer.start();
			toClient.println("<html><head><title>Reminder</title></head></html>" +
				"The mails are being sent. You may resume with your normal work." +
				"<b>Note</b>If a person does not have an email address, you will" +
				"have to remind him by other ways");
	  	}
	  }
	  catch (Exception e)
	  {	
		Utility.printError(toClient, e);
	  }
	}
	void AllPChequeInfo(HttpServletRequest req, PrintWriter toClient, 
			AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		stmt = as.conn.createStatement();
		String whomtosend = req.getParameter("whomtoview");
		int days = 0;
		if (whomtosend.equals("allxdays"))
		{
			try {days = Utility.toInt(req.getParameter("days"));}
			catch (Exception e)
			{throw new Exception("Invalid value for days given");}
		}
		String query = "select Bills.BillNo, Amount, Bills.EntryDate, " +
			"Status, Type, bills.Description, DeptName, PayeeType," +
			"PayeeId, RecptNo, PaytDate, ChequeNo " +
			" from Bills, department, tmpview, payDetails where " +
			"status ='P' and Bills.BillNo = PayDetails.BillNo and " +
			"Bills.EntryDate = PayDetails.EntryDate and " +
			"chequestatus = 'P' " +
			"and id = PayeeId and bills.deptcode = department.deptcode ";
		java.util.Date d = new java.util.Date();
		java.util.Date dm = new java.util.Date();
		dm.setDate(d.getDate()); 
		if (days != 0)
		{
			query += " and to_date('" + Utility.toString(d) + 
				"', 'dd-mm-yyyy') - Bills.EntryDate >= " + days;
		}
		query += " order by PayeeId ASC, PaytDate DESC, RecptNo DESC";
		rs = stmt.executeQuery(query);
		//Show bill info
		toClient.println("<html><head><title>Details of bills waiting for " +
			"cheque clearance");
		if (days != 0)
			toClient.println(" for " + days + " days");
		toClient.println("</title></head>" +
			"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
			"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>" +
			"<form action=\"http://" + as.hostname + ":" + 
			as.serverport + "/servlet/AdminServlet\" method=POST>" +
			"<input type=hidden name=formname value=\"chequestatus\">" +
			"<table><tr><th>BillNumber" + 
			"<th>Amount<th>Type<th>Description <th>Issuing Dept<th>" +
			"PayeeType <th>PayeeID<th>Recipt No<th>Cheque No" +
			"<th>Status");
		int counter = 1;
		while (rs.next())
		{
			String dd = Utility.toBillNo(rs.getDate(3), rs.getString(1)), 
				n = rs.getString(1), t = "";
			java.util.Date dat= rs.getDate(3);	
			if (rs.getString(5).equals("P"))
				t = "Payment";
			else
				t = "Receipt";
			toClient.println("<tr><td>" + dd + "<td>" + rs.getString(2) +
				"<td>" + t + "<td>" + rs.getString(6) + "<td>" + 
				rs.getString(7) + "<td>");
			if (rs.getString(8).equals("S"))
				toClient.print("Student");
			else if (rs.getString(8).equals("E"))
				toClient.print("Employee");
			else 
				toClient.print("Company");
			toClient.print("<td>" + rs.getString(9) + "<td>" +
				Utility.toBillNo(rs.getDate(11), rs.getString(10)) + 
				"<td>" + rs.getString(12) + "<td>" +
				"<select name=chequestat" + counter + ">" +
					"<option value=pending selected>Pending" +
					"<option value=clear>Cleared" +
					"<option value=bounce>Bounced" +
				"</select>" +
				"<input type=hidden name=chequeno" + counter +
				" value=\"" + rs.getString(12) + "\">");
			counter++;
		}
		toClient.println("</table><br><input type=submit " +
			"value=\"Settle\"></td><td><input type=reset>");
    	toClient.println("<input type=hidden name=counter value=\"" 
			+ --counter + "\">"); 
		toClient.println("<br>Note:type indicated role of" +
			" department.<br>Select the appropriate option against the " +
			"cheque(s) you want to be cleared/bounced and click Settle!" +
			"</form></body></html>");
	  }
	  catch (Exception e)
	  {	
		Utility.printError(toClient, e);
	  }
	  try
	  {
	  	stmt.close();
		rs.close();
	  } catch (Exception e) {}
	}
	void AllBChequesInfo(HttpServletRequest req, PrintWriter toClient, 
			AdminServlet as)
	{
	  Statement stmt = null;
	  ResultSet rs = null;
	  try
	  {
		stmt = as.conn.createStatement();
		String whomtosend = req.getParameter("whomtosend"),
			who = req.getParameter("who"),
			id = req.getParameter("id");
		int days = 0;
		if (whomtosend.equals("allxdays"))
		{
			try {days = Utility.toInt(req.getParameter("days"));}
			catch (Exception e)
			{throw new Exception("Invalid value for days given");}
		}
		String action = req.getParameter("action");
		try
		{
			stmt.executeQuery("select * from tmpview");
		}
		catch (Exception e)
		{
			stmt.executeUpdate("create view tmpview as select id, email from " +
				"student union select id, email from employee");
		}
		String query = "select Bills.BillNo, Amount, Bills.EntryDate, " +
			"Status, Type, bills.Description, DeptName, PayeeType," +
			"PayeeId, RecptNo, PaytDate, ChequeNo, email " +
			" from Bills, department, tmpview, payDetails where " +
			"status ='P' and Bills.BillNo = PayDetails.BillNo and " +
			"Bills.EntryDate = PayDetails.EntryDate and " +
			"chequestatus = 'B' " +
			"and id = PayeeId and bills.deptcode = department.deptcode ";
		java.util.Date d = new java.util.Date();
		java.util.Date dm = new java.util.Date();
		dm.setDate(d.getDate());
		if (days != 0)
		{
			query += " and to_date('" + Utility.toString(d) + 
				"', 'dd-mm-yyyy') - Bills.EntryDate >= " + days;
		}
		if (!who.equals("all"))
			query += " and id = '" + id + "' ";
		query += " order by PayeeId ASC, EntryDate DESC, billno DESC";
		rs = stmt.executeQuery(query);
		if (action.equals("view"))
		{
			toClient.println("<html><head><title>Details of all bounced " +
				"cheques");
			if (days != 0)
				toClient.println(" and bill pending for more than " +
					days + " days");
			if (!who.equals("all"))
				toClient.println(" of " + id);
			toClient.println("</title></head>" +
				"<LINK rel=\"Stylesheet\" type=\"text/css\""  +
				"href=\"" + as.SName() + "?cssfile=MyStyle2.css\"><body>" +
				"<table><tr><th>BillNumber" + 
				"<th>Amount<th>Type<th>Description <th>Issuing Dept<th>" +
				"PayeeType <th>PayeeID<th>Recipt No<th>Cheque No");
			while (rs.next())
			{
				String dd = Utility.toBillNo(rs.getDate(3), rs.getString(1)), 
					n = rs.getString(1), t = "";
				java.util.Date dat= rs.getDate(3);	
				if (rs.getString(5).equals("P"))
					t = "Payment";
				else
					t = "Receipt";
				toClient.println("<tr><td>" + dd + "<td>" + rs.getString(2) +
					"<td>" + t + "<td>" + rs.getString(6) + "<td>" + 
					rs.getString(7) + "<td>");
				if (rs.getString(8).equals("S"))
					toClient.print("Student");
				else if (rs.getString(8).equals("E"))
					toClient.print("Employee");
				else 
					toClient.print("Company");
				toClient.print("<td>" + rs.getString(9) + "<td>" +
					Utility.toBillNo(rs.getDate(11), rs.getString(10)) + 
					"<td>" + rs.getString(12));
			}
			toClient.println("</table><br>Note:type indicated role of" +
				" department.<br></body></html>");
		}
		else
		{
			BChequeMailer mailer = new BChequeMailer(rs, stmt, as, days);
			mailer.start();
			toClient.println("<html><head><title>Notification of cheque " +
				"bounce</title></head></html> The mails are being sent. " +
				"You may resume with your normal work. <b>Note</b>If a " +
				"person does not have an email address, you will" +
				"have to remind him by other ways");
	  	}
	  }
	  catch (Exception e)
	  {	
		Utility.printError(toClient, e);
	  }
	}
		
}
